#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Genereal Ledger
#
#======================================================================


use SL::dataentry1;

1;

sub add {

  $form->{title} = "Add";

  $form->{callback} = "$form->{script}?action=add&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&arap=$form->{arap}";

 if($form->{transdate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{transdate};
 }
  # we use this only to set a default date
  dataentry1->transaction(\%myconfig, \%$form);

if($lastdate){
 $form->{transdate}=$lastdate;
$form->{batch}=$lastbatch;
}

  $form->{rowcount} = 1;
	$form->{"invnumber_1"}=$form->{prefix}.1;
  &display_form;

}

sub display_form {
 
  &form_header;
  $form->{rowcount}++;

  for $i (1 .. $form->{rowcount}) {
    if($i == 1 ){
    	$form->{"transtype_$i"}=$form->{"transtype"};
    	$form->{"transno_$i"}=$form->{"transno"};
	if(!$form->{"transdate_$i"}){
    		$form->{"transdate_$i"}=$form->{"transdate"};
	}
 #	$form->{"invnumber_$i"}++;
   }
    if($i == $form->{rowcount}){
    	$y = $form->{rowcount}-1;
    	$form->{"transtype_$i"}=$form->{"transtype_$y"};
    	$form->{"batch_$i"}=$form->{"batch_$y"};
	$form->{"transno_$i"}=$form->{"transno_$y"};
    	$form->{"transno_$i"}++;
    	$form->{"subtransno_$i"}=$form->{"subtransno_$y"};
    	$form->{"transdate_$i"}=$form->{"transdate_$y"};
     	$form->{"invnumber_$i"}=$form->{"invnumber_$y"};
	$form->{"invnumber_$i"}++;
   }
	&form_row($i);
  }



  if(!$form->{"nextfocus"}){
	$form->{"nextfocus"}  = "transno_$form->{rowcount}";
 }

  &form_footer;

}



sub form_row {
  my $i = shift;



  print qq|<tr>
  <td>$i</td>
  <td><input name="transtype_$i"  size=4 value="$form->{"transtype_$i"}">-<input name="batch_$i" size=6 value="$form->{"batch_$i"}">-<input name="transno_$i"  size=4 value="$form->{"transno_$i"}"><input name="subtransno_$i"  size=2 value="$form->{"subtransno_$i"}"></td>
  <td><input name="transdate_$i" size=10 value=$form->{"transdate_$i"}></td>
  <td><input name="invnumber_$i" size=20 value="$form->{"invnumber_$i"}"></td>
  <td><input name="amount_$i" size=10 value=$form->{"amount_$i"}></td>
  <td><input name="notes_$i" size=10 value="$form->{"notes_$i"}"></td>

</tr>
<input type=hidden name=rowcount value=$i>


|;


}


sub form_header {

  $title = $form->{title};
  $form->{title} = $locale->text("$title ");

# $locale->text('Add General Ledger Transaction')
# $locale->text('Edit General Ledger Transaction')

  map { $form->{$_} =~ s/"/&quot;/g } qw(source description chart);

  if (($rows = $form->numtextrows($form->{description}, 50)) > 1) {
    $description = qq|<textarea name=description rows=$rows cols=50 wrap=soft>$form->{description}</textarea>|;
  } else {
    $description = qq|<input name=description size=50 value="$form->{description}">|;
  }


  $colspan = 6;


  $form->header;

  print qq|
<script>
<!--
function stb(){document.myform.$form->{nextfocus}.focus();parent.document.title ="$form->{title}";}
// -->
</script>

<body bgcolor=ffffff onLoad=stb()>

<form method=post name=myform action=$form->{script}>

<input name=id type=hidden value=$form->{id}>
<input name=accno type=hidden value=$form->{accno}>
<input name=salesaccno type=hidden value=$form->{salesaccno}>
<input name=cashaccno type=hidden value=$form->{cashaccno}>
<input name=in_out type=hidden value=$form->{in_out}>
<input name=customer_number type=hidden value=$form->{customer_number}>
<input type=hidden name=arap value=$form->{arap}>
<input type=hidden name=prefix value=$form->{prefix}>

<input type=hidden name=transno value=$form->{transno}>
<input type=hidden name=transtype value=$form->{transtype}>
<input type=hidden name=batch value=$form->{batch}>
<input type=hidden name=subtransno value=$form->{subtransno}>

<input name=chart type=hidden value="$form->{chart}">
<input type=hidden name=closedto value=$form->{closedto}>
<input type=hidden name=locked value=$form->{locked}>
<input type=hidden name=title value="$title">

<table border=1>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>
<table border=0>

<tr>
  <th align=right>|.$locale->text('Book No.').qq|</th>
  <td><input name=book  size=6 value="$form->{book}"></td>
</tr>


</table>
</td></tr>

<tr class=listheading bgcolor=336666>

  <th><font color=ffffff>|.$locale->text('No.').qq|</th>
  <th><font color=ffffff>|.$locale->text('Trans No.').qq|</th>
  <th><font color=ffffff>|.$locale->text('Date').qq|($myconfig{dateformat})</th>
  <th><font color=ffffff>|.$locale->text('CS No.').qq|</th>
  <th><font color=ffffff>|.$locale->text('Amount').qq|</th>
  <th><font color=ffffff>|.$locale->text('Description').qq|</th>

</tr>
|;

}


sub form_footer {

  print qq|

<input name=nextfocus type=hidden value="$form->{nextfocus}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<input name=callback type=hidden value="$form->{callback}">

</table>

<br>
|;

  $transdate = $form->datetonum($form->{transdate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);

  if ($form->{id}) {
    print qq|<input class=submit type=submit name=action value="|.$locale->text('Update Form').qq|">
|;

    if (!$form->{revtrans}) {
      if (!$form->{locked}) {
	print qq|
	<input class=submit type=submit name=action value="|.$locale->text('Post Transaction').qq|">
	<input class=submit type=submit name=action value="|.$locale->text('Delete Transaction').qq|">
|;
      }
    }

    if ($transdate > $closedto) {
      print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Post As New Transaction').qq|">
|;
    }

  } else {
    if ($transdate > $closedto) {
      print qq|<input class=submit type=submit name=action value="|.$locale->text('Update Form').qq|">
      <input class=submit type=submit name=action value="|.$locale->text('Post Transaction').qq|">|;
    }
  }

  print "</form>

</body>
</html>
";

}


sub update_form {
 if($form->{transdate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{transdate};
 }
  # we use this only to set a default date
  dataentry1->transaction(\%myconfig, \%$form);

if($lastdate){
 $form->{transdate}=$lastdate;
$form->{batch}=$lastbatch;
}


  @a = ();
  $count = 0;
  @flds = (qw(transno transtype batch subtransno transdate invnumber amount ));

  for $i (1 .. $form->{rowcount}) {
    unless ( ($form->{"amount_$i"} eq "")) {
      # take accno apart
    #  if($form->{"accno1_$i"}){
	#($form->{"accno_$i"}) =($form->{"accno1_$i"})
    #  }else{
     # ($form->{"accno_$i"}) = split(/--/, $form->{"accno_$i"});
    # }

      push @a, {};
      $j = $#a;

      map { $a[$j]->{$_} = $form->{"${_}_$i"} } @flds;
      $count++;
    }
  }

  for $i (1 .. $count) {
    $j = $i - 1;
    map { $form->{"${_}_$i"} = $a[$j]->{$_} } @flds;
  }

  for $i ($count + 1 .. $form->{rowcount}) {
    map { delete $form->{"${_}_$i"} } @flds;
  }

  $form->{rowcount} = $count;

	$x =$form->{rowcount}+1;
	$form->{"nextfocus"}  = "transno_$x";

   	&display_form;

}

sub post_transaction {

  # check if there is something in source and date
  #$form->isblank("source", $locale->text('Source missing!'));
  #$form->isblank("transdate", $locale->text('Transaction Date missing!'));


  $rc = dataentry1->post_transaction(\%myconfig, \%$form);

  if ($rc == -1) {
    $form->error($locale->text("Cannot have a value in both Debit and Credit!"));
  }

  if ($rc == -2) {
    $form->error($locale->text("Customer or Vendor not found!"));
  }

  $form->isposted($rc);

}
