#=====================================================================
# SQL-Ledger, Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Order entry module
#
#======================================================================


use SL::OE;
use SL::IR; 
use SL::IS;

   
$form->{print_so_mod}="print_so" if !$form->{print_so_mod};
#$form->{must_select_item}="true";
	$form->{show_all_price}="true";

	#$form->{pagebreak}="true";
	#$form->{save_before_click}="true";
require "$form->{path}/io.pl";

require "format/$form->{print_so_mod}.pl";


1;
# end of main


sub add {
 if(!$form->{page} ||	!$form->{pagerows}){
	 $form->{pagerows}=5;
	$form->{page}=1;
 }

  
     $form->{title} = $locale->text($form->{title});

  $form->{callback} = "$form->{script}?action=add&transtype=$form->{transtype}&print_so_mod=$form->{print_so_mod}&type=$form->{type}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

  &order_links;

  # lock the exchangerate field
  $form->{forex} = 1;
  $form->{"forex_1"} = 1;
OE->last_invoice(\%myconfig, \%$form);
   $form->{ordnumber}=$form->{lastinvnumber};
$form->{ordnumber}++;
if($form->{save_before_click}){
OE->save_order(\%myconfig, \%$form);
   $form->{new_form}="true";
}

  &prepare_order;

}


sub edit {
#$form->dberror($query);
$form->{title} = $form->unescape($form->{title});


if(!$form->{page} ||	!$form->{pagerows}){
	 $form->{pagerows}=5;
	$form->{page}=1;
 }


     $form->{title} = $locale->text($form->{title});
  
  &order_links;

  &prepare_order;

}


sub order_links {
   $taxincluded= $form->{taxincluded};

  # get vendors / customers
  $form->all_vc(\%myconfig, $form->{vc});

  # retrieve order
  OE->retrieve_order(\%myconfig, \%$form);

  # build the popup menus
  foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
    if ($ref->{id} == $form->{"$form->{vc}_id"}) {
      $form->{$form->{vc}} = "$ref->{name}--$ref->{id}";
    }
    $form->{"select$form->{vc}"} .= "<option value='$ref->{name}--$ref->{id}'>$ref->{name}--$ref->{id}\n";
  }
  
  $form->{taxincluded}=$taxincluded if $taxincluded;

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];
  
  map { $form->{selectcurrency} .= "<option>$_\n" } @curr;

  # forex
  $form->{forex} = $form->{exchangerate};

}


sub prepare_order {

  $form->{new_form} = !$form->{id} unless (exists $form->{new_form});

  $form->{format} = "html";
  $form->{media} = "screen";
  $form->{sendmode} = "attachment";
  $form->{copies} = 2;
 $taxincluded= $form->{taxincluded};

  if ($form->{id}) {

    map { $form->{$_} =~ s/"/&quot;/g } qw(invnumber shippingpoint notes);

    $form->{creditlimit} = $form->format_amount(\%myconfig, $form->{creditlimit}, 0);
    $form->{creditremaining} = $form->format_amount(\%myconfig, $form->{creditremaining}, 0);

    foreach $ref (@{ $form->{order_details} } ) {
      $i++;
      map { $form->{"${_}_$i"} = $ref->{$_} } keys %{ $ref };
      $form->{"discount_$i"} = $form->format_amount(\%myconfig, $form->{"discount_$i"} * 100);

      ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
      $dec = length $dec;
      $decimalplaces = ($dec > 2) ? $dec : 2;

      $form->{"sellprice_$i"} = $form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces);
      $form->{"qty_$i"} = $form->format_amount(\%myconfig, $form->{"qty_$i"});

      map { $form->{"${_}_$i"} =~ s/"/&quot;/g } qw(partnumber description unit);
      $form->{rowcount} = $i;
    }
  } else {
    if ($form->{vc} eq 'vendor') {
      IR->get_vendor(\%myconfig, \%$form);
    }
    if ($form->{vc} eq 'customer') {
      IS->get_customer(\%myconfig, \%$form);
    }

  }
 #$form->dberror($form->{taxincluded});
  $form->{taxincluded}=$taxincluded if $taxincluded;

  &display_form;

}

sub prepare_order2 {

  $form->{new_form} = !$form->{id} unless (exists $form->{new_form});

  $form->{format} = "html";
  $form->{media} = "screen";
  $form->{sendmode} = "attachment";
  $form->{copies} = 2;
 $i=0;
 
  if ($form->{id}) {

    map { $form->{$_} =~ s/"/&quot;/g } qw(invnumber shippingpoint notes);

    $form->{creditlimit} = $form->format_amount(\%myconfig, $form->{creditlimit}, 0);
    $form->{creditremaining} = $form->format_amount(\%myconfig, $form->{creditremaining}, 0);

    foreach $ref (@{ $form->{order_details} } ) {
      $i++;
      map { $form->{"${_}_$i"} = $ref->{$_} } keys %{ $ref };
      $form->{"discount_$i"} = $form->format_amount(\%myconfig, $form->{"discount_$i"} * 100);

      ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
      $dec = length $dec;
      $decimalplaces = ($dec > 2) ? $dec : 2;

      $form->{"sellprice_$i"} = $form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces);
      $form->{"qty_$i"} = $form->format_amount(\%myconfig, $form->{"qty_$i"});
       if($form->{"discount_$i"}  ){
     $form->{"linetotal_$i"} = $form->{"sellprice_$i"}*$form->{"qty_$i"}*(100-$form->{"discount_$i"})/100;
     }else{
     $form->{"linetotal_$i"} =  $form->{"sellprice_$i"}*$form->{"qty_$i"};
     }
	 $form->{"taxtotal_$i"}=$form->{"linetotal_$i"}+$form->{"tax_$i"};
     $form->{invsubtotal}  +=$form->{"linetotal_$i"};   

      map { $form->{"${_}_$i"} =~ s/"/&quot;/g } qw(partnumber description unit);
      $form->{rowcount} = $i;
      
      
       # $form->{rowcount} ++;

###footnote
  $form->{invtotal} = $form->{invsubtotal};
  if (($rows = $form->numtextrows($form->{notes}, 50, 8)) < 2) {
    $rows = 2;
  }
  $notes = qq|<textarea name=notes rows=$rows cols=50 wrap=soft>$form->{notes}</textarea>|;
  
  if (!$form->{taxincluded}) {
    
    foreach $item (split / /, $form->{"taxaccounts_$i"}) {
    #  if ($form->{"${item}_base"}) {
	    $form->{"${item}_base1"}= $form->{invsubtotal};
	    $form->{"${item}_rate1"}=$form->{"${item}_rate"};
	    $form->{"${item}_description1"}=$form->{"${item}_description"};
	$form->{"${item}_total1"} = $form->round_amount($form->{"${item}_base1"} * $form->{"${item}_rate1"}, 2);
	$form->{invtotal} += $form->{"${item}_total1"};
	$form->{"${item}_total1"} = $form->format_amount(\%myconfig, $form->{"${item}_total1"}, 2);
	
	#$form->dberror($form->{"${item}_base"});
    #  }
    }

    $form->{invsubtotal} = $form->format_amount(\%myconfig, $form->{invsubtotal}, 2);
  
  }
	   $whole=$form->format_amount(\%myconfig, $form->{invtotal}, 2);
  
  $whole =~ s/,//g;
  
    ($whole, $form->{decimal}) = split /\./, $whole;
  
  $check = new IS $myconfig{countrycode};
  $check->init;
  $form->{text_amount} = $check->num2text($whole);
 # $form->dberror($form->{text_amount});
 if(   $form->{decimal}>0){
	 $form->{text_amount} .= " And ". $check->num2text($form->{decimal})." Cents";
 }
  $form->{text_amount} .=" Only";
  
  $form->{invtotal} = $form->format_amount(\%myconfig, $form->{invtotal}, 2);
 
      
    }
  } else {
    if ($form->{vc} eq 'vendor') {
      IR->get_vendor(\%myconfig, \%$form);
    }
    if ($form->{vc} eq 'customer') {
      IS->get_customer(\%myconfig, \%$form);
    }
  }

  

  
  for $j(1..$i) {
     pop  @{  $form->{order_details}};
 
    } # &display_form;

}

sub form_header {
  $status =" 	<option value='1'> Open 	<option value='2'> Closed 	<option value='3'> KIV ";
  

  $form->{taxincluded} = ($form->{taxincluded}) ? "checked" : "";
    $colspan = 7;

  if ($form->{type} eq 'purchase_order' || $form->{transtype} eq 'PO') {
    $colspan = 7;
  }
  if ($form->{type} eq 'sales_order' || $form->{transtype} eq 'SO') {
    $colspan = 7;
  }
    if ($form->{type} eq 'quotation' || $form->{transtype} eq 'QO') {
    $colspan = 7;
  }   
      if ($form->{type} eq 'do' || $form->{transtype} eq 'DO') {
    $colspan = 6;
  }   
  # set option selected
#$form->dberror($form->{"select$item"});
foreach $item ($form->{vc}, currency) {
	  
	  $form->{"$item"} =~ s/\(/;brak/g;
$form->{"select$item"} =~ s/\(/;brak/g;

$form->{"$item"} =~ s/\)/;2brak/g;
$form->{"select$item"} =~ s/\)/;2brak/g;

$form->{"$item"} =~ s/\[/;brek/g;
$form->{"select$item"} =~ s/\[/;brek/g;

$form->{"$item"} =~ s/\]/;2brek/g;
$form->{"select$item"} =~ s/\]/;2brek/g;
   $form->{"select$item"} = $form->unescape($form->{"select$item"});
    $form->{"$item"} = $form->unescape($form->{"$item"});
 

    $form->{"select$item"} =~ s/ selected//;
    $form->{"select$item"} =~ s/option value='$form->{$item}'>\Q$form->{$item}\E/option selected value='$form->{$item}'>$form->{$item}/;
    
    
       $form->{"$item"} =~ s/;brak/\(/g;
$form->{"select$item"} =~ s/;brak/\(/g;

$form->{"$item"} =~ s/;2brak/\)/g;
$form->{"select$item"} =~ s/;2brak/\)/g;

   $form->{"$item"} =~ s/;brek/\[/g;
$form->{"select$item"} =~ s/;brek/\[/g;

$form->{"$item"} =~ s/;2brek/\]/g;
$form->{"select$item"} =~ s/;2brek/\]/g;


  }
   $status =~ s/option value='$form->{status}'>/option selected value='$form->{status}'>/;

  $form->{exchangerate} = $form->format_amount(\%myconfig, $form->{exchangerate});

  $exchangerate = qq|&nbsp;|;
  if ($form->{currency} ne $form->{defaultcurrency}) {
    if ($form->{forex}) {
      $exchangerate = qq|<input type=hidden name=exchangerate value=$form->{exchangerate}>$form->{exchangerate}|;
    } else {
      $exchangerate = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=exchangerate size=10 value=$form->{exchangerate}>|;
    }
  }
  $exchangerate .= qq|
<input type=hidden name=forex value=$form->{forex}>
|;


  $vclabel = ucfirst $form->{vc};
  $vclabel = $locale->text($vclabel);

  $form->header;
  $form->{title1}= qq|$form->{title} [ Order No : $form->{ordnumber}, $form->{vc} : $form->{"$form->{vc}"}, Date : $form->{orddate} |;
 # $form->dberror( $form->{title1});
  print qq|
<script>
<!--
function stb(){parent.document.title ="$form->{title1}";document.myform.$form->{nextfocus}.focus();}

function autoComplete (field, select, property, forcematch) {
	var found = false;
	for (var i = 0; i < select.options.length; i++) {
	if (select.options[i][property].toUpperCase().indexOf(field.value.toUpperCase()) == 0) {
		found=true; break;
		}
	}
	if (found) { select.selectedIndex = i; }
	else { select.selectedIndex = -1; }
	if (field.createTextRange) {
		if (forcematch && !found) {
			field.value=field.value.substring(0,field.value.length-1); 
			return;
			}
		var cursorKeys ="8;46;37;38;39;40;33;34;35;36;45;";
		if (cursorKeys.indexOf(event.keyCode+";") == -1) {
			var r1 = field.createTextRange();
			var oldValue = r1.text;
			var newValue = found ? select.options[i][property] : oldValue;
			if (newValue != field.value) {
				field.value = newValue;
				var rNew = field.createTextRange();
				rNew.moveStart('character', oldValue.length) ;
				rNew.select();
				}
			}
		}
	}
	
// -->
</script><body bgcolor=ffffff   onLoad=stb()>

<form method=post action=$form->{script} name=myform>

<input type=hidden name=printinvoicerowcount value=$form->{printinvoicerowcount}>
<input type=hidden name=id value=$form->{id}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=new_form value=$form->{new_form}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=keys >

<input type=hidden name=title value="$form->{title}">
<input type=hidden name=to_order value="$form->{to_order}">
<input type=hidden name=to_title value="$form->{to_title}">

<input type=hidden name=$form->{vc}_id value=$form->{"$form->{vc}_id"}>
<input type=hidden name=discount value=$form->{discount}>
<input type=hidden name=accno_ value=$form->{"$form->{vc}number"}>
<input type=hidden name=$form->{vc}number value=$form->{"$form->{vc}number"}>
<input type=hidden name=print_so_mod value=$form->{print_so_mod}>
<input type=hidden name=lastinvnumber value=$form->{lastinvnumber}>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transtype type=hidden value="$form->{transtype}">
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=no_new_part value='$form->{no_new_part}'>
	  <input type=hidden name=taxaccounts_vc value='$form->{taxaccounts_vc}'>


<table border=0 ><tr><td>

<table border=1 width=100%>
<tr class=listtop bgcolor=000000><th>
<font color=ffffff>$form->{title}</font></th></tr>

<tr>
<td>

<table cellspacing=0 cellpadding=0 border=0 width=100%>


<tr>
  <td   align=right nowrap>
  <b>|.$locale->text('Currency').qq|</b>&nbsp;
     </td>

 <td >

  <select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=currency>$form->{selectcurrency}</select>&nbsp;
      </td>

 <td  align=right>
 
  <b>|.$locale->text('Exchangerate').qq|</b>&nbsp;
       </td>

 <td >

  $exchangerate

  </td>
  <input type=hidden name=selectcurrency value="$form->{selectcurrency}">
  <input type=hidden name=defaultcurrency value=$form->{defaultcurrency}>
</tr>

<tr>
  <td align=right>

  <b>$vclabel</b>&nbsp;
 </td>

 <td colspan=3>

  <select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=$form->{vc} onChange="this.form.accno1_3.value=this.options[this.selectedIndex].value">$form->{"select$form->{vc}"}</select>&nbsp; 

  </td>
</tr>

<input type=hidden name=select$form->{vc} value="$form->{"select$form->{vc}"}">

|;

 # &email_options;

  print qq|

<tr>
  <td   align=right nowrap>
  <b>|.$locale->text('Order Number').qq|</b>&nbsp;
   </td>

 <td >

  $form->{transtype}<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=11 value="$form->{ordnumber}">

  </td>
  
  	   <td nowrap align=right>

   <b>|.$locale->text('Last Order').qq| : </b></td><td>$form->{lastinvnumber}

	   </td>

</tr>



<tr>
  <td align=right nowrap>
  <b>|.$locale->text('Order Date').qq|&nbsp;
        </td>

 <td >

  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=orddate size=11 value=$form->{orddate} title="($myconfig{dateformat})">&nbsp;
          <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].orddate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    
    </td>

 <td  align=right>

  <b>|.$locale->text('Required by').qq|&nbsp;
        </td>

 <td >

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=reqdate size=11 value=$form->{reqdate} title="($myconfig{dateformat})"> 

  </td>
</tr>


<tr>
  <td align=right nowrap>
  <b>|.$locale->text('Your Ref').qq|&nbsp;
        </td>

 <td >

  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=yourref size=11 value="$form->{yourref}" >&nbsp;
        </td>

 <th  align=right>
<b>|.$locale->text('Status').qq|&nbsp;
        </th>

 <td >
 <select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=status onChange="this.form.accno1_3.value=this.options[this.selectedIndex].value">
 $status
 </select>

  </td>
</tr>

<tr>
  <td align=right nowrap>
  <b>|.$locale->text('Freight').qq|</b>&nbsp;
          </td>

 <td >

  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shippingpoint size=35 value="$form->{shippingpoint}">&nbsp;
          </td>

 <td align=right>

  <b>|.$locale->text('Terms: Net').qq|</b>&nbsp;
          </td>

 <td >

  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=terms size=2 value=$form->{terms}>&nbsp;<b>|.$locale->text('days').qq|

  </td>
</tr>

<input type=hidden name=taxpart value="$form->{taxpart}">
<input type=hidden name=taxservice value="$form->{taxservice}">

<input type=hidden name=taxaccounts value="$form->{taxaccounts}">

|;

  foreach $item (split / /, $form->{taxaccounts}) {
    print qq|
<input type=hidden name="${item}_rate" value=$form->{"${item}_rate"}>
<input type=hidden name="${item}_description" value="$form->{"${item}_description"}">
|;
  }

}


sub form_footer {

  $form->{DF}{$form->{format}} = "checked";
  $form->{OP}{$form->{media}} = "checked";
  $form->{SM}{$form->{sendmode}} = "checked";

  $form->{invtotal} = $form->{invsubtotal};
 map { $form->{"${_}_base"} = $form->{taxtotal} } (split / /, $form->{"taxaccounts_vc"}) if !$form->{taxincluded};
  $form->{invsubtotal} = $form->{taxtotal};

  if (($rows = $form->numtextrows($form->{notes}, 50, 8)) < 2) {
    $rows = 2;
  }
  $notes = qq|<textarea name=notes rows=$rows cols=50 wrap=soft>$form->{notes}</textarea>|;


      foreach $item (split / /, $form->{taxaccounts}) {
      if ($form->{"${item}_base"}) {
	$form->{invtotal} += $form->{"${item}_total"} = $form->round_amount($form->{"${item}_base"} * $form->{"${item}_rate"}, 2);
	$form->{"${item}_total"} = $form->format_amount(\%myconfig, $form->{"${item}_total"}, 2);

	$tax .= qq|
	    <input type=hidden name="${item}_base1" value="$form->{"${item}_base"}">
	    <input type=hidden name="${item}_rate1" value="$form->{"${item}_rate"}">
     <input type=hidden name="${item}_description1" value="$form->{"${item}_description"}">
	    <input type=hidden name="${item}_total1" value="$form->{"${item}_total"}">


	|;
      }
    }
	
	
  if (!$form->{taxincluded}) {

    foreach $item (split / /, $form->{taxaccounts_vc}) {
    #  if ($form->{"${item}_base"}) {
	#$form->{invtotal} += $form->{"${item}_total"} = $form->round_amount($form->{"${item}_base"} * $form->{"${item}_rate"}, 2);
	#$form->{"${item}_total"} = $form->format_amount(\%myconfig, $form->{"${item}_total"}, 2);

	$tax .= qq|
	    <tr>
	  <th align=right>$form->{"${item}_description"}</th>
	  <td align=right>$form->{"${item}_total"}</td>
	</tr>
	|;
      #}
    }

    $form->{invsubtotal} = $form->format_amount(\%myconfig, $form->{invsubtotal}, 2);

    $subtotal = qq|
      <tr>
      <th align=right>|.$locale->text('Subtotal').qq|</th>
        <td align=right>$form->{invsubtotal}</td>
      </tr>
      |;

  }


  $form->{invtotal} = $form->format_amount(\%myconfig, $form->{invtotal}, 2);
  $x=$form->{rowcount}-1;

  print qq|
<tr>
  <td colspan=$colspan>
    <table>
    <tr>
      <td colspan=2>
      <table>
        $subtotal

	$tax

	<tr>
  	    <input type=hidden name="invsubtotal" value=$form->{invsubtotal}>
	  <th align=right>|.$locale->text('Total').qq|</th>
	  <td align=right>$form->{invtotal}</td>
        </tr>

      </table>
      </td>|,

      qq|<td>
        <table>
	  <tr>
	    <th>|.$locale->text('Notes').qq|</th>
          </tr>

	  <tr>
	    <td>$notes<Br><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxincluded class=checkbox type=checkbox value=1 $form->{taxincluded}>&nbsp;<b>|.$locale->text('Tax Included').qq|</b></td>
 	<td>$form->{"title2_$x"}</td>
	  </tr>
	</table>
      </td>

    </tr>

    </table>

  </td>
</tr>

</table>

</td>
</tr>

</table>
			  <input type=hidden name=action value=update_form2>

|;

if(!$form->{readonly}){
 # &print_options;
  print qq|

<br>
<input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
    |;
   if($form->{pagebreak}){
  		print qq|<br>|;
		for $j (1 ..(( $i/$form->{pagerows})+1) ) {
			  print qq|
			  <input class=submit type=submit name=page value=' $j '>	  
			  |;
		  }
  		print qq|<br>|;
   }
  print qq|
<input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Save').qq|">
|;

    if ($form->{id}) {
      print qq|
<input class=submit type=submit name=action value="|.$locale->text('Delete').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Save As New Order').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Create Invoice').qq|">
|;
	if ($form->{to_other}){
		print qq|<input class=submit type=submit name=action value="|.$locale->text('To Order').qq|">| ;
	}
    }
}
  print qq|

</td>
</tr>

</table>

<input type=hidden name=rowcount value=$form->{rowcount}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

</form>
|

.$locale->text('Enter a number or description and click on "Update Form"')
.qq|<br>|
.$locale->text('To remove any items delete the number and click on "Update Form"')

.qq|

</body>
</html>
|;

}

sub save{
	&save_order;	
}

sub delete{
	&delete_order;	
}

sub print{
	&print_order;	
}

sub update{
	&update_form;	
}


sub update_form {
  $form->{page}=$form->{focus}/$form->{pagerows};
 #/$form->dberror($form->{page});
 ($form->{page},$dec) = split(/\./,$form->{page});
if($dec >=0){
	  $form->{page}++;	  
  }

  
&update_form2;
}


sub update_form2 {
 #the following statement must be coresspondent to the io.pl sub form_row();
  #this statment will reorder the sequence of rows
  for $j(1..$form->{rowcount}){
	  if($form->{"sr_$j"} ne $form->{"sr2_$j"}){
	  for ($i=$form->{"sr2_$j"};$i > $form->{"sr_$j"};--$i){
	       @column_index = qw(partnumber description onhand qty unit   sellprice  lastcost discount bin part_ordnumber last_parts_qty ord_parts qty po_details partnotes id inventory_Accno bin	      income_accno expense_accno listprice assembly taxaccounts parts_id linetotal po delivery_date  remark2);

	          map { $form->{$_."t"} =  $form->{$_."_$form->{\"sr2_$i\"}"} } @column_index;

		  $k=$i-1;
		  map { $form->{$_."_$form->{\"sr2_$i\"}"} =  $form->{$_."_$form->{\"sr2_$k\"}"} } @column_index;

		  map { $form->{$_."_$form->{\"sr2_$k\"}"} =  $form->{$_."t"} } @column_index;

		 
	  }
	  }
  }
  ###end of statement of reorder
  
  # if there is a new name get new values
  ($null, $vc_id) = split /--/, $form->{$form->{vc}};
  if ($form->{"$form->{vc}_id"} ne $vc_id|| $form->{terms} eq '') {
    # delete tax accounts
    map { delete $form->{"${_}_rate"} } ($form->{taxaccounts});

    $form->{"$form->{vc}_id"} = $vc_id;
    if ($form->{vc} eq 'vendor') {
      IR->get_vendor(\%myconfig, \%$form);
    }
    if ($form->{vc} eq 'customer') {
      IS->get_customer(\%myconfig, \%$form);
     }

  }
 
  $buysell = 'buy';
  $buysell = 'sell' if ($form->{vc} eq 'vendor');
  $form->{exchangerate} = $exchangerate if ($form->{forex} = ($exchangerate = $form->check_exchangerate(\%myconfig, $form->{currency}, $form->{orddate}, $buysell)));

  $form->{exchangerate} = $form->parse_amount(\%myconfig, $form->{exchangerate});

   $i = $form->{rowcount};
   $form->{focus}=$form->{rowcount};
      $form->{nextfocus}="partnumber_$i";

  if (($form->{"partnumber_$i"} eq "") && ($form->{"description_$i"} eq "")) {

    &check_form;

  } else {
$form->{"partnumber_$i"} =~ s/'/\\'/g;
$form->{"description_$i"} =~ s/'/\\'/g;

    if ($form->{vc} eq 'vendor') {
      IR->retrieve_item(\%myconfig, \%$form);
    }
    if ($form->{vc} eq 'customer') {
      IS->retrieve_item(\%myconfig, \%$form);
    }

    
    my $rows = scalar @{ $form->{item_list} };

    $form->{"discount_$i"} = $form->format_amount(\%myconfig, $form->{discount} * 100);

    if ($rows) {
      $form->{"qty_$i"}                     = 1 unless ($form->{"qty_$i"});

      if ($rows > 1) {
	&select_item;
	exit;
      } else {
	map { $form->{item_list}[$i]{$_} =~ s/"/&quot;/g } qw(partnumber description unit);
	map { $form->{"${_}_$i"} = $form->{item_list}[0]{$_} } keys %{ $form->{item_list}[0] };

	($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
	$dec = length $dec;
	$decimalplaces = ($dec > 2) ? $dec : 2;

        # if there is an exchange rate adjust sellprice
        if (($form->{exchangerate} * 1) != 0) {
	  $form->{"sellprice_$i"} /= $form->{exchangerate};
	}

	$form->{"sellprice_$i"} = $form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces);
	$form->{"qty_$i"} =  $form->format_amount(\%myconfig, $form->{"qty_$i"});

      }
      &display_form;

    } else {
      # ok, so this is a new part
      # ask if it is a part or service item

      $form->{"id_$i"}		= 0;
      $form->{"unit_$i"}	= $locale->text('ea');

      if (!$form->{no_new_part}){
      &new_item ;
      }else{
	  $form->header;
	 print qq|
	<body bgcolor=ffffff>
	
	<h4><font color=red>|.$locale->text('Item not on file!').qq|</font>
	</body>
	</html>
	|;
      }

    }
  }

}

sub search_short {
   $form->{transdatefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};

	 $selection = "<option selected>" . $locale->text($form->{vcselection}) ."\n";

  # setup vendor / customer selection
  $form->all_vc(\%myconfig, "$form->{vc}");

  foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }

  $vclabel = ucfirst $form->{vc};
  $vclabel = $locale->text($vclabel);

# $locale->text('Vendor')
# $locale->text('Customer')


  $form->header;

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr><td>

<table>

<tr>

<th align=right>$vclabel</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=$form->{vc}>$selection</select></td>

</tr>

<tr>

<th align=right>|.$locale->text('Order Number').qq|</th>
<td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=20></td>
<th align=right>|.$locale->text('Status').qq|</th>
<td >

 <select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=status onChange="this.form.accno1_3.value=this.options[this.selectedIndex].value">
<option value='0'> All Status <option value='1'> Open 	<option value='2'> Closed 	<option value='3'> KIV
 </select>
</td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|<br></th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11  title=($myconfig{dateformat}) value=$form->{transdatefrom}>
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11  title=($myconfig{dateformat})>
<script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar2Callback(date, month, year)
        {
            document.forms['search'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar2Callback', 'javascript/images/');
    //-->
    </script>
</td>

</tr>

<input type=hidden name=sort value=transdate>
<input type=hidden name=transtype value=$form->{transtype}>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<tr>
<td colspan=3>|;

print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=hidden value=Y>&nbsp;| if $form->{l_id};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=hidden value=Y checked>&nbsp;| if $form->{l_ordnumber};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=hidden value=Y checked>&nbsp;| if $form->{l_transdate};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_reqdate" class=checkbox type=hidden value=Y checked>&nbsp;| if $form->{l_reqdate};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" class=checkbox type=hidden value=Y checked>&nbsp;| if $form->{l_name};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_netamount" class=checkbox type=hidden value=Y>&nbsp;| if $form->{l_netamount};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_yourref" class=checkbox type=hidden value=Y>&nbsp;| if $form->{l_yourref};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_tax" class=checkbox type=hidden value=Y>&nbsp;| if $form->{l_tax};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=hidden value=Y checked>&nbsp;| if $form->{l_amount};
print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=hidden value=Y>&nbsp;| if $form->{l_subtotal};
 print qq|  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_status" class=checkbox type=hidden value=Y>&nbsp;| if $form->{l_status};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_printl" class=checkbox type=hidden value=Y>&nbsp| if $form->{l_printl};

print qq| 
</td>

</tr>

</table>

</td></tr>
</table>

<p>
<input type=hidden name=printinvoicerowcount value=$form->{printinvoicerowcount}>
<input type=hidden name=nextsub value=orders>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=readonly value=$form->{readonly}>
<input type=hidden name=print_so_mod value=$form->{print_so_mod}>
<input type=hidden name=transtype value=$form->{transtype}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=title value='$form->{title}'>
<input type=hidden name=to_order value="$form->{to_order}">
<input type=hidden name=to_title value="$form->{to_title}">
<input type=hidden name=to_other value="$form->{to_other}">
<input type=hidden name=vcselection value="$form->{vcselection}">

<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('More').qq|">
</form>

<p>|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;

}


sub more{
 @columns = qw(sr transdate reqdate id ordnumber name yourref netamount tax amount status printl);
    map { $form->{"l_$_"} = "checked" if $form->{"l_$_"} eq "Y" } @columns;

 &search;
}


sub search {
   $form->{transdatefrom} =$form->first_day_current_Date(\%myconfig) if $form->{currentdate};

	 $selection = "<option selected>" . $locale->text($form->{vcselection}) ."\n";


  # setup vendor / customer selection
  $form->all_vc(\%myconfig, "$form->{vc}");

  foreach $ref (@{ $form->{"all_$form->{vc}"} }) {
    $selection .= "<option>$ref->{name}--$ref->{id}\n";
  }

  $vclabel = ucfirst $form->{vc};
  $vclabel = $locale->text($vclabel);

# $locale->text('Vendor')
# $locale->text('Customer')


  $form->header;

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr><td>

<table>

<tr>

<th align=right>$vclabel</th>
<td colspan=3><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=$form->{vc}>$selection</select></td>

</tr>

<tr>

<th align=right>|.$locale->text('Order Number').qq|</th>
<td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=20 value='$form->{ordnumber}'> </td>
<th align=right>|.$locale->text('Status').qq|</th>
<td >

 <select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=status onChange="this.form.accno1_3.value=this.options[this.selectedIndex].value">
<option value='0'> All Status <option value='1'> Open 	<option value='2'> Closed 	<option value='3'> KIV
 </select>
</td>

</tr>

<tr>

<th align=right>|.$locale->text('From').qq|<br></th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11  title=($myconfig{dateformat}) value=$form->{transdatefrom}>
<link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
<th align=right>|.$locale->text('To').qq|</th>
<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11  title=($myconfig{dateformat})>
<script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar2Callback(date, month, year)
        {
            document.forms['search'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar2Callback', 'javascript/images/');
    //-->
    </script>
</td>

</tr>

<input type=hidden name=sort value=transdate>
<input type=hidden name=transtype value=$form->{transtype}>
<tr>
<td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_option" class=checkbox type=checkbox value=Y  $form->{l_option}>&nbsp;|.$locale->text('Show Search Criteria').qq|
</td>
</tr>
<tr>
<th align=right>|.$locale->text('Include in Report').qq|</th>
<td colspan=3>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_id" class=checkbox type=checkbox value=Y $form->{l_id}>&nbsp;|.$locale->text('ID').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_ordnumber" class=checkbox type=checkbox value=Y $form->{l_ordnumber}>&nbsp;|.$locale->text('Order Number').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_transdate" class=checkbox type=checkbox value=Y $form->{l_transdate}>&nbsp;|.$locale->text('Order Date').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_reqdate" class=checkbox type=checkbox value=Y $form->{l_reqdate}>&nbsp;|.$locale->text('Required by').qq|<br>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_name" class=checkbox type=checkbox value=Y $form->{l_name}>&nbsp;$vclabel
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_netamount" class=checkbox type=checkbox value=Y $form->{l_netamount}>&nbsp;|.$locale->text('Amount').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_yourref" class=checkbox type=checkbox value=Y $form->{l_yourref}>&nbsp;|.$locale->text('Your Ref').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_tax" class=checkbox type=checkbox value=Y $form->{l_tax}>&nbsp;|.$locale->text('Tax').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_amount" class=checkbox type=checkbox value=Y $form->{l_amount}>&nbsp;|.$locale->text('Total').qq|<br>
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_subtotal" class=checkbox type=checkbox value=Y $form->{l_subtotal}>&nbsp;|.$locale->text('Subtotal').qq|
  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_status" class=checkbox type=checkbox value=Y $form->{l_status}>&nbsp;|.$locale->text('Status').qq|
   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="l_printl" class=checkbox type=checkbox value=Y $form->{l_printl}>&nbsp;|.$locale->text('Print All').qq|
 
</td>

</tr>

</table>

</td></tr>
</table>

<p>
<input type=hidden name=printinvoicerowcount value=$form->{printinvoicerowcount}>
<input type=hidden name=nextsub value=orders>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=vc value=$form->{vc}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=readonly value=$form->{readonly}>
<input type=hidden name=print_so_mod value=$form->{print_so_mod}>
<input type=hidden name=transtype value=$form->{transtype}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=title value='$form->{title}'>
<input type=hidden name=to_order value="$form->{to_order}">
<input type=hidden name=to_title value="$form->{to_title}">
<input type=hidden name=to_other value="$form->{to_other}">

<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
</form>

<p>|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;

}


sub orders {
 
  # split vendor / customer
  ($name, $form->{"$form->{vc}_id"}) = split(/--/, $form->{$form->{vc}});
 
  # $form->{..._id} is needed in OE->transactions
  OE->transactions(\%myconfig, \%$form);

  # construct href
  $href = "$form->{script}?path=$form->{path}&action=orders&type=$form->{type}&status=$form->{status}&transtype=$form->{transtype}&print_so_mod=$form->{print_so_mod}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&ordnumber=" . $form->escape($form->{ordnumber}) . "&$form->{vc}=" . $form->escape($form->{$form->{vc}})."&vc=". $form->escape($form->{vc})."&title=". $form->escape($form->{title})."&to_title=". $form->escape($form->{to_title})."&to_order=". $form->escape($form->{to_order})."&to_other=". $form->escape($form->{to_other});

  # construct callback
  $name =~ s/&/_/g;
  $callback = "$form->{script}?path=$form->{path}&action=orders&type=$form->{type}&status=$form->{status}&transtype=$form->{transtype}&print_so_mod=$form->{print_so_mod}&login=$form->{login}&sessionid=$form->{sessionid}&transdatefrom=$form->{transdatefrom}&transdateto=$form->{transdateto}&ordnumber=$form->{ordnumber}&vc=$form->{vc}&$form->{vc}=" . $form->escape($form->{$form->{vc}})."&title=". $form->escape($form->{title})."&to_title=". $form->escape($form->{to_title})."&to_order=". $form->escape($form->{to_order})."&to_other=". $form->escape($form->{to_other});

  @columns = $form->sort_columns(qw(transdate reqdate id ordnumber name yourref netamount tax amount status printl));

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }
  
  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }
 

 # if ($form->{vc} eq 'vendor') {
	 $form->{title} = $locale->text($form->{title});
    $name = $locale->text($form->{vc});
  #}
 # if ($form->{vc} eq 'customer') {
  #  $form->{title} = $locale->text('Sales Orders');
 #   $name = $locale->text('Customer');
 # }
  
  $column_header{id} = qq|<th><a class=listheading href=$href&sort=id><font color=ffffff>|.$locale->text('ID').qq|</font></a></th>|;
  $column_header{transdate} = qq|<th><a class=listheading href=$href&sort=transdate><font color=ffffff>|.$locale->text('Date').qq|</font></a></th>|;
  $column_header{reqdate} = qq|<th><a class=listheading href=$href&sort=reqdate><font color=ffffff>|.$locale->text('Required by').qq|</font></a></th>|;
  $column_header{ordnumber} = qq|<th><a class=listheading href=$href&sort=ordnumber><font color=ffffff>|.$locale->text('Order').qq|</font></a></th>|;
  $column_header{name} = qq|<th><a class=listheading href=$href&sort=name><font color=ffffff>$name</font></a></th>|;
  $column_header{netamount} = qq|<th><font color=ffffff>|.$locale->text('Amount').qq|</font></th>|;
  $column_header{tax} = qq|<th><font color=ffffff>|.$locale->text('Tax').qq|</font></th>|;
  $column_header{amount} = qq|<th><font color=ffffff>|.$locale->text('Total').qq|</font></th>|;
  $column_header{status} = qq|<th><font color=ffffff>|.$locale->text('Status').qq|</font></th>|;
  $column_header{printl} = qq|<th><font color=ffffff>|.$locale->text('Print').qq|</font></th>|;
  $column_header{yourref} = qq|<th><font color=ffffff>|.$locale->text('Your Ref').qq|</font></th>|;

  
  ($name) = split /--/, $form->{name};
  if ($form->{"$form->{vc}_id"}) {
    $option .= $name;
  }
  if ($form->{transdatefrom}) {
    $option .= "\n<br>".$locale->text('From')." ".$locale->date(\%myconfig, $form->{transdatefrom}, 1);
  }
  if ($form->{transdateto}) {
    $option .= "\n<br>".$locale->text('To')." ".$locale->date(\%myconfig, $form->{transdateto}, 1);
  }
  	    $option ='' if(!$form->{l_option})  ;

  $form->header;

  $colspan = $#column_index + 1;

  print qq|
  
    <script>
<!--

function set(n) 
{
               temp = document.myform.elements.length  ;
                 
               for (i=0; i < temp; i++)
	{   document.myform.elements[i].checked=n;
	   }
} 

function Invers(){

temp = document.myform.elements.length ;
                 
for (i=0; i < temp; i++){

          if(document.myform.elements[i].checked == 1){document.myform.elements[i].checked = 0;}
                else {document.myform.elements[i].checked = 1}
               
              }

}
// -->
</script>

<body bgcolor=ffffff>
<form method=post action=oe.pl name=myform>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=printtitle value='$form->{printtitle}'>
<input type=hidden name=print_so_mod value=$form->{print_so_mod}>
<input type=hidden name=type value=$form->{type}>
<input type=hidden name=vc value=$form->{vc}>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$option</td></tr>

<tr class=listheading bgcolor=336666>|;

map { print "\n$column_header{$_}" } @column_index;

print qq|
</tr>
|;

  # add sort and escape callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  if (@{ $form->{OE} }) {
    $sameitem = $form->{OE}->[0]->{$form->{sort}};
  }

  foreach $oe (@{ $form->{OE} }) {

    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $oe->{$form->{sort}}) {
	&subtotal;
	$sameitem = $oe->{$form->{sort}};
      }
    }
    $oe->{status}= $locale->text('Open') if ($oe->{status} eq '1'); 
    $oe->{status}= $locale->text('Closed') if ($oe->{status} eq '2');
    $oe->{status}= $locale->text('KIV') if ($oe->{status} eq '3');
   # $form->dberror($oe->{status});


    $column_data{netamount} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{netamount}, 2, "&nbsp;")."</td>";
    $column_data{tax} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{amount} - $oe->{netamount}, 2, "&nbsp;")."</td>";
    $column_data{amount} = "<td align=right>".$form->format_amount(\%myconfig, $oe->{amount}, 2, "&nbsp;")."</td>";
    $column_data{printl} = "<td  $listprint ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=\"printl_".($j+1)."\" type=checkbox class=checkbox value=".($j+1)." 0> </td>" ;

    $totalnetamount += $oe->{netamount};
    $totalamount += $oe->{amount};
    $totalpaid += $oe->{paid};

    $subtotalnetamount += $oe->{netamount};
    $subtotalamount += $oe->{amount};

    $column_data{id} = "<td>$oe->{id}</td>";
    $column_data{status} = "<td>$oe->{status}</td>";
    $column_data{yourref} = "<td>$oe->{yourref}</td>";
    $column_data{transdate} = "<td>$oe->{transdate}&nbsp;</td>";
    $column_data{reqdate} = "<td>$oe->{reqdate}&nbsp;</td>";
  $form->{title} =~ s/ /%20/g;
    $column_data{ordnumber} = "<td><input type=hidden name=id_".($j+1)." value=$oe->{id}><a href=oe.pl?path=$form->{path}&vc=$form->{vc}&title=$form->{title}&nextfocus=$form->{nextfocus}&transtype=$form->{transtype}&print_so_mod=$form->{print_so_mod}&printinvoicerowcount=$form->{printinvoicerowcount}&readonly=$form->{readonly}&action=edit&type=$form->{type}&id=$oe->{id}&login=$form->{login}&sessionid=$form->{sessionid}&to_other=$form->{to_other}&to_title=". $form->escape($form->{to_title})."&to_order=". $form->escape($form->{to_order})."&callback=$callback>$oe->{ordnumber}</a></td>";
    $column_data{name} = "<td>$oe->{name}</td>";

    $i++; $i %= 2;$j++;
    print "<tr class=listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >";
    
    map { print "\n$column_data{$_}" } @column_index;

    print qq|
    </tr>
|;

  }
  
  if ($form->{l_subtotal} eq 'Y') {
    &subtotal;
  }
  
  # print totals
  print qq|<tr class=listtotal bgcolor=000000>|;
  
  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;
  
  $column_data{netamount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{tax} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount - $totalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{amount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalamount, 2, "&nbsp;")."</font></th>";

  map { print "\n$column_data{$_}" } @column_index;

  print qq|
  </tr>
  
</table>
|;
  if($form->{l_printl}  ){
	  print qq| 
	    <br><br><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=button onclick=Invers() type=button value="|.$locale->text('Select All').qq|"> 
	    	    <input class=submit type=submit name=action value="|.$locale->text('Print Orders').qq|">
	  	<input type=hidden name=sessionid value=$form->{sessionid}>
		<input type=hidden name=printcount value=$j>

	  |;
  }
  
print qq|
<p>|.$locale->text('Click on table headers to sort table').qq|
<br>|.$locale->text('Click on order number to edit transaction').qq|
</form>
</body>
</html>
|;

}




sub subtotal {

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;
  
  $column_data{netamount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{tax} = "<td align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalamount - $subtotalnetamount, 2, "&nbsp;")."</font></th>";
  $column_data{amount} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalamount, 2, "&nbsp;")."</font></th>";
  $column_data{paid} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalpaid, 2, "&nbsp;")."</font></th>";

  $subtotalnetamount = 0;
  $subtotalamount = 0;
  $subtotalpaid = 0;

  print "<tr class=listsubtotal bgcolor=333366>";
  
  map { print "\n$column_data{$_}" } @column_index;

  print qq|
  </tr>
|;

}


sub save_order {

  $form->isblank("ordnumber", $locale->text('Order Number missing!'));
  $form->isblank("orddate", $locale->text('Order Date missing!'));

  $form->isblank("exchangerate", $locale->text('Exchangerate missing!')) if ($form->{currency} ne $form->{defaultcurrency});

  &validate_items;

  # if the vendor changed get new values
  ($null, $vc_id) = split /--/, $form->{$form->{vc}};
  if ($form->{"$form->{vc}_id"} ne $vc_id) {
    $form->{"$form->{vc}_id"} = $vc_id;
    if ($form->{vc} eq 'vendor') {
      IR->get_vendor(\%myconfig, \%$form);
    }
    if ($form->{vc} eq 'customer') {
      IS->get_customer(\%myconfig, \%$form);
    }
  }


  # this is for the notes section for the [email] Subject
  $form->{label} = ($form->{type} eq 'sales_order') ? $locale->text('Sales Order') : $locale->text('Purchase Order');


  if (OE->save_order(\%myconfig, \%$form)) {
    if ($form->{new_form}) {

      $form->header;

      print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

      print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Do you want to create another Order?').qq|</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes').qq|">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('No').qq|">

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}&nextfocus=$form->{vc}&vc=$form->{vc}&title=$form->{title}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=transtype value=$form->{transtype}>
<input type=hidden name=print_so_mod value=$form->{print_so_mod}>

</form>

</body>
</html>
|;

    } else {
	    
      $form->isposted(1);
    }

  }

}



sub delete_order {

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  # delete action variable
  delete $form->{action};

  foreach $key (keys %$form) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|
  .$locale->text('Are you sure you want to delete Order Number').qq| $form->{ordnumber}
</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Order').qq|">
</form>

</body>
</html>
|;


}



sub yes_delete_order {

  $form->isdeleted(OE->delete_order(\%myconfig, \%$form));

}


sub print_orders {
#require "$form->{path}/oe.pl";
	 $form->header;
 print qq|<body bgcolor="#ffffff">|;
 for $x (1 .. $form->{printcount}) {
 $form->{"pid_$x"} =$form->{"id_$x"};
 }

 for $x (1 .. $form->{printcount}) {
  $form->{title} = $locale->text('Edit Customer Invoice');
 # $form->{printtitle}="I N V O I C E";
 
 $form->{id} =$form->{"pid_$x"};
 # $form->save_query(\%$form,$myconfig->{dbname},$form->{"id_$x"});

  $form->{currentrow}=0;


 $form->{page}=0;
 #$i=0;
$form->{paidaccounts}=0;
$form->{rowcount}=0;

$form->{invtotal}=0;
$form->{invsubtotal}=0;


	 if($form->{"printl_$x"}){
	    foreach $item (split / /, $form->{"taxaccounts"}) {
    #  if ($form->{"${item}_base"}) {
	    $form->{"${item}_base1"}= 0;
	    $form->{"${item}_rate1"}=0;
	    $form->{"${item}_description1"}="";
	    }
	  &order_links;
	  &prepare_order2; 

	  
	  ####print invoice
			  map { $form->{$_} = $myconfig{$_} } (qw(company address tel fax businessnumber nativecurr fy));
			  $form->{address} =~ s/\\n/<br>/g;
			  $form->{notes} =~ s/\n/<br>/g;
	
			  $form->{printpage}=1;
					  $form->{pagetotal}=0;
	  
			   $y=0;
			  $form->{currentrow}=0;
			  $form->{page}=1;

#  $form->header;
  if($form->{vc} eq 'customer' ){
  IS->customer_details(\%myconfig, \%$form);
  }else{
  IR->vendor_details(\%myconfig, \%$form);
	  
  }

			  &print_form_header;
			  for $z (1 .. $form->{rowcount}) {
				  $form->{"description_$i"} =~ s/\n/<br>/g;
				  $form->{currentrow}++;
				    $y++;
				    if($form->{printinvoicerowcount} > $y){
					    &print_form_row;
				    }else{
					    &print_form_row;
					     &print_page_footer;
					    print qq| <p style="page-break-before: always">&nbsp;</p>|;
					    $form->{page}++;
					    &print_form_header;
					     &print_page_header;
					    $y=0;
				    
				   }
				  

			  }
			  
			  &print_form_footer;
			 print qq| </table><p style="page-break-before: always">&nbsp;</p>|;
	###print all end
	 }


 }
  print qq|    </body></html>|;

}

sub print_order {
  map { $form->{$_} = $myconfig{$_} } (qw(company address tel fax businessnumber nativecurr fy name));
  $form->{address} =~ s/\\n/<br>/g;
  $form->{notes} =~ s/\n/<br>/g;
 $form->{employeename} = $form->{name};

 # $form->{label} = ($form->{type} eq 'sales_order') ? $locale->text('Sales Order') : $locale->text('Purchase Order');


   $form->{printpage}=1;
  
  $form->header;
  if($form->{vc} eq 'customer' ){
  IS->customer_details(\%myconfig, \%$form);
  }else{
  IR->vendor_details(\%myconfig, \%$form);
	  
  }
 print qq|<body bgcolor=ffffff>|;
 		    $form->{page}=1;
  &print_form_header;
  for $i (1 .. $form->{rowcount}-1) {
	  $form->{"description_$i"} =~ s/\n/<br>/g;
	  $form->{currentrow}++;
	    $r++;
	    if($form->{printinvoicerowcount} > $r){
		    &print_form_row;
	    }else{
		    &print_form_row;
		     &print_page_footer;
		    print qq| <p style="page-break-before: always">&nbsp;</p>|;
		    $form->{page}++;
		    &print_form_header;
		     &print_page_header;
		    $r=0;
	    
	   }
	  
  }
  
  &print_form_footer;
#&print_form;
}


sub vendor_details {

  ($null, $vendor_id) = split /--/, $form->{vendor};
  if ($vendor_id != $form->{vendor_id}) {
    $form->{vendor_id} = $vendor_id;
    IR->get_vendor(\%myconfig, \%$form);
  }

  # get address for vendor
  IR->vendor_details(\%myconfig, \%$form);
  
}


sub create_invoice {
  
  $form->isblank("ordnumber", $locale->text('Order Number missing!'));
  $form->isblank("orddate", $locale->text('Order Date missing!'));

  $form->{invdate} = $form->current_date(\%myconfig);

  $form->{orderid} = $form->{id};
  $form->{id} = '';
  $form->{rowcount}--;
  $form->{new_form} = '';
  $form->{transtype} = '';

  if ($form->{vc} eq 'vendor') {
    $form->{title} = $locale->text('Add Vendor Invoice');
    $form->{script} = 'ir.pl';
    $script = "ir";
  }
  if ($form->{vc} eq 'customer') {
    $form->{title} = $locale->text('Add Customer Invoice');
    $form->{script} = 'is.pl';
    $script = "is";
  }

  # locale messages
  $locale = new Locale "$myconfig{countrycode}", "$script";

  require "$form->{path}/$form->{script}";

  map { $form->{"select$_"} = "" } ($form->{vc}, currency);

  &invoice_links;
  IS->last_invoice(\%myconfig, \%$form);
   $form->{invnumber}=$form->{lastinvnumber};
   $form->{invnumber}++;

  &prepare_invoice;

}

sub to_order {
  
  $form->isblank("ordnumber", $locale->text('Order Number missing!'));
  $form->isblank("orddate", $locale->text('Order Date missing!'));

  $form->{invdate} = $form->current_date(\%myconfig);

  $form->{orderid} = $form->{id};
  $form->{id} = '';
  $form->{rowcount}--;
  $form->{new_form} = '';
  $form->{transtype} = $form->{to_order};
  $form->{title} = $form->{to_title};
# $form->{transtype} = 'SO';



  # locale messages
  $locale = new Locale "$myconfig{countrycode}", "$script";

  require "$form->{path}/$form->{script}";

  map { $form->{"select$_"} = "" } ($form->{vc}, currency);

  &order_links;
OE->last_invoice(\%myconfig, \%$form);
   $form->{ordnumber}=$form->{lastinvnumber};
$form->{ordnumber}++;

  &prepare_order;

}

sub yes_keep_order {

  $form->isposted(1);

}


sub no_delete_order {

  $form->isdeleted(OE->delete_order(\%myconfig, \%$form));
  
}


