#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors: Antonio Gallardo <agssa@ibw.com.ni>
#                Benjamin Lee <benjaminlee@consultant.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# module for preparing Income Statement and Balance Sheet
# 
#======================================================================


use SL::RP;
$form->{rowcount}=40;

1;
# end of main

# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')

# $locale->text('Income Statement')
# $locale->text('Balance Sheet')
# $locale->text('AR Aging')
# $locale->text('AP Aging')
# $locale->text('Tax Report')


sub report {

  $form->header;
  
  $title = $locale->text($form->{title});

  $gifi = qq|
<tr>

  <th align=right>|.$locale->text('Accounts').qq|</th>
  <td>
     
     <input name=accounttype class=radio type=radio value=standard checked> |.$locale->text('Standard').qq|
     
     <input name=accounttype class=radio type=radio value=gifi> |.$locale->text('GIFI').qq|
     
  </td>

</tr>
|;

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=search>

<table border=1>
<tr><th class=listtop bgcolor=000000>$title</font></th></tr>

<tr valign=top>
<td>
<table>

|;

  if ($form->{title} eq "Income Statement") {
    print qq|
<tr>
       <th align=right>|.$locale->text('Project No.').qq|</th>
  <td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=project size=5></td>
 <th align=right>|.$locale->text('Sub No.').qq|</th>
  <td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=sub size=5></td>
</tr>
<tr>

  <th align=right>|.$locale->text('From').qq|&nbsp;</th>
  <td><input name=fromdate size=11 value="$form->{fromdate}" title=($myconfig{dateformat})>
  
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].fromdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input name=todate size=11 title=($myconfig{dateformat})>  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['search'].todate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script></td>

</tr>

<tr>
  <th colspan=4>|.$locale->text('Compare to').qq|</th>
</tr>

<tr>

  <th align=right>|.$locale->text('From').qq|&nbsp;</th>
  <td><input name=comparefromdate size=11 title=($myconfig{dateformat})>  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar3Callback(date, month, year)
        {
            document.forms['search'].comparefromdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar3 = new dynCalendar('calendar3', 'calendar3Callback', 'javascript/images/');
    //-->
    </script>
</td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input name=comparetodate size=11 title=($myconfig{dateformat})><script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar4Callback2(date, month, year)
        {
            document.forms['search'].comparetodate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar4 = new dynCalendar('calendar4', 'calendar4Callback2', 'javascript/images/');
    //-->
    </script></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
  
     <input name=l_heading class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Heading').qq|
  
  </td>

</tr>
|;
  }


  if ($form->{title} eq "Balance Sheet") {
    print qq|
<tr>
       <th align=right>|.$locale->text('Project No.').qq|</th>
  <td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=project size=5></td>
 <th align=right>|.$locale->text('Sub No.').qq|</th>
  <td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=sub size=5></td>
</tr>
<tr>

  <th align=right>|.$locale->text('as of').qq|&nbsp;</th>
  <td><input name=asofdate size=11 value="$form->{asofdate}" title=($myconfig{dateformat})>
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].asofdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>

</tr>

<tr>
  <th colspan=2>|.$locale->text('Compare to').qq|</th>
</tr>

<tr>

  <th align=right>|.$locale->text('as of').qq|&nbsp;</th>
  <td><input name=compareasofdate size=11  title=($myconfig{dateformat})>
  
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['search'].compareasofdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
    </td>

</tr>

<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td>
     
     <input name=l_heading class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Heading').qq|
     
  </td>

</tr>
|;

  }


  if ($form->{title} =~ /Trial Balance/) {
    print qq|
    
<tr>
       <th align=right>|.$locale->text('Project No.').qq|</th>
  <td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=project size=5></td>
 <th align=right>|.$locale->text('Sub No.').qq|</th>
  <td ><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=sub size=5></td>
</tr>


<tr>

  <th align=right>|.$locale->text('From').qq|&nbsp;</th>
  <td><input name=fromdate size=11 title=($myconfig{dateformat}) value=$form->{fromdate}>
   <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].fromdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input name=todate size=11 title=($myconfig{dateformat})>  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['search'].todate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
  
    <input name=l_heading class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Heading').qq|
    <input name=l_subtotal class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Subtotal').qq|
    
  </td>

</tr>
|;
  }

  
  if (($form->{title} eq "Tax Paid") || ($form->{title} eq "Tax Collected")) {
    $gifi = "";
    RP->get_taxaccounts(\%myconfig, \%$form);

    print qq|
<tr>

  <th align=right>|.$locale->text('From').qq|</th>
  <td><input name=fromdate size=11 title=($myconfig{dateformat})  value=$form->{fromdate}>
     <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].fromdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input name=todate  title=($myconfig{dateformat}) size=11>
  <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['search'].todate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
  </td>

</tr>

<tr>

  <th align=right>|.$locale->text('Report for').qq|</th>
  <td colspan=3>
|;

  $checked = "checked";
  foreach $item (@{ $form->{taxaccounts} }) {
    ($accno, $description) = split /--/, $item;
    
    print qq|<input name=accno class=radio type=radio value=$accno $checked>&nbsp;$description

    <input name="${accno}_description" type=hidden value="$description">|;

    $checked = "";
  }

  print qq|
  <input type=hidden name=db value=$form->{db}>
  <input type=hidden name=sort value=transdate>

  </td>

</tr>|;


  if (@{ $form->{gifi_taxaccounts} }) {
    print qq|
<tr>

  <th align=right>|.$locale->text('GIFI').qq|</th>
  <td colspan=3>
|;

    foreach $item (@{ $form->{gifi_taxaccounts} }) {
      ($accno, $description) = split /--/, $item;
      
      print qq|<input name=accno class=radio type=radio value="gifi_$accno" $checked>&nbsp;$description

      <input name="gifi_${accno}_description" type=hidden value="$description">|;

    }

    print qq|
  </td>

</tr>|;
  }


print qq|
<tr>
  <th align=right>|.$locale->text('Include in Report').qq|</th>

  <td colspan=3>
  <input name="l_id" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('ID').qq|
  <input name="l_invnumber" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Invoice Number').qq|
  <input name="l_transdate" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Invoice Date');
  
  if ($form->{db} eq 'ar') {
    print qq|<br>
  <input name="l_name" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Customer');
  }
  if ($form->{db} eq 'ap') {
    print qq|<br>
  <input name="l_name" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Vendor');
  }
  
  print qq|
  <input name="l_netamount" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Amount').qq|
  <input name="l_tax" class=checkbox type=checkbox value=Y checked>&nbsp;|.$locale->text('Tax').qq|
  <input name="l_amount" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Total').qq|
  <br><input name="l_subtotal" class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Subtotal').qq|

  </td>
</tr>
    
|;

    $form->{title} = 'Tax Report';
    
  }


  if ($form->{title} eq "AP Aging") {
    $gifi = "";
    
    # setup vendor selection
    $form->all_vc(\%myconfig, "vendor");

    $selection = "<option selected>" . $locale->text('All Vendors') ."\n";
    
    foreach $ref (@{ $form->{all_vendor} }) {
      $selection .= "<option>$ref->{name}--$ref->{id}\n";
    }
    
    print qq|
<tr>

  <th align=right>|.$locale->text('Vendor').qq|</th>
  <td colspan=3><select name=vendor>$selection</select></td>

</tr>
<tr>


    <th align=right>|.$locale->text('Vendor Code').qq| </th>
  <td><input name=customercode size=40 value=$form->{customercode}></td>

  
</tr>

<tr>


    <th align=right>|.$locale->text('Location Code').qq| </th>
  <td><input name=locationcode size=40 value=$form->{locationcode}></td>

  
</tr>


<tr>

  <th align=right>|.$locale->text('To').qq|&nbsp;</th>
  <td colspan=3><input name=todate size=11 title=($myconfig{dateformat})>
   <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
   <script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].todate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    </td>

</tr>


<tr>


    <td  colspan=2><input name=summary type=radio class=radio value=1 checked> |.$locale->text('Summary').qq|<input name=summary type=radio class=radio value=0> |.$locale->text('Detail').qq|  </td>
  

  
</tr>
|;
  }


  if ($form->{title} eq "AR Aging") {
    $gifi = "";

    # setup customer selection
    $form->all_vc(\%myconfig, "customer");

    $selection = "<option selected>" . $locale->text('All Customers') ."\n";
    
    foreach $ref (@{ $form->{all_customer} }) {
      $selection .= "<option>$ref->{name}--$ref->{id}\n";
    }
    
    print qq|
<tr>

  <th align=right>|.$locale->text('Customer').qq|</th>
  <td colspan=3><select name=customer>$selection</select></td>

</tr>
<tr>


    <th align=right>|.$locale->text('Customer Code').qq| </th>
  <td><input name=customercode size=40 value=$form->{customercode}></td>

  
</tr>

<tr>


    <th align=right>|.$locale->text('Location Code').qq| </th>
  <td><input name=locationcode size=40 value=$form->{locationcode}></td>

  
</tr>
<tr>


    <th align=right>|.$locale->text('Sales Person').qq| </th>
  <td><input name=salesperson size=40 value=$form->{salesperson}></td>

  
</tr>

<tr>

  <th align=right>|.$locale->text('To').qq|&nbsp;</th>
  <td colspan=3><input name=todate title=($myconfig{dateformat}) size=11>    <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['search'].todate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script></td>

</tr>

<tr>


    <td  colspan=2><input name=summary type=radio class=radio value=1 checked> |.$locale->text('Summary').qq|<input name=summary type=radio class=radio value=0> |.$locale->text('Detail').qq|  </td>
  

  
</tr>

|;
  }

@title =split / /,lc $form->{title};
  print qq|

$gifi

</table>

</td>
</tr>
</table>

<p>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=rowcount value=$form->{rowcount}>
<input type=hidden name=ptitle value='|.(join '_', @title).qq|'>

<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Print Report').qq|">
</form>

<p>|.$locale->text("To show current $form->{title}, leave fields blank.")

.qq|

</body>
</html>
|;

}


# these are buttons as well, so flag them to generate a sub entry
# type=submit $locale->text('Generate Income Statement')
# type=submit $locale->text('Generate Balance Sheet')
# type=submit $locale->text('Generate Trial Balance')
# type=submit $locale->text('Generate AR Aging')
# type=submit $locale->text('Generate AP Aging')
# type=submit $locale->text('Generate Tax Report')

# $locale->text("To show current Income Statement, leave fields blank.")
# $locale->text("To show current Balance Sheet, leave fields blank.")
# $locale->text("To show current Trial Balance, leave fields blank.")
# $locale->text("To show current AR Aging, leave fields blank.")
# $locale->text("To show current AP Aging, leave fields blank.")
# $locale->text("To show current Tax Report, leave fields blank.")

sub continue{
&{"generate_$form->{ptitle}"};
}
sub print_report{
&{"generate_$form->{ptitle}_print"};
}

sub generate_income_statement {

  RP->income_statement(\%myconfig, \%$form);


  $form->{period} = $locale->date(\%myconfig, $form->current_date(\%myconfig), 1);

  # if there are any dates construct a where
  if ($form->{fromdate} || $form->{todate}) {
    
    unless ($form->{todate}) {
      $form->{todate} = $form->current_date(\%myconfig);
    }

    $longtodate = $locale->date(\%myconfig, $form->{todate}, 1);
    $shorttodate = $locale->date(\%myconfig, $form->{todate});

    $longfromdate = $locale->date(\%myconfig, $form->{fromdate}, 1);
    $shortfromdate = $locale->date(\%myconfig, $form->{fromdate});
    
    $form->{this_period} = "$shortfromdate<br>\n$shorttodate";
    $form->{period} = $locale->text('for Period').qq|<br>\n$longfromdate |.$locale->text('To').qq| $longtodate|;
  }

  if ($form->{comparefromdate} || $form->{comparetodate}) {
    $longcomparefromdate = $locale->date(\%myconfig, $form->{comparefromdate}, 1);
    $shortcomparefromdate = $locale->date(\%myconfig, $form->{comparefromdate});
    
    $longcomparetodate = $locale->date(\%myconfig, $form->{comparetodate}, 1);
    $shortcomparetodate = $locale->date(\%myconfig, $form->{comparetodate});
    
    $form->{last_period} = "$shortcomparefromdate<br>\n$shortcomparetodate";
    $form->{period} .= "<br>\n$longcomparefromdate ".$locale->text('To').qq| $longcomparetodate|;
  }

 
  # setup variables for the form
  map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber));
  $form->{address} =~ s/\\n/<br>/g;

  $form->{templates} = $myconfig{templates};

  $form->{IN} = "income_statement.html";
  
  $form->parse_template;

}

sub generate_balance_sheet_print {
&generate_balance_sheet;
}
sub generate_balance_sheet {


  RP->balance_sheet(\%myconfig, \%$form);

  
  $form->{period} = $locale->date(\%myconfig, $form->current_date(\%myconfig), 1);
  
  # define Retained Earnings account
  push(@{$form->{equity_account}}, $locale->text('Retained Earnings'));

  $form->{this_period} = $locale->date(\%myconfig, $form->{asofdate});
  $form->{last_period} = $locale->date(\%myconfig, $form->{compareasofdate});

  $form->{IN} = "balance_sheet.html";

  # setup company variables for the form
  map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr));
  $form->{address} =~ s/\\n/<br>/g;

  $form->{templates} = $myconfig{templates};

  $form->parse_template;

}


# Antonio Gallardo
#
# D.S. Feb 16, 2001
# included links to display transactions for period entered
# added headers and subtotals
#
sub generate_trial_balance {


  # get for each account initial balance, debits and credits
  RP->trial_balance_details(\%myconfig, \%$form);


  # if there are any dates
  if ($form->{fromdate} || $form->{todate}) {
    if ($form->{fromdate}) {
      $fromdate = $locale->date(\%myconfig, $form->{fromdate}, 1);
    }
    if ($form->{todate}) {
      $todate = $locale->date(\%myconfig, $form->{todate}, 1);
    }

    $form->{period} = "$fromdate - $todate";
  } else {
    $form->{period} = $locale->date(\%myconfig, $form->current_date(\%myconfig), 1);
  }
  
    if ($form->{project}) {
      $form->{period} .= "<br>".$locale->text('Project')." : $form->{project}";
    }
    if ($form->{sub}) {
      $form->{period} .= "<br>".$locale->text('Sub')." : $form->{sub}";
    }
  @column_index = qw(accno description count debit credit);

  $column_header{accno}       = qq|<th>|.$locale->text('Account').qq|</th>|;
  $column_header{description} = qq|<th>|.$locale->text('Description').qq|</th>|;  
  $column_header{count}       = qq|<th>|.$locale->text('TR.NO.').qq|</th>|;
  $column_header{debit}       = qq|<th>|.$locale->text('Debit').qq|</th>|;
  $column_header{credit}      = qq|<th>|.$locale->text('Credit').qq|</th>|;


  # reverse scan TB and set empty headers not to display
  $heading = 1;
  foreach $ref (reverse @{ $form->{TB} }) {
    $ref->{display} = 1;
    if ($ref->{charttype} eq "H") {
      $ref->{display} = 0 if ($heading);
      $heading = 1;
    } else {
      $heading = 0;
      unless ($form->{lastaccno}{$ref->{category}} ne "") {
	$form->{lastaccno}{$ref->{category}} = $ref->{accno};
      }
    }
    # subtotal sections
    $form->{subtotal}{$ref->{category}}{debit} += $ref->{debit};
    $form->{subtotal}{$ref->{category}}{credit} += $ref->{credit};
  }

  foreach $key (keys %{ $form->{lastaccno} }) {
    push @{ $form->{TB} }, { charttype => 'S',
                             accno => $form->{lastaccno}{$key},
			     debit => $form->{subtotal}{$key}{debit},
			     credit => $form->{subtotal}{$key}{credit},
			     display => 1 };
  }

  if ($form->{accounttype} eq 'gifi') {
    $column_header{accno} = qq|<th>|.$locale->text('GIFI').qq|</th>|;
  }

  $form->{title} = $locale->text('Trial Balance');

  $form->header;
  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$form->{period}</td></tr>

<tr class=listheading bgcolor=336666>|;

  map { print "$column_header{$_}\n" } @column_index;

  print qq|
</tr>
|;



  # sort the whole thing by account numbers and display
  foreach $ref (sort { $a->{accno} <=> $b->{accno} } @{ $form->{TB} }) {

    $description = $form->escape($ref->{description});

    $href = qq|ca.pl?path=$form->{path}&action=list_transactions&accounttype=$form->{accounttype}&login=$form->{login}&sessionid=$form->{sessionid}&fromdate=$form->{fromdate}&todate=$form->{todate}&sort=transdate&l_subtotal=$form->{l_subtotal}|;
    if ($form->{accounttype} eq 'gifi') {
      $href .= "&gifi_accno=$ref->{accno}&gifi_description=$description";
      $na = $locale->text('N/A');
      map { $ref->{$_} = $na } qw(accno description) unless $ref->{accno};
    } else {
      $href .= "&accno=$ref->{accno}&description=$description";
    }

    if($form->{project}){
    	$href .= "&project=".$form->escape($form->{project});
    }
    if($form->{sub}){
    	$href .= "&sub=".$form->escape($form->{sub});
    }
        $debit = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
    $credit = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");
    
    if($debit == 0){
    	$debit = "0.00";
    }
    if($credit == 0){
    	$credit = "0.00";
    }

    if ($ref->{charttype} eq "H") {
      next unless ($form->{l_heading});

      $column_data{accno} = "<th>&nbsp;</th>";
      $column_data{description} = "<th>$ref->{description}</th>";
      $column_data{debit} = "<th>&nbsp;</th>";
      $column_data{credit} = "<th>&nbsp;</th>";
      $column_data{count} = "<th>&nbsp;</th>";
    }



    if ($ref->{charttype} eq "A") {
	    	$total_debit += $ref->{debit};
		$total_credit += $ref->{credit};
		
		$column_data{accno} = "<td><a href=$href>$ref->{accno}</a></td>";
		$column_data{description} = "<td>$ref->{description}</td>";
		$column_data{debit} = "<td align=right>$debit</td>";
		$column_data{credit} = "<td align=right>$credit</td>";
		$column_data{count} = "<td align=right>$ref->{count}</td>";

		

    }
    $totalcount+=$ref->{count};
    # subtotal
    if ($ref->{charttype} eq "S") {
      next unless ($form->{l_subtotal});

      map { $column_data{$_} = "<th>&nbsp;</th>" } @column_index;

      $debit = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
      $credit = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");
      
      $column_data{debit} = "<th align=right>$debit</th>";
      $column_data{credit} = "<th align=right>$credit</th>";
    }


    if ($ref->{display}) {
      if ($ref->{charttype} eq "H") {
	print qq|<tr class=listheading bgcolor=336666>\n|;
      }
      if ($ref->{charttype} eq "S") {
	print qq|<tr class=listsubtotal bgcolor=333366>\n|;
      }
      if ($ref->{charttype} eq "A") {
	$i++; $i %= 2;
	print qq|<tr class=listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >\n|;
      }

      map { print "$column_data{$_}\n" } @column_index;

      print qq|</tr>|;
    }
  }

  $total_debit = $form->format_amount(\%myconfig, $total_debit, 2, "&nbsp;");
  $total_credit = $form->format_amount(\%myconfig, $total_credit, 2, "&nbsp;");

  print qq|<tr class=listtotal bgcolor=000000>
           <th>&nbsp;</th>
           <th>&nbsp;</th>
	   <th align=right>$totalcount</th>
           <th align=right>$total_debit</th>
           <th align=right>$total_credit</th>
	   </tr>
	   </table>
<p>
|;

  print $locale->text('Click on account number to display transactions')
  
  .qq|

</body>
</html>
|;

}

sub generate_trial_balance_print {

 map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr));
  $form->{address} =~ s/\\n/<br>/g;

  # get for each account initial balance, debits and credits
  RP->trial_balance_details(\%myconfig, \%$form);
 $form->{title} = $locale->text('Trial Balance');


  # if there are any dates
  if ($form->{fromdate} || $form->{todate}) {
    if ($form->{fromdate}) {
      $fromdate = $locale->date(\%myconfig, $form->{fromdate}, 1);
      $form->{title} .= $locale->text(' For ') .$fromdate;
    }
    if ($form->{todate}) {
      $todate = $locale->date(\%myconfig, $form->{todate}, 1);
     $form->{title} .= $locale->text(' - ') .$todate;
    }

    $form->{period} = "$fromdate - $todate";
  } else {
    $form->{period} = $locale->date(\%myconfig, $form->current_date(\%myconfig), 1);
  }

      if ($form->{project}) {
      $form->{period} .= "<br>".$locale->text('Project')." : $form->{project}";
    }
    if ($form->{sub}) {
      $form->{period} .= "<br>".$locale->text('Sub')." : $form->{sub}";
    }
  @column_index = qw(accno description debit credit);

  $column_header{accno} = qq|<th class=print><hr noshade size=2>|.$locale->text('Account').qq|<hr noshade size=2></th>|;
  $column_header{description} = qq|<th class=print><hr noshade size=2>|.$locale->text('Description').qq|<hr noshade size=2></th>|;
#  $column_header{count} = qq|<th class=print><hr noshade size=2>|.$locale->text('TR.NO.').qq|<hr noshade size=2></th>|;
  $column_header{debit} = qq|<th class=print><hr noshade size=2>|.$locale->text('Debit').qq|<hr noshade size=2></th>|;
  $column_header{credit} = qq|<th class=print><hr noshade size=2>|.$locale->text('Credit').qq|<hr noshade size=2></th>|;


  # reverse scan TB and set empty headers not to display
  $heading = 1;
  foreach $ref (reverse @{ $form->{TB} }) {
    $ref->{display} = 1;
    if ($ref->{charttype} eq "H") {
      $ref->{display} = 0 if ($heading);
      $heading = 1;
    } else {
      $heading = 0;
      unless ($form->{lastaccno}{$ref->{category}} ne "") {
	$form->{lastaccno}{$ref->{category}} = $ref->{accno};
      }
    }
    # subtotal sections
    $form->{subtotal}{$ref->{category}}{debit} += $ref->{debit};
    $form->{subtotal}{$ref->{category}}{credit} += $ref->{credit};
  }

  foreach $key (keys %{ $form->{lastaccno} }) {
    push @{ $form->{TB} }, { charttype => 'S',
                             accno => $form->{lastaccno}{$key},
			     debit => $form->{subtotal}{$key}{debit},
			     credit => $form->{subtotal}{$key}{credit},
			     display => 1 };
  }

  if ($form->{accounttype} eq 'gifi') {
    $column_header{accno} = qq|<th class=print>|.$locale->text('GIFI').qq|</th>|;
  }


  $form->header;
  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>
<center><h1 class=print>$form->{company}</h1></center>
<center><h1 class=print>$form->{title}</h1></center>
<table  class=print border=0 width=100%>
|;

#<tr><td colspan=$colspan>$form->{period}</td></tr>
print qq|
<tr >|;

  map { print "$column_header{$_}\n" } @column_index;

  print qq|
</tr>
|;



  # sort the whole thing by account numbers and display
  foreach $ref (sort { $a->{accno} <=> $b->{accno} } @{ $form->{TB} }) {

    $description = $form->escape($ref->{description});

    $href = qq|ca.pl?path=$form->{path}&action=list_transactions&accounttype=$form->{accounttype}&login=$form->{login}&sessionid=$form->{sessionid}&fromdate=$form->{fromdate}&todate=$form->{todate}&sort=transdate&l_subtotal=$form->{l_subtotal}|;
    if ($form->{accounttype} eq 'gifi') {
      $href .= "&gifi_accno=$ref->{accno}&gifi_description=$description";
      $na = $locale->text('N/A');
      map { $ref->{$_} = $na } qw(accno description) unless $ref->{accno};
    } else {
      $href .= "&accno=$ref->{accno}&description=$description";
    }

    $debit = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
    $credit = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");
    if($debit==0){
    	$debit="0.00";
    }
    if($credit==0){
    	$credit="0.00";
    }
	
    if ($ref->{charttype} eq "H") {
      next unless ($form->{l_heading});

      $column_data{accno} = "<th class=print>&nbsp;</th>";
      $column_data{description} = "<th align=left class=print>$ref->{description}</th>";
      $column_data{debit} = "<th class=print>&nbsp;</th>";
      $column_data{credit} = "<th class=print>&nbsp;</th>";
    }



    if ($ref->{charttype} eq "A") {


		$column_data{accno} = "<td class=print><a href=$href>$ref->{accno}</a></td>";
		$column_data{description} = "<td class=print>$ref->{description}</td>";
		$column_data{debit} = "<td align=right class=print>$debit</td>";
		$column_data{credit} = "<td align=right class=print>$credit</td>";

		$total_debit += $ref->{debit};
		$total_credit += $ref->{credit};

    }

    # subtotal
    if ($ref->{charttype} eq "S") {
      next unless ($form->{l_subtotal});

      map { $column_data{$_} = "<th class=print>&nbsp;</th>" } @column_index;

      $debit = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
      $credit = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");
      
      $column_data{debit} = "<th align=right class=print><hr noshade size=1>$debit</th>";
      $column_data{credit} = "<th align=right class=print><hr noshade size=1>$credit</th>";
    }


    if ($ref->{display}) {
      if ($ref->{charttype} eq "H") {
	print qq|<tr  class=print>\n|;
      }
      if ($ref->{charttype} eq "S") {
	print qq|<tr  class=print>\n|;
      }
      if ($ref->{charttype} eq "A") {
	$i++; $i %= 2;
	print qq|<tr  class=print>\n|;
      }

      map { print "$column_data{$_}\n" } @column_index;

      print qq|</tr>|;
    }
  }

  $total_debit = $form->format_amount(\%myconfig, $total_debit, 2, "&nbsp;");
  $total_credit = $form->format_amount(\%myconfig, $total_credit, 2, "&nbsp;");

  print qq|<tr >
           <th class=print><hr noshade size=2>&nbsp;<hr noshade size=2></th>
           <th class=print><hr noshade size=2>&nbsp;<hr noshade size=2></th>
           <th align=right class=print><hr noshade size=2>$total_debit<hr noshade size=2</th>
           <th align=right class=print><hr noshade size=2>$total_credit<hr noshade size=2></th>
	   </tr>
	   </table>
<p>


</body>
</html>
|;

}


sub generate_trial_balance_summary {


  # get for each account initial balance, debits and credits
  RP->trial_balance_details(\%myconfig, \%$form);


  # if there are any dates
  if ($form->{fromdate} || $form->{todate}) {
    if ($form->{fromdate}) {
      $fromdate = $locale->date(\%myconfig, $form->{fromdate}, 1);
    }
    if ($form->{todate}) {
      $todate = $locale->date(\%myconfig, $form->{todate}, 1);
    }

    $form->{period} = "$fromdate - $todate";
  } else {
    $form->{period} = $locale->date(\%myconfig, $form->current_date(\%myconfig), 1);
  }
    if ($form->{project}) {
      $form->{period} .= "<br>".$locale->text('Project')." : $form->{project}";
    }
    if ($form->{sub}) {
      $form->{period} .= "<br>".$locale->text('Sub')." : $form->{sub}";
    }
  @column_index = qw(accno description count debit credit);

  $column_header{accno} = qq|<th>|.$locale->text('Account').qq|</th>|;
  $column_header{description} = qq|<th>|.$locale->text('Description').qq|</th>|;
  $column_header{count} = qq|<th>|.$locale->text('TR.NO.').qq|</th>|;
  $column_header{debit} = qq|<th>|.$locale->text('Debit').qq|</th>|;
  $column_header{credit} = qq|<th>|.$locale->text('Credit').qq|</th>|;


  # reverse scan TB and set empty headers not to display
  $heading = 1;
  foreach $ref (reverse @{ $form->{TB} }) {
    $ref->{display} = 1;
    if ($ref->{charttype} eq "H") {
      $ref->{display} = 0 if ($heading);
      $heading = 1;
    } else {
      $heading = 0;
      unless ($form->{lastaccno}{$ref->{category}} ne "") {
	$form->{lastaccno}{$ref->{category}} = $ref->{accno};
      }
    }
    # subtotal sections
    $form->{subtotal}{$ref->{category}}{debit} += $ref->{debit};
    $form->{subtotal}{$ref->{category}}{credit} += $ref->{credit};
  }

  foreach $key (keys %{ $form->{lastaccno} }) {
    push @{ $form->{TB} }, { charttype => 'S',
                             accno => $form->{lastaccno}{$key},
			     debit => $form->{subtotal}{$key}{debit},
			     credit => $form->{subtotal}{$key}{credit},
			     display => 1 };
  }

  if ($form->{accounttype} eq 'gifi') {
    $column_header{accno} = qq|<th>|.$locale->text('GIFI').qq|</th>|;
  }

  $form->{title} = $locale->text('Trial Balance');

  $form->header;
  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$form->{period}</td></tr>

<tr class=listheading bgcolor=336666>|;

  map { print "$column_header{$_}\n" } @column_index;

  print qq|
</tr>
|;

    #####################newadded
    $debtors=0;
    $creditors=0;
     $debit_list="<tr class=listheading bgcolor=336666>";
     $credit_list="<tr class=listheading bgcolor=336666>";
 map { $debit_list.= "$column_header{$_}\n" } @column_index;
 map { $credit_list.= "$column_header{$_}\n" } @column_index;
     $debit_list.="</tr>";
     $credit_list.="</tr>";
   #####################newadded

  # sort the whole thing by account numbers and display
  foreach $ref (sort { $a->{accno} <=> $b->{accno} } @{ $form->{TB} }) {

   #####################newadded

	    if ($ref->{category} eq "D") {
	    	$debtors += $ref->{debit} - $ref->{credit};
		$debitalld +=$ref->{debit};
		$creditalld +=$ref->{credit};
	$ref->{debit} = $form->format_amount(\%myconfig, $ref->{debit}, 2, "0.00");

		if ($ref->{charttype} ne "H") {
			    $href = qq|ca.pl?path=$form->{path}&action=list_transactions&accounttype=$form->{accounttype}&login=$form->{login}&sessionid=$form->{sessionid}&fromdate=$form->{fromdate}&todate=$form->{todate}&sort=transdate&l_subtotal=$form->{l_subtotal}|;
			 $href .= "&accno=$ref->{accno}&description=$description";
			
			$column_data{accno} = "<td><a href=$href>$ref->{accno}</a></td>";
			$column_data{count} = "<td align=right>$ref->{count}</td>";
			$column_data{description} = "<td>$ref->{description}</td>";
			$column_data{debit} = "<td align=right>$ref->{debit}</td>";
			$column_data{credit} = "<td align=right>$ref->{credit}</td>";
			$i++; $i %= 2;
			$debit_list .="<tr class=listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >";
      			map { $debit_list .= "$column_data{$_}\n" } @column_index;
			$debit_list .="</tr>";
		}
	    }else{
		if ($ref->{category} eq "C") {
		  if ($ref->{charttype} ne "H") {
			    $href = qq|ca.pl?path=$form->{path}&action=list_transactions&accounttype=$form->{accounttype}&login=$form->{login}&sessionid=$form->{sessionid}&fromdate=$form->{fromdate}&todate=$form->{todate}&sort=transdate&l_subtotal=$form->{l_subtotal}|;
			 $href .= "&accno=$ref->{accno}&description=$description";
			
			$creditors += $ref->{debit} -$ref->{credit};
		$debitallc +=$ref->{debit};
		$creditallc +=$ref->{credit};
			$column_data{accno} = "<td><a href=$href>$ref->{accno}</a></td>";
			$column_data{description} = "<td>$ref->{description}</td>";
			$column_data{count} = "<td align=right>$ref->{count}</td>";
			$column_data{debit} = "<td align=right>$ref->{debit}</td>";
			$column_data{credit} = "<td align=right>$ref->{credit}</td>";
			$i++; $i %= 2;
			$credit_list .="<tr class=listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >";
     			map { $credit_list .= "$column_data{$_}\n" } @column_index;
			$credit_list .="</tr>";
		 }
	    	}else{
   #####################newadded


    $description = $form->escape($ref->{description});

    $href = qq|ca.pl?path=$form->{path}&action=list_transactions&accounttype=$form->{accounttype}&login=$form->{login}&sessionid=$form->{sessionid}&fromdate=$form->{fromdate}&todate=$form->{todate}&sort=transdate&l_subtotal=$form->{l_subtotal}|;
    if ($form->{accounttype} eq 'gifi') {
      $href .= "&gifi_accno=$ref->{accno}&gifi_description=$description";
      $na = $locale->text('N/A');
      map { $ref->{$_} = $na } qw(accno description) unless $ref->{accno};
    } else {
      $href .= "&accno=$ref->{accno}&description=$description";
    }

    $debit = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
    $credit = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

    if ($ref->{charttype} eq "H") {
      next unless ($form->{l_heading});

      $column_data{accno} = "<th>&nbsp;</th>";
      $column_data{description} = "<th>$ref->{description}</th>";
     $column_data{debit} = "<th>&nbsp;</th>";
      $column_data{credit} = "<th>&nbsp;</th>";
    }



    if ($ref->{charttype} eq "A") {

			$column_data{count} = "<td align=right>$ref->{count}</td>";

			$column_data{accno} = "<td><a href=$href>$ref->{accno}</a></td>";
			$column_data{description} = "<td>$ref->{description}</td>";
 			$column_data{debit} = "<td align=right>$debit</td>";
			$column_data{credit} = "<td align=right>$credit</td>";


		$total_debit += $ref->{debit};
		$total_credit += $ref->{credit};

    }


    # subtotal
    if ($ref->{charttype} eq "S") {
      next unless ($form->{l_subtotal});

      map { $column_data{$_} = "<th>&nbsp;</th>" } @column_index;

      $debit = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
      $credit = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

      $column_data{debit} = "<th align=right>$debit</th>";
      $column_data{credit} = "<th align=right>$credit</th>";
    }


    if ($ref->{display}) {
      if ($ref->{charttype} eq "H") {
	print qq|<tr class=listheading bgcolor=336666>\n|;
      }
      if ($ref->{charttype} eq "S") {
	print qq|<tr class=listsubtotal bgcolor=333366>\n|;
      }
      if ($ref->{charttype} eq "A") {
			$i++; $i %= 2;
			print qq|<tr class=listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >\n|;

      }

      map { print "$column_data{$_}\n" } @column_index;

      print qq|</tr>|;

    #####################newadded
     	   	}
 	   }
   #####################newadded

    }
  }


  $debtors1 = $form->format_amount(\%myconfig, $debtors, 2, "0.00");
  $creditors1 = $form->format_amount(\%myconfig, $creditors, 2, "0.00");

    #####################newadded
   if($debtors > 0){
  	$textd ="<th align=right>$debtors1</th>            <th align=right>0.00</th>";
	$total_debit += $debtors;
  }else{
  	$debtors *= -1;
 	$debtors1 = $form->format_amount(\%myconfig, $debtors, 2, "0.00");
  	$textd ="<th align=right>0.00</th>            <th align=right>$debtors1</th>";
	$total_credit += $debtors;
  }

    if($creditors > 0){
	$total_debit += $creditors;
  	$textc ="<th align=right>$creditors1</th>            <th align=right>0.00</th>";
  }else{
  	$creditors *= -1;
   	$creditors1 = $form->format_amount(\%myconfig, $creditors, 2, "0.00");
 	$textc ="<th align=right>0.00</th>            <th align=right>$creditors1</th>";
	$total_credit += $creditors;
  }

$i++; $i %= 2;
  print qq|<tr class=listrow$i bgcolor=000000>
           <th>&nbsp;</th>
           <th align=left>|.$locale->text('Debitors').qq|</th>
           <th>&nbsp;</th>
		$textd
	   </tr>

<p>
|;
$i++; $i %= 2;
  print qq|<tr class=listrow$i bgcolor=000000>
           <th>&nbsp;</th>
           <th align=left>|.$locale->text('Creditors').qq|</th>
           <th>&nbsp;</th>
		$textc
	   </tr>

<p>
|;
   #####################newadded
  $total_debit = $form->format_amount(\%myconfig, $total_debit, 2, "&nbsp;");
  $total_credit = $form->format_amount(\%myconfig, $total_credit, 2, "&nbsp;");


  print qq|<tr class=listtotal bgcolor=000000>
           <th>&nbsp;</th>
           <th>Balance</th>
            <th>&nbsp;</th>
          <th align=right>$total_debit</th>
           <th align=right>$total_credit</th>
	   </tr>
	   </table>
<p>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan>|;
print $locale->text('Debtors Summary')
.qq|</font></th></tr>
$debit_list
<tr  class=listsubtotal bgcolor=333366>
|;
  $debitalld = $form->format_amount(\%myconfig, $debitalld, 2, "&nbsp;");
  $creditalld = $form->format_amount(\%myconfig, $creditalld, 2, "&nbsp;");
    map { $column_data{$_} = "<th>&nbsp;</th>" } @column_index;
     $column_data{debit} = "<th align=right>$debitalld</th>";
      $column_data{credit} = "<th align=right>$creditalld</th>";

      map { print "$column_data{$_}\n" } @column_index;

print qq|
	   </tr>

<tr class=listtotal bgcolor=000000>
           <th>&nbsp;</th>
           <th>Balance</th>
           <th>&nbsp;</th>
		$textd
	   </tr>

<p>


</table>
<br>
<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan>|;
print $locale->text('Creditors Summary')
.qq|</font></th></tr>
$credit_list
<tr  class=listsubtotal bgcolor=333366>
|;
  $debitallc = $form->format_amount(\%myconfig, $debitallc, 2, "&nbsp;");
  $creditallc = $form->format_amount(\%myconfig, $creditallc, 2, "&nbsp;");
    map { $column_data{$_} = "<th>&nbsp;</th>" } @column_index;
     $column_data{debit} = "<th align=right>$debitallc</th>";
      $column_data{credit} = "<th align=right>$creditallc</th>";

      map { print "$column_data{$_}\n" } @column_index;

print qq|
	   </tr>
<tr class=listtotal bgcolor=000000>
           <th>&nbsp;</th>
           <th>Balance</th>
           <th>&nbsp;</th>
		$textc
	   </tr>

<p>

</table><br>
|;

  print $locale->text('Click on account number to display transactions')

  .qq|

</body>
</html>
|;

}


sub generate_trial_balance_summary_print {

  map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr));
  $form->{address} =~ s/\\n/<br>/g;

  # get for each account initial balance, debits and credits
  RP->trial_balance_details(\%myconfig, \%$form);

  $form->{title} = $locale->text('Trial Balance');

  # if there are any dates
  if ($form->{fromdate} || $form->{todate}) {
    if ($form->{fromdate}) {
      $fromdate = $locale->date(\%myconfig, $form->{fromdate}, 1);
   $form->{title}.=$locale->text(' For ').$fromdate
   }
    if ($form->{todate}) {
      $todate = $locale->date(\%myconfig, $form->{todate}, 1);
   $form->{title}.=$locale->text(' - ').$todate
   }

    $form->{period} = "$fromdate - $todate";
  } else {
    $form->{period} = $locale->date(\%myconfig, $form->current_date(\%myconfig), 1);
  }
    if ($form->{project}) {
      $form->{period} .= "<br>".$locale->text('Project')." : $form->{project}";
    }
    if ($form->{sub}) {
      $form->{period} .= "<br>".$locale->text('Sub')." : $form->{sub}";
    }
  @column_index = qw(accno description debit credit);

  $column_header{accno} = qq|<th class=print><hr noshade size=2>|.$locale->text('Account').qq|<hr noshade size=2></th>|;
  $column_header{description} = qq|<th class=print><hr noshade size=2>|.$locale->text('Description').qq|<hr noshade size=2></th>|;
  #$column_header{count} = qq|<th class=print><hr noshade size=2>|.$locale->text('TR.NO.').qq|<hr noshade size=2></th>|;
  $column_header{debit} = qq|<th class=print><hr noshade size=2>|.$locale->text('Debit').qq|<hr noshade size=2></th>|;
  $column_header{credit} = qq|<th class=print><hr noshade size=2>|.$locale->text('Credit').qq|<hr noshade size=2></th>|;


  # reverse scan TB and set empty headers not to display
  $heading = 1;
  foreach $ref (reverse @{ $form->{TB} }) {
    $ref->{display} = 1;
    if ($ref->{charttype} eq "H") {
      $ref->{display} = 0 if ($heading);
      $heading = 1;
    } else {
      $heading = 0;
      unless ($form->{lastaccno}{$ref->{category}} ne "") {
	$form->{lastaccno}{$ref->{category}} = $ref->{accno};
      }
    }
    # subtotal sections
    $form->{subtotal}{$ref->{category}}{debit} += $ref->{debit};
    $form->{subtotal}{$ref->{category}}{credit} += $ref->{credit};
  }

  foreach $key (keys %{ $form->{lastaccno} }) {
    push @{ $form->{TB} }, { charttype => 'S',
                             accno => $form->{lastaccno}{$key},
			     debit => $form->{subtotal}{$key}{debit},
			     credit => $form->{subtotal}{$key}{credit},
			     display => 1 };
  }

  if ($form->{accounttype} eq 'gifi') {
    $column_header{accno} = qq|<th class=print>|.$locale->text('GIFI').qq|</th>|;
  }


  $form->header;
  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>
<center><h1 class=print>$form->{company}</h1></center>
<center><h1 class=print>$form->{title}</h1></center>

<table border=0 width=100% class=print>

<tr  bgcolor=336666 class=print>|;

  map { print "$column_header{$_}\n" } @column_index;

  print qq|
</tr>
|;

    #####################newadded
    $debtors=0;
    $creditors=0;
    $debit_list="<tr  class=print>";
     $credit_list="<tr class=print>";
 map { $debit_list.= "$column_header{$_}\n" } @column_index;
 map { $credit_list.= "$column_header{$_}\n" } @column_index;
     $debit_list.="</tr>";
     $credit_list.="</tr>";
	$debitalld=0;
	$creditallc=0;
   #####################newadded

  # sort the whole thing by account numbers and display
  foreach $ref (sort { $a->{accno} <=> $b->{accno} } @{ $form->{TB} }) {

   #####################newadded
	    if ($ref->{category} eq "D") {
	    	$debtors += $ref->{debit} - $ref->{credit};
		$debitalld +=$ref->{debit};
		$creditalld +=$ref->{credit};
	$ref->{debit} = $form->format_amount(\%myconfig, $ref->{debit}, 2, "0.00");

		if ($ref->{charttype} ne "H") {
			$column_data{accno} = "<td class=print><a href=$href>$ref->{accno}</a></td>";
			$column_data{description} = "<td class=print>$ref->{description}</td>";
			$column_data{debit} = "<td align=right class=print>$ref->{debit}</td>";
			$column_data{credit} = "<td align=right class=print>$ref->{credit}</td>";
			$i++; $i %= 2;
			$debit_list .="<tr class=print>";
      			map { $debit_list .= "$column_data{$_}\n" } @column_index;
			$debit_list .="</tr>";
		}
	    }else{
		if ($ref->{category} eq "C") {
		  if ($ref->{charttype} ne "H") {
			$creditors += $ref->{debit} -$ref->{credit};
		$debitallc +=$ref->{debit};
		$creditallc +=$ref->{credit};
			$column_data{accno} = "<td class=print><a href=$href>$ref->{accno}</a></td>";
			$column_data{description} = "<td class=print>$ref->{description}</td>";
			$column_data{debit} = "<td align=right class=print>$ref->{debit}</td>";
			$column_data{credit} = "<td align=right class=print>$ref->{credit}</td>";
			$i++; $i %= 2;
			$credit_list .="<tr class=print >";
     			map { $credit_list .= "$column_data{$_}\n" } @column_index;
			$credit_list .="</tr>";
		 }
	    	}else{
   #####################newadded


    $description = $form->escape($ref->{description});

    $href = qq|ca.pl?path=$form->{path}&action=list_transactions&accounttype=$form->{accounttype}&login=$form->{login}&sessionid=$form->{sessionid}&fromdate=$form->{fromdate}&todate=$form->{todate}&sort=transdate&l_subtotal=$form->{l_subtotal}|;
    if ($form->{accounttype} eq 'gifi') {
      $href .= "&gifi_accno=$ref->{accno}&gifi_description=$description";
      $na = $locale->text('N/A');
      map { $ref->{$_} = $na } qw(accno description) unless $ref->{accno};
    } else {
      $href .= "&accno=$ref->{accno}&description=$description";
    }

    $debit = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
    $credit = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

    if ($ref->{charttype} eq "H") {
      next unless ($form->{l_heading});

      $column_data{accno} = "<th class=print>&nbsp;</th>";
      $column_data{description} = "<th class=print>$ref->{description}</th>";
      $column_data{debit} = "<th class=print>&nbsp;</th>";
      $column_data{credit} = "<th class=print>&nbsp;</th>";
    }



    if ($ref->{charttype} eq "A") {


			$column_data{accno} = "<td class=print><a href=$href>$ref->{accno}</a></td>";
			$column_data{description} = "<td class=print>$ref->{description}</td>";
			$column_data{debit} = "<td align=right class=print>$debit</td>";
			$column_data{credit} = "<td align=right class=print>$credit</td>";


		$total_debit += $ref->{debit};
		$total_credit += $ref->{credit};

    }


    # subtotal
    if ($ref->{charttype} eq "S") {
      next unless ($form->{l_subtotal});

      map { $column_data{$_} = "<th class=print><hr noshade size=1>&nbsp;</th>" } @column_index;

      $debit = $form->format_amount(\%myconfig, $ref->{debit}, 2, "&nbsp;");
      $credit = $form->format_amount(\%myconfig, $ref->{credit}, 2, "&nbsp;");

      $column_data{debit} = "<th align=right class=print><hr noshade size=1>$debit</th>";
      $column_data{credit} = "<th align=right class=print><hr noshade size=1>$credit</th>";
    }


    if ($ref->{display}) {
      if ($ref->{charttype} eq "H") {
	print qq|<tr   class=print>\n|;
      }
      if ($ref->{charttype} eq "S") {
	print qq|<tr  class=print >\n|;
      }
      if ($ref->{charttype} eq "A") {
			$i++; $i %= 2;
			print qq|<tr  class=print>\n|;

      }

      map { print "$column_data{$_}\n" } @column_index;

      print qq|</tr>|;

    #####################newadded
     	   	}
 	   }
   #####################newadded

    }
  }


  $debtors1 = $form->format_amount(\%myconfig, $debtors, 2, "0.00");
  $creditors1 = $form->format_amount(\%myconfig, $creditors, 2, "0.00");

    #####################newadded
   if($debtors > 0){
  		$debtors1 = $form->format_amount(\%myconfig, $debtors, 2, "0.00");
		$textd ="<th align=right class=print>$debtors1</th>            <th align=right>0.00</th>";
	$total_debit += $debtors;
  }else{
  	$debtors *= -1;
 	$debtors1 = $form->format_amount(\%myconfig, $debtors, 2, "0.00");
  	$textd ="<th align=right class=print>0.00</th>            <th align=right>$debtors1</th>";
	$total_credit += $debtors;
  }

    if($creditors > 0){
	$total_debit += $creditors;
   	$creditors1 = $form->format_amount(\%myconfig, $creditors, 2, "0.00");
  	$textc ="<th align=right class=print>$creditors1</th>            <th align=right>0.00</th>";
  }else{
  	$creditors *= -1;
   	$creditors1 = $form->format_amount(\%myconfig, $creditors, 2, "0.00");
 	$textc ="<th align=right class=print>0.00</th>            <th align=right>$creditors1</th>";
	$total_credit += $creditors;
  }
  

  print qq|<tr  bgcolor=000000 class=print>
           <th  class=print>&nbsp;</th>
           <td align=left class=print>|.$locale->text('Debitors').qq|</td>
		$textd
	   </tr>

<p>
|;

  print qq|<tr  bgcolor=000000 class=print>
           <th class=print>&nbsp;</th>
           <td align=left class=print>|.$locale->text('Creditors').qq|</td>
		$textc
	   </tr>

<p>
|;
   #####################newadded
  $total_debit = $form->format_amount(\%myconfig, $total_debit, 2, "&nbsp;");
  $total_credit = $form->format_amount(\%myconfig, $total_credit, 2, "&nbsp;");


  print qq|<tr bgcolor=000000 class=print>
           <th class=print><hr noshade size=2>&nbsp;<hr noshade size=2></th>
           <th class=print><hr noshade size=2>&nbsp;<hr noshade size=2></th>
           <th align=right class=print><hr noshade size=2>$total_debit<hr noshade size=2></th>
           <th align=right class=print><hr noshade size=2>$total_credit<hr noshade size=2></th>
	   </tr>
	   </table>
<p>
 <!- PAGE BREAK ->
<table border=0 width=100%  RULES=GROUPS STYLE="page-break-before: always" class=print>
<tr class=print><th class=print  colspan=$colspan><h1>|;
print $locale->text('Debtors Summary')
.qq|</font></h1></th></tr>
$debit_list
<tr  bgcolor=000000>
|;
  $debitalld = $form->format_amount(\%myconfig, $debitalld, 2, "&nbsp;");
  $creditalld = $form->format_amount(\%myconfig, $creditalld, 2, "&nbsp;");
     map { $column_data{$_} = "<th class=print>&nbsp;</th>" } @column_index;
     $column_data{debit} = "<th align=right class=print><hr noshade size=1>$debitalld&nbsp;</th>";
      $column_data{credit} = "<th align=right class=print><hr noshade size=1>$creditalld&nbsp;</th>";

      map { print "$column_data{$_}\n" } @column_index;

print qq|
	   </tr>

<tr  bgcolor=000000 class=print>
           <th class=print>&nbsp;</th>
           <th class=print>Balance</th>
		$textd
	   </tr>

<p>


</table>
<br> <!- PAGE BREAK ->
<table border=0 width=100% RULES=GROUPS STYLE="page-break-before: always" class=print>
<tr class=print><th  colspan=$colspan><font color=ffffff class=print><h1>|;
print $locale->text('Creditors Summary')
.qq|</font></h1></th></tr>
$credit_list

<tr  bgcolor=000000 class=print>
|;
  $debitallc = $form->format_amount(\%myconfig, $debitallc, 2, "&nbsp;");
  $creditallc = $form->format_amount(\%myconfig, $creditallc, 2, "&nbsp;");
      map { $column_data{$_} = "<th class=print>&nbsp;</th>" } @column_index;
    $column_data{debit} = "<th align=right class=print><hr noshade size=1>$debitallc&nbsp;</th>";
      $column_data{credit} = "<th align=right class=print><hr noshade size=1>$creditallc&nbsp;</th>";

      map { print "$column_data{$_}\n" } @column_index;

print qq|
	   </tr>

<tr  bgcolor=000000 class=print>
           <th class=print>&nbsp;</th>
           <th class=print>Balance</th>
		$textc
	   </tr>

<p>

</table><br>


</body>
</html>
|;

}

sub generate_ar_aging {

  # split customer
  ($customer, $form->{customer_id}) = split(/--/, $form->{customer});

  $form->{ct} = "customer";
  $form->{arap} = "ar";

  $form->{title} = $locale->text('Accounts Receivables Aging Report');

  $form->{callback} = qq|$form->{script}?path=$form->{path}&action=generate_ar_aging&login=$form->{login}&sessionid=$form->{sessionid}&todate=$form->{todate}&customer=|.$form->escape($form->{customer});
  
  &aging;
  
}
sub generate_ar_aging_print {
$form->{print}="true";
&generate_ar_aging;
}
sub generate_ap_aging_print {
$form->{print}="true";
&generate_ap_aging;
}

sub generate_ap_aging {
  
  # split vendor
  ($vendor, $form->{vendor_id}) = split(/--/, $form->{vendor});

  $form->{ct} = "vendor";
  $form->{arap} = "ap";
  
  $form->{title} = $locale->text('Accounts Payables Aging Report');

  $form->{callback} = qq|$form->{script}?path=$form->{path}&action=generate_ap_aging&login=$form->{login}&sessionid=$form->{sessionid}&todate=$form->{todate}&vendor=|.$form->escape($form->{vendor});

  &aging;
  
}


sub aging {
  map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr fy));
 if(!$form->{print}){
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
    $lastline=$locale->text('Click on table headers to sort table')."<br>".$locale->text('Click on invoice number to edit transaction');
     $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
 }else{
    $line = "<hr size=2 noshade>";
    $fontsize="size=-1";
   $listprint="class=print";
   $listheading="class=print";
    $listtop="class=print";
    $listrow="class=print";
    $listsubtotal="class=print";
 }

 
  RP->aging(\%myconfig, \%$form);

  $form->header;

  $column_header{print} = qq|<th $listprint>$line|.$locale->text('').qq|$line</th>|;
  $column_header{ct} = qq|<th $listprint>$line|.$locale->text(ucfirst $form->{ct}).qq|$line</th>|;
  $column_header{ordnumber} = qq|<th $listprint>$line|.$locale->text('Order Number').qq|$line</th>|;
  $column_header{invnumber} = qq|<th $listprint>$line|.$locale->text('Invoice Number').qq|$line</th>|;
  $column_header{transdate} = qq|<th $listprint>$line|.$locale->text('Invoice Date').qq|$line</th>|;
  $column_header{duedate} = qq|<th $listprint>$line|.$locale->text('Due Date').qq|$line</th>|;
  $column_header{c0} = qq|<th $listprint>$line 0 - 30$line</th>|;
  $column_header{c30} = qq|<th $listprint>$line 31 - 60$line</th>|;
  $column_header{c60} = qq|<th $listprint>$line 61 - 90$line</th>|;
  $column_header{c90} = qq|<th $listprint>$line 90+$line</th>|;
  $column_header{total} = qq|<th $listprint>$line |.$locale->text('Total').qq|$line</th>|;
  
  if($form->{summary}){
  @column_index = (qw( ct  c0 c30 c60 c90 total print)) ;
  
  }else{
  @column_index = (qw( ct invnumber ordnumber transdate duedate c0 c30 c60 c90 total print)) ;
  }
  
      @column_index = grep !/print/, @column_index if $form->{print};
      @column_index = grep !/print/, @column_index if $form->{ct} eq "vendor";

      
  if ($form->{arap} eq 'ar') {
    if ($form->{customer_id}) {
      $option .= "\n<br>" if $option;
      $option .= $customer;
  #    shift @column_index;
    }
    $form->{vc} = "customer";
  }
  if ($form->{arap} eq 'ap') {
    if ($form->{vendor_id}) {
      $option .= "\n<br>" if $option;
      $option .= $vendor;
   #   shift @column_index;
    }
    $form->{vc} = "vendor";
  }
  
  $todate = $locale->date(\%myconfig, $form->{todate}, 1);
  $option .= "\n<br>" if $option;
  $option .= $locale->text('for Period')." ".$locale->text('To')." $todate";

  $colspan = $#column_index + 1;

  print qq|
    <script>
<!--

function set(n) 
{
               temp = document.myform.elements.length  ;
                 
               for (i=0; i < temp; i++)
	{   document.myform.elements[i].checked=n;
	   }
} 

function Invers(){

temp = document.myform.elements.length ;
                 
for (i=0; i < temp; i++){

          if(document.myform.elements[i].checked == 1){document.myform.elements[i].checked = 0;}
                else {document.myform.elements[i].checked = 1}
               
              }

}
// -->
</script>

<body bgcolor=ffffff>
<p>F/Y : $form->{fy}</p>
<form method=post action=rp.pl name=myform>
<H1  $listprint align=center >$form->{company}<br>$form->{title}  </h1>

<table border=0 width=100%>

<tr><td colspan=$colspan $listprint>$option</td></tr>

<tr $listheading >
|;

  map { print "$column_header{$_}\n" } @column_index;
  
  print qq|
</tr>|;


  $ctid = 0;
  $subtotal = 0;
  $j=1;
  foreach $ref (@{ $form->{AG} }) {

    if ($ctid != $ref->{id}) {

      if ($subtotal) {
	$c0subtotal = $form->format_amount(\%myconfig, $c0subtotal, 2, "&nbsp");
	$c30subtotal = $form->format_amount(\%myconfig, $c30subtotal, 2, "&nbsp");
	$c60subtotal = $form->format_amount(\%myconfig, $c60subtotal, 2, "&nbsp");
	$c90subtotal = $form->format_amount(\%myconfig, $c90subtotal, 2, "&nbsp");
	$subtotal2 = $form->format_amount(\%myconfig, $subtotal2, 2, "&nbsp");
      }
      
  
       $column_data{print} = qq|<th $listprint>$line&nbsp;$line</th>|;
     $column_data{ct} = qq|<th $listprint>$line&nbsp;$line</th>|;
      $column_data{invnumber} = qq|<th $listprint>$line&nbsp;$line</th>|;
      $column_data{transdate} = qq|<th $listprint>$line&nbsp;$line</th>|;
      $column_data{duedate} = qq|<th $listprint>$line&nbsp;$line</th>|;
      $column_data{ordnumber} = qq|<th $listprint>$line&nbsp;$line</th>|;
      $column_data{c0} = qq|<th align=right $listprint>$line$c0subtotal&nbsp$line</font></th>|;
      $column_data{c30} = qq|<th align=right $listprint>$line$c30subtotal&nbsp$line</font></th>|;
      $column_data{c60} = qq|<th align=right $listprint>$line$c60subtotal&nbsp$line</font></th>|;
      $column_data{c90} = qq|<th align=right $listprint>$line$c90subtotal&nbsp$line</font></th>|;
      $column_data{total} = qq|<th align=right $listprint>$line$subtotal2&nbsp$line</font></th>|;
     
      if ($subtotal && !$form->{summary}) {
	      $r+=2;
      
	# print subtotals
	print qq|<tr $listsubtotal >|;

	map { print "$column_data{$_}\n" } @column_index;

	print qq|
      </tr>|;
      }
   
      $subtotal = 1;

      $c0subtotal = 0;
      $c30subtotal = 0;
      $c60subtotal = 0;
      $c90subtotal = 0;
      $subtotal2=0;
      
      $column_data{ct} = qq|<td $listprint>$ref->{name} <input type=hidden name="|.$form->{vc}.qq|_id_$j" value=$ref->{id}></td>|;
     $column_data{print} = qq|<td $listprint><input name=print_$j type=checkbox class=radio value=$j ></td>|;
     $j++;
    } else {
       $column_data{ct} = qq|<td $listprint>&nbsp;</td>|;
       $column_data{print} = qq|<td $listprint>&nbsp;</td>|;
    }

    $total = $ref->{c0} +$ref->{c30} +$ref->{c60} +$ref->{c90} ;
    $c0subtotal += $ref->{c0};
    $c30subtotal += $ref->{c30};
    $c60subtotal += $ref->{c60};
    $c90subtotal += $ref->{c90};
    $subtotal2 += $total;
    
    $c0total += $ref->{c0};
    $c30total += $ref->{c30};
    $c60total += $ref->{c60};
    $c90total += $ref->{c90};
    $ftotal += $total;

    $ref->{c0} = $form->format_amount(\%myconfig, $ref->{c0}, 2, "&nbsp;");
    $ref->{c30} = $form->format_amount(\%myconfig, $ref->{c30}, 2, "&nbsp;");
    $ref->{c60} = $form->format_amount(\%myconfig, $ref->{c60}, 2, "&nbsp;");
    $ref->{c90} = $form->format_amount(\%myconfig, $ref->{c90}, 2, "&nbsp;");
    $total = $form->format_amount(\%myconfig, $total, 2, "&nbsp;");
    
    $href = qq|$ref->{module}.pl?path=$form->{path}&action=edit&id=$ref->{transid}&login=$form->{login}&sessionid=$form->{sessionid}&callback=|.$form->escape($form->{callback});
    
    $column_data{invnumber} = qq|<td $listprint><a href=$href>$ref->{invnumber}</a></td>|;
    $column_data{ordnumber} = qq|<td $listprint>$ref->{ordnumber}&nbsp;</td>|;
    $column_data{transdate} = qq|<td $listprint>$ref->{transdate}</td>|;
    $column_data{duedate} = qq|<td $listprint>$ref->{duedate}&nbsp;</td>|;
    $column_data{c0} = qq|<td align=right $listprint>$ref->{c0}</td>|;
    $column_data{c30} = qq|<td align=right $listprint>$ref->{c30}</td>|;
    $column_data{c60} = qq|<td align=right $listprint>$ref->{c60}</td>|;
    $column_data{c90} = qq|<td align=right $listprint>$ref->{c90}</td>|;
    $column_data{total} = qq|<td align=right $listprint>$total</td>|;
    
    
    $i++; $i %= 2;$r++;
    print qq|<tr $listrow$i $mouseaction[$i] >|;

    map { print "$column_data{$_}\n" } @column_index;

    print qq|
</tr>|;
 
    $ctid = $ref->{id};

    
    	
	#page break

if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){

$pagenum++;
    print "<tr $listrow$i $mouseaction[$i] >";
    $c0total1 = $form->format_amount(\%myconfig, $c0total, 2, "&nbsp;");
    $c30total1 = $form->format_amount(\%myconfig, $c30total, 2, "&nbsp;");
    $c60total1 = $form->format_amount(\%myconfig, $c60total, 2, "&nbsp;");
    $c90total1 = $form->format_amount(\%myconfig, $c90total, 2, "&nbsp;");
    $ftotal1 = $form->format_amount(\%myconfig, $ftotal, 2, "&nbsp;");

	
	  map { $column_data{$_} = "<td $listprint >$line&nbsp;</td>" } @column_index;
     $column_data{ct} = "<td $listprint >$line SubTotal C/F for Page $pagenum</td>";
    $column_data{c0} = "<td  $listprint align=right>$line $c0total1</td>";
    $column_data{c30} = "<td  $listprint align=right>$line $c30total1</td>";
    $column_data{c60} = "<td  $listprint align=right>$line $c60total1</td>";
    $column_data{c90} = "<td  $listprint align=right>$line $c90total1</td>";
    $column_data{total} = "<td  $listprint align=right>$line $ftotal1</td>";
   # $column_data{qty} = "<td  $listprint align=right>$line $pagetotaldebit</td>";
    #$column_data{subtotal1} = "<td  $listprint align=right>$line".$form->format_amount(\%myconfig, $pagetotalcredit, 2, "&nbsp;") . "</td>";
     map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
</table>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}  </h1>
<table  $listprint border=0 width=100%>
<tr><td colspan=$colspan $listprint>$option</td></tr>

<tr $listheading >|;
map { print  "$column_header{$_}\n" } @column_index;




print qq|
</tr><tr>
|;


 	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
     $column_data{ct} = "<td $listprint > SubTotal B/F for Page $pagenum</td>";
    $column_data{c0} = "<td  $listprint align=right> $c0total1</td>";
    $column_data{c30} = "<td  $listprint align=right> $c30total1</td>";
    $column_data{c60} = "<td  $listprint align=right> $c60total1</td>";
    $column_data{c90} = "<td  $listprint align=right> $c90total1</td>";
    $column_data{total} = "<td  $listprint align=right> $ftotal1</td>";
    map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;

}


  }
  if(!$form->{summary}){
  # print subtotals
  $c0subtotal = $form->format_amount(\%myconfig, $c0subtotal, 2, "&nbsp;");
  $c30subtotal = $form->format_amount(\%myconfig, $c30subtotal, 2, "&nbsp;");
  $c60subtotal = $form->format_amount(\%myconfig, $c60subtotal, 2, "&nbsp;");
  $c90subtotal = $form->format_amount(\%myconfig, $c90subtotal, 2, "&nbsp;");
   $subtotal2 = $form->format_amount(\%myconfig, $subtotal2, 2, "&nbsp;");
 
  print qq|<tr $listsubtotal>|;

  map { $column_data{$_} = qq|<th>&nbsp;</th>| } @column_index;

  $column_data{c0} = qq|<th align=right $listprint>$line$c0subtotal &nbsp;$line</font></th>|;
  $column_data{c30} = qq|<th align=right $listprint>$line$c30subtotal &nbsp;$line</font></th>|;
  $column_data{c60} = qq|<th align=right $listprint>$line$c60subtotal &nbsp;$line</font></th>|;
  $column_data{c90} = qq|<th align=right $listprint>$line$c90subtotal &nbsp;$line</font></th>|;
  $column_data{total} = qq|<th align=right $listprint>$line$subttotal &nbsp;$line</font></th>|;

  map { print "$column_data{$_}\n" } @column_index;
 
  
  print qq|</tr>|;
  }
  print qq|<tr $listtotal >|;
 map { $column_data{$_} = qq|<th>&nbsp;</th>| } @column_index;

  $c0total = $form->format_amount(\%myconfig, $c0total, 2, "&nbsp;");
  $c30total = $form->format_amount(\%myconfig, $c30total, 2, "&nbsp;");
  $c60total = $form->format_amount(\%myconfig, $c60total, 2, "&nbsp;");
  $c90total = $form->format_amount(\%myconfig, $c90total, 2, "&nbsp;");
  $ftotal = $form->format_amount(\%myconfig, $ftotal, 2, "&nbsp;");
  
  $column_data{c0} = qq|<th align=right $listprint>$line$c0total &nbsp;$line</font></th>|;
  $column_data{c30} = qq|<th align=right $listprint>$line$c30total &nbsp;$line</font></th>|;
  $column_data{c60} = qq|<th align=right $listprint>$line$c60total &nbsp;$line</font></th>|;
  $column_data{c90} = qq|<th align=right $listprint>$line$c90total &nbsp;$line</font></th>|;
  $column_data{total} = qq|<th align=right $listprint>$line$ftotal &nbsp;$line</font></th>|;

 
  map { print "$column_data{$_}\n" } @column_index;

  
  print qq|
</tr>

</table>
|;
  if(!$form->{print} && $form->{ct} eq "customer"  ){
  $form->{l_post}="checked" if $form->{l_post};
	  print qq| 
	    <br><br><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=button onclick=Invers() type=button value="|.$locale->text('Select All').qq|"> 
	    	    <input class=submit type=submit name=action value="|.$locale->text('Print').qq|"><br>
	    	    <input class=submit type=submit name=action value="|.$locale->text('Statement').qq|">
<select name=l_post><option value=0> <option value=Y>Post Dated</select>
<select name=stype><option value=1> Short<option value=0>Detail</select>
	  	<input type=hidden name=sessionid value=$form->{sessionid}>
		<input type=hidden name=printcount value=$j>

	  |;
  }
print qq|
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<input type=hidden name=todate value=$form->{todate}>
<input type=hidden name=locationcode value=$form->{locationcode}>
<input type=hidden name=salesperson value=$form->{salesperson}>
<input type=hidden name=customercode value=$form->{customercode}>
<input type=hidden name=arap value=$form->{arap}>
<input type=hidden name=ct value=$form->{ct}>
</form>
</body>
</html>
|;

}

sub statement{
use SL::statement;
require "$form->{path}/is.pl";
require "format/statement.pl";
	 $form->header;
 print qq|<body bgcolor="#ffffff">|;
 for $x (1 .. $form->{printcount}) {
 $form->{"pid_$x"} =$form->{"id_$x"};

 }
 for $x (1 .. $form->{printcount}) {
  #$form->{title} = $locale->text('Edit Customer Invoice');
 # $form->{printtitle}="I N V O I C E";
 
 $form->{id} =$form->{"pid_$x"};
 # $form->save_query(\%$form,$myconfig->{dbname},$form->{"id_$x"});

  $form->{currentrow}=0;


 $form->{page}=0;
 #$i=0;
$form->{paidaccounts}=0;
$form->{rowcount}=0;

$form->{invtotal}=0;
$form->{invsubtotal}=0;


	 if($form->{"print_$x"}){
$form->{balance}=0;
	  #&invoice_links;
	 # &prepare_invoice2; 
			$form->{customer_id}=$form->{"customer_id_$x"};
			undef @{ $form->{report} };
  statement->statement(\%myconfig, \%$form);
 
	  ####print invoice
			  map { $form->{$_} = $myconfig{$_} } (qw(company address tel fax businessnumber nativecurr fy email));
			  $form->{address} =~ s/\\n/<br>/g;
			
			 # $form->{type} = "invoice";
			 # $form->{label} = $locale->text('Invoice');
			  $form->{vc} = "customer";
			  $form->{printpage}=1;
					  $form->{pagetotal}=0;
	  
			   $y=0;
			  $form->{currentrow}=0;
			  $form->{page}=1;
		  IS->customer_details(\%myconfig, \%$form);
			
			  &print_form_header;
#			  $form->dberror(@$form->{AG}->{invnumber});
#			  for $z (1 .. $form->{rowcount}-1) {
  foreach $ref (@{ $form->{report} }) {
				  $form->{currentrow}++;
				    $y++;
				    if($form->{printinvoicerowcount} > $y){
					    &print_form_row;
				    }else{
					    &print_form_row;
					     &print_page_footer;
					    print qq| <p style="page-break-after: always">&nbsp;</p>|;
					    $form->{page}++;
					    &print_form_header;
					     &print_page_header;
					    $y=0;
				    
				   }
				  

			  }
			  		  statement->postdated(\%myconfig, \%$form);

			  &print_form_footer;
			 print qq| </table><p style="page-break-after: always">&nbsp;</p>|;
	###print all end
	 }


 }
  print qq|    </body></html>|;

}



sub print {
require "$form->{path}/is.pl";
require "format/print_aging.pl";
	 $form->header;
 print qq|<body bgcolor="#ffffff">|;
 for $x (1 .. $form->{printcount}) {
 $form->{"pid_$x"} =$form->{"id_$x"};

 }
 for $x (1 .. $form->{printcount}) {
  #$form->{title} = $locale->text('Edit Customer Invoice');
 # $form->{printtitle}="I N V O I C E";
 
 $form->{id} =$form->{"pid_$x"};
 # $form->save_query(\%$form,$myconfig->{dbname},$form->{"id_$x"});

  $form->{currentrow}=0;


 $form->{page}=0;
 #$i=0;
$form->{paidaccounts}=0;
$form->{rowcount}=0;

$form->{invtotal}=0;
$form->{invsubtotal}=0;


	 if($form->{"print_$x"}){

	  #&invoice_links;
	 # &prepare_invoice2; 
			$form->{customer_id}=$form->{"customer_id_$x"};
			undef @{ $form->{AG} };
  RP->aging(\%myconfig, \%$form);
 
	  ####print invoice
			  map { $form->{$_} = $myconfig{$_} } (qw(company address tel fax businessnumber nativecurr fy email));
			  $form->{address} =~ s/\\n/<br>/g;
			
			 # $form->{type} = "invoice";
			 # $form->{label} = $locale->text('Invoice');
			  $form->{vc} = "customer";
			  $form->{printpage}=1;
					  $form->{pagetotal}=0;
	  
			   $y=0;
			  $form->{currentrow}=0;
			  $form->{page}=1;
		  IS->customer_details(\%myconfig, \%$form);
			
			  &print_form_header;
#			  $form->dberror(@$form->{AG}->{invnumber});
#			  for $z (1 .. $form->{rowcount}-1) {
  foreach $ref (@{ $form->{AG} }) {
				  $form->{currentrow}++;
				    $y++;
				    if($form->{printinvoicerowcount} > $y){
					    &print_form_row;
				    }else{
					    &print_form_row;
					     &print_page_footer;
					    print qq| <p style="page-break-after: always">&nbsp;</p>|;
					    $form->{page}++;
					    &print_form_header;
					     &print_page_header;
					    $y=0;
				    
				   }
				  

			  }
			  
			  &print_form_footer;
			 print qq| </table><p style="page-break-after: always">&nbsp;</p>|;
	###print all end
	 }


 }
  print qq|    </body></html>|;

}

sub generate_tax_report {

  RP->tax_report(\%myconfig, \%$form);

  $descvar = "$form->{accno}_description";
  $description = $form->escape($form->{$descvar});
  
  # construct href
  $href = "$form->{script}?path=$form->{path}&action=generate_tax_report&login=$form->{login}&sessionid=$form->{sessionid}&fromdate=$form->{fromdate}&todate=$form->{todate}&db=$form->{db}&accno=$form->{accno}&$descvar=$description";

  # construct callback
  $callback = $href;

 
  @columns = $form->sort_columns(qw(id transdate invnumber name netamount tax amount));

  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to href and callback
      $callback .= "&l_$item=Y";
      $href .= "&l_$item=Y";
    }
  }

  if ($form->{l_subtotal} eq 'Y') {
    $callback .= "&l_subtotal=Y";
    $href .= "&l_subtotal=Y";
  }
  
  
  $colspan = $#column_index + 1;
  
  # if there are any dates
  if ($form->{fromdate} || $form->{todate}) {
    if ($form->{fromdate}) {
      $fromdate = $locale->date(\%myconfig, $form->{fromdate}, 1);
    }
    if ($form->{todate}) {
      $todate = $locale->date(\%myconfig, $form->{todate}, 1);
    }
    
    $form->{period} = "$fromdate - $todate";
  } else {
    $form->{period} = $locale->date(\%myconfig, $form->current_date(\%myconfig), 1);
  }

  $form->{title} = $locale->text('GIFI')." - " if ($form->{accno} =~ /^gifi_/);
  $form->{title} .= qq|$form->{"$form->{accno}_description"} |;
  if ($form->{db} eq 'ar') {
    $form->{title} .= $locale->text('collected on sales');
    $name = $locale->text('Customer');
    $invoice = 'is.pl';
    $arap = 'ar.pl';
  }
  if ($form->{db} eq 'ap') {
    $form->{title} .= $locale->text('paid on purchases');
    $name = $locale->text('Vendor');
    $invoice = 'ir.pl';
    $arap = 'ap.pl';
  }

 
  $column_header{id} = qq|<th><a class=listheading href=$href&sort=id>|.$locale->text('ID').qq|</font></th>|;
  $column_header{invnumber} = qq|<th><a class=listheading href=$href&sort=invnumber>|.$locale->text('Invoice').qq|</font></th>|;
  $column_header{transdate} = qq|<th><a class=listheading href=$href&sort=transdate>|.$locale->text('Date').qq|</font></th>|;
  $column_header{netamount} = qq|<th>|.$locale->text('Amount').qq|</th>|;
  $column_header{tax} = qq|<th>|.$locale->text('Tax').qq|</th>|;
  $column_header{amount} = qq|<th>|.$locale->text('Total').qq|</th>|;
  
  $column_header{name} = qq|<th><a class=listheading href=$href&sort=name>$name</font></th>|;

  
  $form->header;

  print qq|
<body bgcolor=ffffff>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$form->{period}</td></tr>

<tr class=listheading bgcolor=336666>
|;

  map { print "$column_header{$_}\n" } @column_index;
  
  print qq|
</tr>|;

  # add sort and escape callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");
    
  if (@{ $form->{TR} }) {
    $sameitem = $form->{TR}->[0]->{$form->{sort}};
  }

  foreach $ref (@{ $form->{TR} }) {

    $module = ($ref->{invoice}) ? $invoice : $arap;
    
    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&tax_subtotal;
	$sameitem = $ref->{$form->{sort}};
      }
    }

    $totalnetamount += $ref->{netamount};
    $totaltax += $ref->{tax};
    $ref->{amount} = $ref->{netamount} + $ref->{tax};

    $subtotalnetamount += $ref->{netamount};
    $subtotaltax += $ref->{tax};
    
    map { $ref->{$_} = $form->format_amount(\%myconfig, $ref->{$_}, 2, "&nbsp;"); } qw(netamount tax amount);
    
    $column_data{id} = qq|<td>$ref->{id}</td>|;
    $column_data{invnumber} = qq|<td><a href=$module?path=$form->{path}&action=edit&id=$ref->{id}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{invnumber}</a></td>|;
    $column_data{transdate} = qq|<td>$ref->{transdate}</td>|;
    $column_data{name} = qq|<td>$ref->{name}&nbsp;</td>|;
    
    map { $column_data{$_} = qq|<td align=right>$ref->{$_}</td>| } qw(netamount tax amount);

    $i++; $i %= 2;
    print qq|<tr class=listrow$i onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow$i';\" >|;

    map { print "$column_data{$_}\n" } @column_index;

    print qq|
</tr>|;
 
  }
 
  if ($form->{l_subtotal} eq 'Y') {
    &tax_subtotal;
  }

  
  map { $column_data{$_} = qq|<th>&nbsp;</th>| } @column_index;
  
  print qq|</tr>
  
<tr class=listtotal bgcolor=000000>|;

  $total = $form->format_amount(\%myconfig, $totalnetamount + $totaltax, 2, "&nbsp;");
  $totalnetamount = $form->format_amount(\%myconfig, $totalnetamount, 2, "&nbsp;");
  $totaltax = $form->format_amount(\%myconfig, $totaltax, 2, "&nbsp;");
  
  $column_data{netamount} = qq|<th align=right>$totalnetamount</font></th>|;
  $column_data{tax} = qq|<th align=right>$totaltax</font></th>|;
  $column_data{amount} = qq|<th align=right>$total</font></th>|;
 
  map { print "$column_data{$_}\n" } @column_index;
 
    
  print qq|
  </tr>

</table>

</body>
</html>
|;

}


sub tax_subtotal {

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;

  $subtotalnetamount = $form->format_amount(\%myconfig, $subtotalnetamount, 2, "&nbsp;");
  $subtotaltax = $form->format_amount(\%myconfig, $subtotaltax, 2, "&nbsp;");
  $subtotal = $form->format_amount(\%myconfig, $subtotalnetamount + $subtotaltax, 2, "&nbsp;");
  
  $column_data{netamount} = "<th align=right>$subtotalnetamount</font></th>";
  $column_data{tax} = "<th align=right>$subtotaltax</font></th>";
  $column_data{amount} = "<th align=right>$subtotal</font></th>";

  $subtotalnetamount = 0;
  $subtotaltax = 0;
  
  print "<tr class=listsubtotal bgcolor=333366>";
  map { print "\n$column_data{$_}" } @column_index;

  print qq|
  </tr>
|;
  
}

