/*-------------------------------------------------------------------------
 *
 * assert.c
 *	  Assert code.
 *
 * Portions Copyright (c) 1996-2002, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *	  $Header: /cvsroot/pgsql/src/backend/utils/error/assert.c,v 1.23 2002/09/04 20:31:30 momjian Exp $
 *
 * NOTE
 *	  This should eventually work with elog()
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include <unistd.h>

#ifdef USE_REPLICATION
#include "replicate.h"
#endif /* USE_REPLICATION */

/*
 * ExceptionalCondition - Handles the failure of an Assert()
 */
int
ExceptionalCondition(char *conditionName,
					 char *errorType,
					 char *fileName,
					 int lineNumber)
{
	if (!PointerIsValid(conditionName)
		|| !PointerIsValid(fileName)
		|| !PointerIsValid(errorType))
		fprintf(stderr, "TRAP: ExceptionalCondition: bad arguments\n");
	else
	{
		fprintf(stderr, "TRAP: %s(\"%s\", File: \"%s\", Line: %d)\n",
				errorType, conditionName,
				fileName, lineNumber);
	}

#ifdef USE_REPLICATION
	if ((PGR_Check_Lock.dest == TO_REPLICATION_SERVER ) &&
		(PGR_Need_Notice == true))
	{
		PGR_Notice_Transaction_Query_Aborted();
	}
	if (PGR_Copy_Data_Need_Replicate)
	{
		PGR_Set_Copy_Data(PGRCopyData,NULL,0,1);
	}
#endif /* USE_REPLICATION */

#ifdef SLEEP_ON_ASSERT
	sleep(1000000);
#endif

	abort();

	return 0;
}
