/*-------------------------------------------------------------------------
 *
 * probe.h
 *	  Primary include file for PGCadmin server/client .c files
 *
 * This should be the first file included by probeing modules.
 *
 *-------------------------------------------------------------------------
 */
#ifndef PGC_ADMIN_H
#define	PGC_ADMIN_H 1

/*
#ifndef _SYS_TYPES_H
#include <sys/types.h>
#endif
#ifndef _INTTYPES_H
#include <inttypes.h>
#endif
#ifndef _NETINET_IN_H
#include <netinet/in.h>
#endif

#include "c.h"
#include "pg_config.h"
*/
#include <string.h>
#include <unistd.h>
#include <openssl/bio.h>
#include <openssl/err.h>
#include <openssl/rand.h>
#include <openssl/ssl.h>
#include <openssl/x509v3.h>
#include <pthread.h>

#include "miscadmin.h"
#include "nodes/nodes.h"

#include "libpq-fe.h"
#include "libpq/libpq-fs.h"
#include "libpq-int.h"
#include "fe-auth.h"
#include "access/xact.h"

#include "replicate.h"
#include "libpgc/libpgc.h"
#include "pglb/pglb.h"
#include "pgrp/pgreplicate.h"

/* template file */
#define PGC_PGLB_TEMP_FILE	"pgc_pglb.temp"
#define PGC_PGRP_TEMP_FILE	"pgc_pgrp.temp"
#define PGC_DB_TEMP_FILE	"pgc_db.temp"

/* configuration file */
#define PGC_SERVER_CONF_FILE	"server.conf"
#define PGC_ADMIN_CONF_FILE		"pgc_admin.conf"
#define PGC_PROBE_CONF_FILE		"pgc_probe.conf"
#define POSTGRESQL_CONF_FILE	"postgresql.conf"
#define PG_HBA_CONF_FILE		"pg_hba.conf"

/* pid file */
#define PGC_ADMIN_PID_FILE	"pgc_admin.pid"
#define PGC_PROBE_PID_FILE	"pgc_probe.pid"
#define CLUSTER_PID_FILE	"postmaster.pid"

/* data tags in configuration file */
#define PHYSICAL_SERVER_INFO_TAG	"Physical_Server_Info"
#define PGC_ADMIN_SERVER_INFO_TAG	"Admin_Server_Info"
#define PROBE_SERVER_INFO_TAG		"Probe_Server_Info"
#define	CONF_DIR_TAG				"Conf_Dir"
#define	SSL_PATH_TAG				"SSL_Path"
#define BIN_DIR_TAG					"Bin_Dir"
#define	SERVER_ID_TAG				"Server_ID"
#define USER_NAME_TAG				"User_Name"
#define	HOST_KEY_TAG				"Host_Key"
#define PUBLICK_KEY_TAG				"Pub_Key"
#define CERT_FILE_TAG				"Cert_File"
#define NOT_REPLICATE_INFO_TAG		"Not_Replicate_Info"

#define IP_ADDR_LENGTH				(32)
#define WATCHDOG_INTERVAL			(10)
#define MAX_EXEC_RETRY				(20)

/* default data of each server */
#define DEFAULT_PORT_OF_ADMIN	(10000)
#define DEFAULT_PORT_OF_PROBE	(9000)
#define DEFAULT_WORK_DIR_OF_ADMIN	"/usr/local/pgsql/admin"
#define DEFAULT_WORK_DIR_OF_PROBE	"/usr/local/pgsql/probe"
#define DEFAULT_BIN_DIR	"/usr/local/pgsql/bin"
#define DEFAULT_SSL_BIN_DIR	"/usr/bin"


/* Server Type */
#define SERVER_TYPE_ADMIN			(0x0001)
#define SERVER_TYPE_PROBE			(0x0002)
#define SERVER_TYPE_PGLB			(0x0004)
#define SERVER_TYPE_CLUSTER			(0x0008)
#define SERVER_TYPE_PGRP			(0x0010)
#define SERVER_TYPE_SYSTEM			(0x0020)

#define MAX_ADMIN_SERVER	(2)
#define MAX_PROBE_SERVER	(32)
#define MAX_PGLB_SERVER		(32)
#define MAX_PGRP_SERVER		(32)

/* Packet Number*/
/* startup notice */
#define INIT_NOTICE_PKT		( 1)	/* admin -> probe (startup notice) */
#define INIT_OK_PKT		( 2)	/* admin <- probe (answer) */
#define INIT_INFO_REQ_PKT	( 3)	/* admin <- probe (info request) */
/* notice server information */
#define INFO_NOTICE_PKT		(11)	/* admin -> probe (notice setup information) */
#define INFO_ANS_PKT		(12)	/* admin <- probe (answer) */
/* get status */
#define GET_STS_REQ_PKT		(21)	/* admin -> probe (request status) */
#define GET_STS_ANS_PKT		(22)	/* admin <- probe (send status) */
/* set status */
#define SET_STS_REQ_PKT		(31)	/* admin -> probe (set status) */
#define SET_STS_ANS_PKT		(32)	/* admin <- probe (send status) */
/* recovery start */
#define RECOVERY_REQ_PKT	(101)	/* admin -> probe (request recovery start) */
#define RECOVERY_ANS_PKT	(102)	/* admin <- probe (answer) */
#define USER_RECOVERY_REQ_PKT	(201)	/* user -> admin (request recovery start) */
#define USER_RECOVERY_ANS_PKT	(202)	/* user <- admin (answer) */
/* start */
#define START_REQ_PKT		(111)	/* admin -> probe (request start) */
#define START_ANS_PKT		(112)	/* admin <- probe (answer) */
#define USER_START_REQ_PKT	(211)	/* user  -> admin (request start) */
#define USER_START_ANS_PKT	(212)	/* user  <- admin (answer) */
/* stop */
#define STOP_REQ_PKT		(121)	/* admin -> probe (request stop) */
#define STOP_ANS_PKT		(122)	/* admin <- probe (answer) */
#define USER_STOP_REQ_PKT	(221)	/* user  -> admin (request stop) */
#define USER_STOP_ANS_PKT	(222)	/* user  <- admin (answer) */
/* status */
#define STATUS_REQ_PKT		(131)	/* admin -> probe (request status) */
#define STATUS_ANS_PKT		(132)	/* admin <- probe (answer) */
#define USER_STATUS_REQ_PKT	(231)	/* user  -> admin (request status) */
#define USER_STATUS_ANS_PKT	(232)	/* user  <- admin (answer) */

/* ssl cert files */
#define CIPHER_LIST "ALL:!ADH:!LOW:!EXP:!MD5:@STRENGTH"
#define CAFILE "rootcert.pem"
#define CADIR NULL
#define ADMIN_CNF_FILE	"admin.cnf"
#define PROBE_CNF_FILE	"probe.cnf"
#define DH512_CERTFILE	"dh512.pem"
#define DH1024_CERTFILE	"dh1024.pem"
#define SERVER_CERTFILE	"server.pem"
#define CLIENT_CERTFILE	"client.pem"
#define USER_DSA_PUB_KEY	"id_dsa.pub"
#define USER_RSA_PUB_KEY	"id_rsa.pub"
#define HOST_DSA_PUB_KEY	"ssh_host_dsa_key.pub"
#define HOST_RSA_PUB_KEY	"ssh_host_rsa_key.pub"
#define AUTHORIZED_KEYS_FILE	"authorized_keys"
#define KNOWN_HOSTS_FILE	"known_hosts"

/* probeing packet header */
typedef struct ProbeHeaderType
{
	uint16_t	packet_no;	
	uint16_t	serverType;
	uint16_t	status;
	uint16_t	serverNo;
	uint32_t	body_length;	
	uint32_t	rec_num;	
} Probe_Header;

/* probeing packet body (server status) */
typedef struct ServerStatusType
{
	uint16_t	serverId;
	uint16_t	serverType;
	uint16_t	status;
	uint16_t	portNumber;
	char		hostName[IP_ADDR_LENGTH];
} Server_Status;

/* Physical server information */
typedef struct Physical_Server_Info_Type
{
	uint16_t	physicalServerId;
	uint16_t	status;
	uint16_t	serverNo;
	char		hostName[HOSTNAME_MAX_LENGTH];
	char		ipAddr[IP_ADDR_LENGTH];
	char		userName[USERNAME_MAX_LENGTH];
} Physical_Server_Info;

/* server information for ssl certificate */
typedef struct SSL_Server_Info_Type
{
	uint16_t	physicalServerId;
	uint16_t	status;
	uint16_t	serverNo;
	uint16_t	portNumber;
	char		hostName[IP_ADDR_LENGTH];
	char		workPath[PATH_MAX_LENGTH];
	char		binPath[PATH_MAX_LENGTH];
	char		sslPath[PATH_MAX_LENGTH];
	char		serverCertFile[PATH_MAX_LENGTH];
	char		clientCertFile[PATH_MAX_LENGTH];
} SSL_Server_Info;

/* load balance server information */
typedef struct Pglb_Info_Type
{
	uint16_t	physicalServerId;
	uint16_t	status;
	uint16_t	receiveStatus;
	uint16_t	serverNo;
	uint16_t	receivePortNumber;
	uint16_t	recoveryPortNumber;
	uint16_t	maxClusterNum;
	uint16_t	logRotate;
	char		hostName[IP_ADDR_LENGTH];
	char		backendSocketDir[PATH_MAX_LENGTH];
	char		usePool[4];
	char		lifecheckTimeout[8];
	char		lifecheckInterval[8];
	char		connectionLifetime[8];
	char		logFileName[PATH_MAX_LENGTH];
	char		logFileSize[8];
	char		workPath[PATH_MAX_LENGTH];
	char		binPath[PATH_MAX_LENGTH];
} Pglb_Info;

/* cluster DB server information */
typedef struct Cluster_Info_Type
{
	uint16_t	physicalServerId;
	uint16_t	status;
	uint16_t	receiveStatus;
	uint16_t	serverNo;
	uint16_t	portNumber;
	uint16_t	recoveryPortNumber;
	uint16_t	maxConnections;
	uint16_t	use_num;
	char		hostName[IP_ADDR_LENGTH];
	char		rsyncPath[PATH_MAX_LENGTH];
	char		rsyncOption[PATH_MAX_LENGTH];
	char		rsyncCompress[4];
	char		rsyncTimeout[8];
	char		rsyncBwlimit[16];
	char		pgdumpPath[PATH_MAX_LENGTH];
	char		pingPath[PATH_MAX_LENGTH];
	char		whenStandAlone[12];
	char		replicationTimeout[8];
	char		lifecheckTimeout[8];
	char		lifecheckInterval[8];
	char		workPath[PATH_MAX_LENGTH];
	char		binPath[PATH_MAX_LENGTH];
} Cluster_Info;

/* replication server information */
typedef struct Pgrp_Info_Type
{
	uint16_t	physicalServerId;
	uint16_t	status;
	uint16_t	receiveStatus;
	uint16_t	serverNo;
	uint16_t	replicationPortNumber;
	uint16_t	recoveryPortNumber;
	uint16_t	RLogPortNumber;
	uint16_t	logRotate;
	char		hostName[IP_ADDR_LENGTH];
	char		useRlog[4];
	char		replicationTimeout[8];
	char		lifecheckTimeout[8];
	char		lifecheckInterval[8];
	char		logFileName[PATH_MAX_LENGTH];
	char		logFileSize[8];
	char		workPath[PATH_MAX_LENGTH];
	char		binPath[PATH_MAX_LENGTH];
} Pgrp_Info;

typedef struct Partial_Info_Type
{
	uint16_t	serverNo;
	uint16_t	recNo;
	char		dbName[DBNAME_MAX_LENGTH];
	char 		tableName[TABLENAME_MAX_LENGTH];
	char		query[SKIP_QUERY_MAX_LENGTH];
} Partial_Info;

typedef struct Exec_Info_Type
{
	uint16_t	portNumber;
	char		workPath[PATH_MAX_LENGTH];
	char		binPath[PATH_MAX_LENGTH];
	char		command[PATH_MAX_LENGTH];
	char		options[4][PATH_MAX_LENGTH];
} Exec_Info;

typedef struct Record_Num_Info_Type
{
	uint16_t	serverNum;
	uint16_t	adminNum;
	uint16_t	probeNum;
	uint16_t	pglbNum;
	uint16_t	clusterNum;
	uint16_t	partialNum;
	uint16_t	pgrpNum;
	uint16_t	totalNum;
} Record_Num_Info;

typedef struct Shmid_Info_Type
{
	int PhysicalServerShmid;
	int AdminShmid;
	int ProbeShmid;
	int PglbShmid;
	int ClusterShmid;
	int PgrpShmid;
}Shmid_Info;

typedef struct SSL_Info_Type
{
	BIO * conn;
	SSL * ssl;
	SSL_CTX * ctx;
} SSL_Info;

extern char * ServerTbl;
extern int ServerTblSize;
extern Physical_Server_Info * PhysicalServerTbl;
extern SSL_Server_Info * AdminTbl;
extern SSL_Server_Info * ProbeTbl;
extern Pglb_Info * PglbTbl;
extern Cluster_Info * ClusterDbTbl;
extern Pgrp_Info * PgrpTbl;
extern Partial_Info * PartialTbl;
extern Record_Num_Info * RecordNumTbl;
extern Shmid_Info ShmidTbl;
extern int Fork_Delay_Time;
extern char * PGR_Data_Path;
extern char * PGR_Write_Path;

extern ConfDataType * ConfData_Top;
extern ConfDataType * ConfData_End;

/* extern in admin_exec.c */
extern uint16_t PGC_Admin_Exec_Cluster(uint16_t packet_no, Cluster_Info * cluster);
extern uint16_t PGC_Admin_Exec_Pgrp(uint16_t packet_no, Pgrp_Info * pgrp);
extern uint16_t PGC_Admin_Exec_Pglb(uint16_t packet_no, Pglb_Info * pglb);
extern uint16_t PGC_Confirm_Cluster_Alive(Cluster_Info * cluster);
extern uint16_t PGC_Confirm_Pgrp_Alive(Pgrp_Info * pgrp);
extern uint16_t PGC_Confirm_Pglb_Alive(Pglb_Info * pglb);

/* extern in admin_monitor.c */
extern int PGC_Admin_Status_Monitor(int fork_wait_time);

/* exten in admin_set_cluster_status.c */
extern int PGC_Admin_Set_Cluster_Status(Probe_Header * header, char * packet);
extern int PGC_Sync_Status_Cluster(Cluster_Info * cluster);

/* extern in admin_set_pglb_status.c */
extern int PGC_Admin_Set_Pglb_Status(Probe_Header * header, char * packet);
extern int PGC_Sync_Status_Pglb(Pglb_Info * pglb);

/* extern of admin_set_pgrp_status.c */
extern int PGC_Admin_Set_Pgrp_Status(Probe_Header * header, char * packet);
extern int PGC_Sync_Status_Pgrp(Pgrp_Info * pgrp);

/* extern in admin_set_status.c */
extern int PGC_Admin_Set_Status(SSL_Info * ssl_tbl, Probe_Header * header, char * packet);

/* extern of conf.c */
extern int PGRget_Template_Data(char * path);
extern int PGRget_Admin_Conf_Data(char * path, char * fname);
extern int PGRinit_Server(char * path);
extern int PGRinit_Admin(char * path);
extern int PGRinit_Probe(char * path);
extern void PGR_Clear_Shm(void);
extern Physical_Server_Info * PGRget_Physical_Server_Rec(uint16_t physicalServerId);

/* extern in packet.c */
extern Probe_Header * PGC_Set_Packet_Header(Probe_Header * header, Probe_Header * h_data);
extern Server_Status * PGC_Set_Server_Status(Server_Status * body, Server_Status * data);
extern Pglb_Info * PGC_Set_Pglb_Info_2_packet(Pglb_Info * body, Pglb_Info * data);
extern Pglb_Info * PGC_Set_Packet_2_Pglb_Info(Pglb_Info * pglb, Pglb_Info * packet);
extern Cluster_Info * PGC_Set_Cluster_Info_2_packet(Cluster_Info * body, Cluster_Info * data);
extern Cluster_Info * PGC_Set_Packet_2_Cluster_Info(Cluster_Info * cluster, Cluster_Info * packet);
extern Pgrp_Info * PGC_Set_Pgrp_Info_2_packet(Pgrp_Info * body, Pgrp_Info * data);
extern Pgrp_Info * PGC_Set_Packet_2_Pgrp_Info(Pgrp_Info * pgrp, Pgrp_Info * packet);
extern ClusterTbl * PGC_Set_ClusterTbl_2_packet(ClusterTbl * body, ClusterTbl * data);
extern ClusterTbl * PGC_Set_Packet_2_ClusterTbl(ClusterTbl * cluster, ClusterTbl * packet);
extern ReplicateServerInfo * PGC_Set_ReplicateServerInfo_2_packet(ReplicateServerInfo * body, ReplicateServerInfo * data);
extern ReplicateServerInfo * PGC_Set_Packet_2_ReplicateServerInfo(ReplicateServerInfo * replicate, ReplicateServerInfo * packet);
extern HostTbl * PGC_Set_HostTbl_2_packet(HostTbl * body, HostTbl * data);
extern HostTbl * PGC_Set_Packet_2_HostTbl(HostTbl * host, HostTbl * packet);
extern Physical_Server_Info * PGC_Set_Physical_Server_Info_2_packet(Physical_Server_Info * body, Physical_Server_Info * data);
extern Physical_Server_Info * PGC_Set_Packet_2_Physical_Server_Info(Physical_Server_Info * server, Physical_Server_Info * packet);
extern SSL_Server_Info * PGC_Set_Packet_2_SSL_Server_Info(SSL_Server_Info * admin, SSL_Server_Info * packet);
extern SSL_Server_Info * PGC_Set_SSL_Server_Info_2_packet(SSL_Server_Info * body, SSL_Server_Info * data);
extern SSL_Server_Info * PGC_Set_Packet_2_SSL_Server_Info(SSL_Server_Info * probe, SSL_Server_Info * packet);
extern int PGC_Probe_Send_Packet(Probe_Header * header, char * body );
extern int PGC_Admin_Send_Packet(SSL_Info * ssl_tbl, Probe_Header * header, char * body, uint16_t physicalServerId );
extern SSL_Server_Info * PGC_Get_Probe_In_PhysicalServer(uint16_t physicalServerId);
extern int PGC_Send_Status_Packet(SSL_Info * ssl_tbl, Probe_Header * header, char * body );
extern char * PGC_Read_Probe_Packet(SSL_Info * ssl_tbl, Probe_Header * header);
extern Probe_Header * PGC_Response_Receive(SSL_Info * ssl_tbl, Probe_Header * header);
extern int PGC_Response_Send(SSL_Info * ssl_tbl, uint16_t packet_no, uint16_t status);

/* extern of probe_exec.c */
extern int PGC_Probe_Exec(SSL_Info * ssl_tbl, Probe_Header * header, char * packet);
extern char * PGC_Exec_Server(Exec_Info * exec);

/* extern of probe_exec_cluster.c */
extern uint16_t PGC_Probe_Exec_Cluster(Probe_Header * header, char * packet);

/* extern of probe_exec_pglb.c */
extern uint16_t PGC_Probe_Exec_Pglb(Probe_Header * header, char * packet);

/* extern of probe_exec_pgrp.c */
extern uint16_t PGC_Probe_Exec_Pgrp(Probe_Header * header, char * packet);

/* extern of probe_get_cluster_status.c */
extern int PGC_Get_Cluster_Status(void);
extern ReplicateServerInfo * PGC_Get_Cluster_Shm(char * path);
extern int PGC_Send_Cluster_Status(Cluster_Info * cluster, ReplicateServerInfo * replicate );
extern int PGC_Get_ReplicateServerInfo_Rec_Num(ReplicateServerInfo * replicate);

/* extern of probe_get_pglb_status.c */
extern int PGC_Get_Pglb_Status(void);
extern ClusterTbl * PGC_Get_Pglb_Shm(char * path);
extern int PGC_Send_Pglb_Status(Pglb_Info * pglb, ClusterTbl * cluster );
extern int PGC_Get_ClusterTbl_Rec_Num(ClusterTbl * cluster);

/* extern of probe_get_pgrp_status.c */
extern int PGC_Get_Pgrp_Status(void);
extern HostTbl * PGC_Get_Pgrp_Shm(char * path);
extern int PGC_Send_Pgrp_Status(Pgrp_Info * pgrp, HostTbl * cluster );
extern int PGC_Get_HostTbl_Rec_Num(HostTbl * cluster);

/* extern of probe_get_status.c */
extern int PGC_Probe_Get_Status(Probe_Header * header, char * packet);

/* extern of probe_info.c */
extern int PGC_SSL_Server_Info(SSL_Info * ssl_tbl, Probe_Header * header, char * packet);
extern int PGC_Set_SSL_Admin(Probe_Header * header, SSL_Server_Info * packet);
extern int PGC_Set_SSL_Probe(Probe_Header * header, SSL_Server_Info * packet);
extern int PGC_Set_Pglb_Info(Probe_Header * header, Pglb_Info * packet);
extern int PGC_Set_Cluster_Info(Probe_Header * header, Cluster_Info * packet);
extern int PGC_Set_Pgrp_Info(Probe_Header * header, Pgrp_Info * packet);
extern int PGC_Set_Physical_Server_Info(Probe_Header * header, Physical_Server_Info * packet);
extern SSL_Server_Info * PGC_Get_SSL_Server_Rec(SSL_Server_Info * ssl_server_tbl, int server_no);

/* extern of probe_init.c */
extern int PGC_Probe_Init(SSL_Info * ssl_tbl, Probe_Header * header, SSL_Server_Info * packet);

/* extern of probe_set_cluster_status.c */
extern int PGC_Set_Cluster_Status(Probe_Header * header, char * packet);
extern Cluster_Info * PGC_Get_ClusterDbTbl_Rec(Cluster_Info * key);

/* extern of probe_set_pglb_status.c */
extern int PGC_Set_Pglb_Status(Probe_Header * header, char * packet);
extern Pglb_Info * PGC_Get_PglbTbl_Rec(Pglb_Info * key);

/* extern of probe_set_pgrp_status.c */
extern int PGC_Set_Pgrp_Status(Probe_Header * header, char * packet);
extern Pgrp_Info * PGC_Get_PgrpTbl_Rec(Pgrp_Info * key);

/* extern of probe_set_status.c */
extern int PGC_Probe_Set_Status(SSL_Info * ssl_tbl, Probe_Header * header, char * packet);

/* extern of stop.c */
extern void PGC_Stop_Process(char * path, char * pid_fname);
extern void PGC_Status_Process(char * path, char * pid_fname);
extern bool PGC_Is_Exist_Pid_File(char * path, char * pid_fname);
extern void PGC_Child_Wait(int signo);
extern int PGC_Write_Pid_File(char * path, char * pid_fname);
extern void PGC_Daemonize(void);
extern int PGC_Admin_Shutdown(char * path);

/* extern of show.c */
extern void show_cluster_tbl(ClusterTbl * cluster);
extern void show_cluster_tbl_net(ClusterTbl * cluster);
extern void show_host_tbl(HostTbl * host);
extern void show_replicate_server_info(ReplicateServerInfo * rep);
extern void show_pglb_info(Pglb_Info * pglb);

/* extern of admin_user_req.c */
extern uint16_t PGC_Admin_User_Exec_Req(uint16_t packet_no, uint16_t serverType, uint16_t serverNo);
extern int PGC_Admin_User_Status_Req(SSL_Info * ssl_tbl, uint16_t serverType, uint16_t serverNo);

/* extern of ssl.c */
extern void PGC_SSL_Init(void);
extern int PGC_SSL_Verify_Callback(int ok, X509_STORE_CTX *store);
extern long PGC_SSL_Post_Connection_Check(SSL_Info *ssl_tbl, char *host);
extern void PGC_SSL_Seed_Prng(void);
extern int PGC_SSL_Send(SSL_Info *ssl_tbl, char * buf, int length );
extern int  PGC_SSL_Read(SSL_Info *ssl_tbl, char * buf, int length );
extern int PGC_SSL_Thread_Setup(void);
extern int PGC_SSL_Thread_Cleanup(void);

extern void PGC_SSL_Server_Init_DH(void);
extern DH * PGC_SSL_Server_DH_Callback(SSL *ssl, int is_export, int keylength);
extern SSL_CTX * PGC_SSL_Server_Setup_Ctx(SSL_Server_Info * ssl_server);
extern SSL_CTX * PGC_SSL_Client_Setup_Ctx(SSL_Server_Info * ssl_server);
extern void PGC_Close_SSL(SSL_Info * ssl_tbl);
extern void PGC_Clear_SSL(SSL_Info * ssl_tbl,int flag);
extern SSL_Info * PGC_Create_Admin_Send_SSL(SSL_Info * ssl_tbl, char * hostName,  uint16_t portNumber);
extern SSL_Info * PGC_Create_Probe_Send_SSL(SSL_Info * ssl_tbl, char * hostName,  uint16_t portNumber);

/* extern of set_conf.c */
extern int PGRcreate_pgc_admin_conf (char * path);
extern void PGRcreate_pgcluster_conf (char * path);
extern char * PGRget_dir_name_with_hostname(char * buf, char * path, Physical_Server_Info *server);
extern FILE * PGRupdate_conf_contents(FILE * rfp, FILE * wfp, char * tag, char * data);
extern FILE * PGRcopy_file(FILE * src_fp, FILE * dest_fp);
extern int PGR_execv(char * command, char *args[]);
extern FILE * PGRopen_write_file(char * base_dir, char * work_path, char * fname, char * mode);

/* extern of set_key.c */
extern  int PGRcreate_public_key_files(char * path);
extern  int PGRsend_public_key_files(char * path);
extern int PGRcreate_admin_pem_files(char * path);
extern int PGRcreate_probe_pem_files(char * path);

/* extern of send_conf.c */
extern int PGRsend_pgc_admin_conf_file(char * path);
extern int PGRsend_pgc_probe_conf_file(char * path);
extern int PGRsend_conf_files(char * path);

#endif /* PGC_MONITOR_H */
