/*
 * $Header: /home/prj/pg/ipa-pgpool2/cvsroot/ipa-pgpool2/pgpool_src/pcp/pcp_stream.h,v 1.1 2006/06/23 05:42:50 y-asaba Exp $
 *
 * pcp_stream.h - master header file.
 */

#ifndef PCP_STREAM_H
#define PCP_STREAM_H

#include "pool.h"

#define READBUFSZ              1024
#define WRITEBUFSZ             8192

typedef struct {
	int fd;        /* fd for connection */

	char *wbuf;	   /* write buffer for the connection */
	int wbufsz;	   /* write buffer size */
	int wbufpo;	   /* buffer offset */

	char *hp;	   /* pending data buffer head address */
	int po;		   /* pending data offset */
	int bufsz;	   /* pending data buffer size */
	int len;	   /* pending data length */
} PCP_CONNECTION;

extern PCP_CONNECTION *pcp_open(int fd);
extern void pcp_close(PCP_CONNECTION *pc);
extern int pcp_read(PCP_CONNECTION *pc, void *buf, int len);
extern int pcp_write(PCP_CONNECTION *pc, void *buf, int len);
extern int pcp_flush(PCP_CONNECTION *pc);

#define UNIX_DOMAIN_PATH "/tmp"

#endif /* PCP_STREAM_H */
