--
-- PostgreSQL database dump
--

DROP TABLE pgunitresults;

SET client_encoding = 'UTF8';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- TOC entry 1185 (class 1259 OID 22744)
-- Dependencies: 4
-- Name: pgunitresults; Type: TABLE; Schema: public; Owner: root; Tablespace: 
--

CREATE TABLE pgunitresults (
    id bigserial NOT NULL,
    date timestamp without time zone NOT NULL,
    name text,
    "type" smallint NOT NULL CHECK ("type" >= 1 AND "type" <= 5),
    modifiers smallint,
    query text NOT NULL,
    expected text,
    retrieved text,
    failure boolean NOT NULL
);

--
-- TOC entry 1516 (class 0 OID 0)
-- Dependencies: 1184
-- Name: pgunitresults_id_seq; Type: SEQUENCE SET; Schema: public; Owner: root
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('pgunitresults', 'id'), 1, false);


--
-- TOC entry 1510 (class 2606 OID 22751)
-- Dependencies: 1185 1185
-- Name: pk_pgunitresults; Type: CONSTRAINT; Schema: public; Owner: root; Tablespace: 
--

ALTER TABLE ONLY pgunitresults
    ADD CONSTRAINT pk_pgunitresults PRIMARY KEY (id);


--
-- TOC entry 1508 (class 1259 OID 22752)
-- Dependencies: 1185
-- Name: key_date; Type: INDEX; Schema: public; Owner: root; Tablespace: 
--

CREATE INDEX key_date ON pgunitresults USING btree (date);

--
-- PostgreSQL database dump complete
--

