/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Random;
import java.util.logging.Logger;
import org.postgresql.pljava.ResultSetProvider;

public class HugeResultSet
implements ResultSetProvider {
    private final int m_rowCount;
    private final Random m_random;

    public static ResultSetProvider executeSelect(int n) throws SQLException {
        return new HugeResultSet(n);
    }

    public HugeResultSet(int n) throws SQLException {
        this.m_rowCount = n;
        this.m_random = new Random(System.currentTimeMillis());
    }

    public boolean assignRowValues(ResultSet resultSet, int n) throws SQLException {
        if (n >= this.m_rowCount) {
            Logger.getAnonymousLogger().info("HugeResultSet ends");
            return false;
        }
        resultSet.updateInt(1, n);
        resultSet.updateInt(2, this.m_random.nextInt());
        resultSet.updateTimestamp(3, new Timestamp(System.currentTimeMillis()));
        return true;
    }

    public void close() {
    }
}

