/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.ELogFormatter;

public class ELogHandler
extends Handler {
    public static final int LOG_DEBUG5 = 10;
    public static final int LOG_DEBUG4 = 11;
    public static final int LOG_DEBUG3 = 12;
    public static final int LOG_DEBUG2 = 13;
    public static final int LOG_DEBUG1 = 14;
    public static final int LOG_LOG = 15;
    public static final int LOG_INFO = 17;
    public static final int LOG_NOTICE = 18;
    public static final int LOG_WARNING = 19;
    public static final int LOG_ERROR = 20;
    public static final int LOG_FATAL = 21;
    public static final int LOG_PANIC = 22;

    @Override
    public void publish(LogRecord logRecord) {
        Level level = logRecord.getLevel();
        int n = level == null ? 15 : (level.equals(Level.SEVERE) ? 20 : (level.equals(Level.WARNING) ? 19 : (level.equals(Level.INFO) ? 17 : (level.equals(Level.FINE) ? 14 : (level.equals(Level.FINER) ? 13 : (level.equals(Level.FINEST) ? 12 : 15))))));
        Backend.log(n, this.getFormatter().format(logRecord));
    }

    public ELogHandler() {
        this.configure();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public static void init() {
        Properties properties = new Properties();
        properties.setProperty("handlers", ELogHandler.class.getName());
        properties.setProperty(".level", ELogHandler.getPgLevel().getName());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, null);
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Level getPgLevel() {
        String string = Backend.getConfigOption("log_min_messages");
        Level level = Level.ALL;
        if (string != null) {
            if ((string = string.toLowerCase().trim()).equals("panic") || string.equals("fatal")) {
                level = Level.OFF;
            } else if (string.equals("error")) {
                level = Level.SEVERE;
            } else if (string.equals("warning")) {
                level = Level.WARNING;
            } else if (string.equals("notice")) {
                level = Level.CONFIG;
            } else if (string.equals("info")) {
                level = Level.INFO;
            } else if (string.equals("debug1")) {
                level = Level.FINE;
            } else if (string.equals("debug2")) {
                level = Level.FINER;
            } else if (string.equals("debug3") || string.equals("debug4") || string.equals("debug5")) {
                level = Level.FINEST;
            }
        }
        return level;
    }

    private void configure() {
        String string;
        LogManager logManager = LogManager.getLogManager();
        String string2 = logManager.getProperty((string = ELogHandler.class.getName()) + ".filter");
        if (string2 != null) {
            try {
                this.setFilter((Filter)Class.forName(string2.trim()).newInstance());
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        if (string2 == null) {
            this.setFilter(null);
        }
        if ((string2 = logManager.getProperty(string + ".formatter")) != null) {
            try {
                this.setFormatter((Formatter)Class.forName(string2.trim()).newInstance());
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        if (string2 == null) {
            this.setFormatter(new ELogFormatter());
        }
        if ((string2 = logManager.getProperty(string + ".encoding")) != null) {
            try {
                this.setEncoding(string2.trim());
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        if (string2 == null) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

