/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.JavaWrapper;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Tuple;

public class TupleDesc
extends JavaWrapper {
    private final int m_size;
    private Class[] m_columnClasses;

    TupleDesc(long l, int n) throws SQLException {
        super(l);
        this.m_size = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName(int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TupleDesc._getColumnName(this.getNativePointer(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnIndex(String string) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TupleDesc._getColumnIndex(this.getNativePointer(), string.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple formTuple(Object[] objectArray) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TupleDesc._formTuple(this.getNativePointer(), objectArray);
        }
    }

    public int size() {
        return this.m_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getColumnClass(int n) throws SQLException {
        if (this.m_columnClasses == null) {
            this.m_columnClasses = new Class[this.m_size];
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                long l = this.getNativePointer();
                for (int i = 0; i < this.m_size; ++i) {
                    this.m_columnClasses[i] = TupleDesc._getOid(l, i + 1).getJavaClass();
                }
            }
        }
        return this.m_columnClasses[n - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Oid getOid(int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return TupleDesc._getOid(this.getNativePointer(), n);
        }
    }

    @Override
    protected native void _free(long var1);

    private static native String _getColumnName(long var0, int var2) throws SQLException;

    private static native int _getColumnIndex(long var0, String var2) throws SQLException;

    private static native Tuple _formTuple(long var0, Object[] var2) throws SQLException;

    private static native Oid _getOid(long var0, int var2) throws SQLException;
}

