/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIParameterMetaData
implements ParameterMetaData {
    private final int[] m_sqlTypes;

    SPIParameterMetaData(int[] nArray) {
        this.m_sqlTypes = nArray;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.m_sqlTypes == null ? 0 : this.m_sqlTypes.length;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return 2;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return true;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int n) throws SQLException {
        return 0;
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        if (n < 1 || n > this.getParameterCount()) {
            throw new SQLException("Parameter index out of range");
        }
        return this.m_sqlTypes[n - 1];
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        throw new UnsupportedFeatureException("Parameter type name support not yet implemented");
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        throw new UnsupportedFeatureException("Parameter class name support not yet implemented");
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        if (n < 1 || n > this.getParameterCount()) {
            throw new SQLException("Parameter index out of range");
        }
        return 1;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".isWrapperFor( Class<?> ) not implemented yet.", "0A000");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".unwrapClass( Class<?> ) not implemented yet.", "0A000");
    }
}

