/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.JavaWrapper;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.ClobValue;
import org.postgresql.pljava.jdbc.SPIConnection;

public class SQLInputFromTuple
extends JavaWrapper
implements SQLInput {
    private int m_index;
    private final TupleDesc m_tupleDesc;
    private boolean m_wasNull;

    public SQLInputFromTuple(long l, TupleDesc tupleDesc) throws SQLException {
        super(l);
        this.m_tupleDesc = tupleDesc;
        this.m_index = 0;
        this.m_wasNull = false;
    }

    @Override
    public Array readArray() throws SQLException {
        return (Array)this.readValue(Array.class);
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        Clob clob = this.readClob();
        return clob == null ? null : clob.getAsciiStream();
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        return (BigDecimal)this.readValue(BigDecimal.class);
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        Blob blob = this.readBlob();
        return blob == null ? null : blob.getBinaryStream();
    }

    @Override
    public Blob readBlob() throws SQLException {
        byte[] byArray = this.readBytes();
        return byArray == null ? null : new BlobValue(byArray);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        Boolean bl = (Boolean)this.readValue(Boolean.class);
        return bl == null ? false : bl;
    }

    @Override
    public byte readByte() throws SQLException {
        Number number = this.readNumber(Byte.TYPE);
        return number == null ? (byte)0 : number.byteValue();
    }

    @Override
    public byte[] readBytes() throws SQLException {
        return (byte[])this.readValue(byte[].class);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        Clob clob = this.readClob();
        return clob == null ? null : clob.getCharacterStream();
    }

    @Override
    public Clob readClob() throws SQLException {
        String string = this.readString();
        return string == null ? null : new ClobValue(string);
    }

    @Override
    public Date readDate() throws SQLException {
        return (Date)this.readValue(Date.class);
    }

    @Override
    public double readDouble() throws SQLException {
        Number number = this.readNumber(Double.TYPE);
        return number == null ? 0.0 : number.doubleValue();
    }

    @Override
    public float readFloat() throws SQLException {
        Number number = this.readNumber(Float.TYPE);
        return number == null ? 0.0f : number.floatValue();
    }

    @Override
    public int readInt() throws SQLException {
        Number number = this.readNumber(Integer.TYPE);
        return number == null ? 0 : number.intValue();
    }

    @Override
    public long readLong() throws SQLException {
        Number number = this.readNumber(Long.TYPE);
        return number == null ? 0L : number.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject() throws SQLException {
        if (this.m_index < this.m_tupleDesc.size()) {
            Object object;
            Object object2 = Backend.THREADLOCK;
            synchronized (object2) {
                object = SQLInputFromTuple._getObject(this.getNativePointer(), this.m_tupleDesc.getNativePointer(), ++this.m_index);
            }
            this.m_wasNull = object == null;
            return object;
        }
        throw new SQLException("Tuple has no more columns");
    }

    @Override
    public Ref readRef() throws SQLException {
        return (Ref)this.readValue(Ref.class);
    }

    @Override
    public short readShort() throws SQLException {
        Number number = this.readNumber(Short.TYPE);
        return number == null ? (short)0 : number.shortValue();
    }

    @Override
    public String readString() throws SQLException {
        return (String)this.readValue(String.class);
    }

    @Override
    public Time readTime() throws SQLException {
        return (Time)this.readValue(Time.class);
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        return (Timestamp)this.readValue(Timestamp.class);
    }

    @Override
    public URL readURL() throws SQLException {
        return (URL)this.readValue(URL.class);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_wasNull;
    }

    private Number readNumber(Class clazz) throws SQLException {
        return SPIConnection.basicNumericCoersion(clazz, this.readObject());
    }

    private Object readValue(Class clazz) throws SQLException {
        return SPIConnection.basicCoersion(clazz, this.readObject());
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readRowId() not implemented yet.", "0A000");
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readSQLXML() not implemented yet.", "0A000");
    }

    @Override
    public String readNString() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readNString() not implemented yet.", "0A000");
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException(this.getClass() + ".readNClob() not implemented yet.", "0A000");
    }

    @Override
    protected native void _free(long var1);

    private static native Object _getObject(long var0, long var2, int var4) throws SQLException;
}

