/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.SingleRowResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SingleRowReader
extends SingleRowResultSet {
    private final TupleDesc m_tupleDesc;
    private final long m_pointer;

    public SingleRowReader(long l, TupleDesc tupleDesc) throws SQLException {
        this.m_pointer = l;
        this.m_tupleDesc = tupleDesc;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            this._free(this.m_pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object getObjectValue(int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return SingleRowReader._getObject(this.m_pointer, this.m_tupleDesc.getNativePointer(), n);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw SingleRowReader.readOnlyException();
    }

    private static SQLException readOnlyException() {
        return new UnsupportedFeatureException("ResultSet is read-only");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    protected final TupleDesc getTupleDesc() {
        return this.m_tupleDesc;
    }

    protected native void _free(long var1);

    private static native Object _getObject(long var0, long var2, int var4) throws SQLException;
}

