/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.BlobValue;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SingleRowResultSet;

public class SingleRowWriter
extends SingleRowResultSet {
    private final TupleDesc m_tupleDesc;
    private final Object[] m_values;
    private Tuple m_tuple;

    public SingleRowWriter(TupleDesc tupleDesc) throws SQLException {
        this.m_tupleDesc = tupleDesc;
        this.m_values = new Object[tupleDesc.size()];
    }

    @Override
    protected Object getObjectValue(int n) throws SQLException {
        if (n < 1) {
            throw new SQLException("System columns cannot be obtained from this type of ResultSet");
        }
        return this.m_values[n - 1];
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        int n = this.m_values.length;
        while (--n >= 0) {
            if (this.m_values[n] == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        Class clazz;
        if (n < 1) {
            throw new SQLException("System columns cannot be updated");
        }
        if (object == null) {
            this.m_values[n - 1] = object;
        }
        if (!((clazz = this.m_tupleDesc.getColumnClass(n)).isInstance(object) || clazz == byte[].class && object instanceof BlobValue)) {
            object = Number.class.isAssignableFrom(clazz) ? SPIConnection.basicNumericCoersion(clazz, object) : (Time.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || Timestamp.class.isAssignableFrom(clazz) ? SPIConnection.basicCalendricalCoersion(clazz, object, Calendar.getInstance()) : SPIConnection.basicCoersion(clazz, object));
        }
        this.m_values[n - 1] = object;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        Arrays.fill(this.m_values, null);
    }

    @Override
    public void close() throws SQLException {
        Arrays.fill(this.m_values, null);
        this.m_tuple = null;
    }

    public void copyRowFrom(ResultSet resultSet) throws SQLException {
        int n = this.m_values.length;
        for (int i = 0; i < n; ++i) {
            this.m_values[i] = resultSet.getObject(i + 1);
        }
    }

    public long getTupleAndClear() throws SQLException {
        this.m_tuple = this.getTupleDesc().formTuple(this.m_values);
        Arrays.fill(this.m_values, null);
        return this.m_tuple.getNativePointer();
    }

    @Override
    protected final TupleDesc getTupleDesc() {
        return this.m_tupleDesc;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_tuple == null;
    }

    @Override
    public int getHoldability() {
        return 2;
    }
}

