/* $Id: call.h,v 1.4 2005/05/12 19:29:34 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/call.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/call.h,v 1.2 2004/12/15 13:05:14 flaw
 * imp/src/fcall.h,v 1.3 2004/10/08 20:38:44 flaw
 * if/src/fcall.h,v 1.1 2004/09/28 15:40:49 flaw
 *//*
 * Postgres function call interface for Python header
 */
#ifndef PyPg_call_H
#define PyPg_call_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgCall_HEAD	\
	PyObject_HEAD			\
	PyObj call_func;		\
	PyObj call_args;		\
	PyObj call_kw;			\
	PyObj	call_xtd;		\
	PyObj call_ret;		\

typedef struct PyPgCall {
	PyPgCall_HEAD
} * PyPgCall;

extern PyTypeObject PyPgCall_Type;
PyObj PyPgCall_Initialize(PyObj, PyObj, PyObj, PyObj);

#define PyPgCall_NEW() \
	(PyObj) PyPgCall_Type.tp_alloc(&PyPgCall_Type, 0)
#define PyPgCall_New(F, A, X) PyPgCall_Initialize(PyPgCall_NEW(), F, A, X)

#define PyPgCall(SELF) ((PyPgCall) SELF)

#define PyPgCall_Check(SELF) (PyObject_TypeCheck((SELF), &PyPgCall_Type))
#define PyPgCall_CheckExact(SELF) ((SELF)->ob_type == &PyPgCall_Type)

#define PyPgCall_FetchFunction(SELF)		(PyPgCall(SELF)->call_func)
#define PyPgCall_FetchArguments(SELF)		(PyPgCall(SELF)->call_args)
#define PyPgCall_FetchKeywords(SELF)		(PyPgCall(SELF)->call_kw)
#define PyPgCall_FetchExpected(SELF)		(PyPgCall(SELF)->call_xtd)
#define PyPgCall_FetchReturned(SELF)		(PyPgCall(SELF)->call_ret)

#define PyPgCall_FixFunction(SELF, OB)		(PyPgCall_FetchFunction(SELF) = OB)
#define PyPgCall_FixArguments(SELF, OB)	(PyPgCall_FetchArguments(SELF) = OB)
#define PyPgCall_FixKeywords(SELF, OB)		(PyPgCall_FetchKeywords(SELF) = OB)
#define PyPgCall_FixExpected(SELF, OB)		(PyPgCall_FetchExpected(SELF) = OB)
#define PyPgCall_FixReturned(SELF, OB)		(PyPgCall_FetchReturned(SELF) = OB)

#define PyPgCall_FetchExpectedTupleDesc(SELF)	\
	PyPgTupleDesc_FetchTupleDesc(PyPgCall(SELF)->call_xtd)

#define PyPgCall_FetchProcedure(SELF) \
	(PyPgFunction_FetchProcedure(PyPgCall_FetchFunction(SELF)))
#define PyPgCall_FetchHeapTupleHeader(SELF) \
	(PyPgObject_FetchHeapTupleHeader(PyPgCall_FetchProcedure(SELF)))
#define PyPgCall_FetchProcStruct(SELF) \
	((Form_pg_proc) HeapTupleHeaderStructure(PyPgCall_FetchHeapTupleHeader(SELF)))
#define PyPgCall_FetchFunctionOid(SELF)	\
	(HeapTupleHeaderGetOid(PyPgCall_FetchHeapTupleHeader(SELF)))

#define PyPgCall_FetchFunctionCode(SELF)\
	(PyPgFunction_FetchCode((PyPgCall_FetchFunction(SELF))))
#define PyPgCall_FetchReturnType(SELF)		\
	(PyPgFunction_FetchReturnType(PyPgCall_FetchFunction(SELF)))

#define PyPgCall_IsPython(SELF) \
	(PyPgCall_FetchFunctionCode(SELF) != Py_None)

#define PyPgCall_FixateKeywords(kw, args, pan) do{ \
	int pos = 0; PyObj k, v; \
	while (PyDict_Next(pan, &pos, &k, &v)) \
		PyDict_SetItem(kw, v, PyList_GET_ITEM(args, PyInt_AsLong(k))); \
}while(0)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_call_H */
/*
 * vim: ts=3:sw=3:noet:
 */
