/* $Id: cis.h,v 1.5 2005/08/10 19:06:50 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * C Interface/API Structures
 */
#ifndef PyPg_cis_H
#define PyPg_cis_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgCI_CObjectName "CI"

typedef int (*PyPgFunction_CodeFixer)(PyObject *);
struct PyPgCI_PL {
	PGFunction Handler;
	PyPgFunction_CodeFixer Fixer;
};

struct PyPgCI_Error {
	PyObject *Type;
	PyObject * (*FromErrorData)(ErrorData *);
	void (*SetPgError)(void);
};

struct PyPgCI_Encoding {
	const char * (*Lookup)(pg_enc);
};

struct PyPgCI_Object {
	PyTypeObject * const Type;
	PyObject * (*Initialize)(PyObject *, PyObject *, Datum);
	PyObject * (*FromPyPgTypeAndDatum)(PyObject *, Datum);
	PyObject * (*FromTypeOidAndDatum)(Oid, Datum);
	PyObject * (*FromPyPgTypeAndHeapTuple)(PyObject *, HeapTuple);
};

struct PyPgCI_Type {
	PyTypeObject * const Type;
	PyObject * (*FromOid)(Oid);
	PyObject * (*FromRelationOid)(Oid);
	PyObject * (*FromPyObject)(PyObject *);
};

struct PyPgCI_Function {
	PyTypeObject * const Type;
	PyObject * (*FromOid)(Oid);
};

struct PyPgCI_Namespace {
	PyTypeObject * const Type;
	PyObject * (*FromOid)(Oid);
};

struct PyPgCI_Relation {
	PyTypeObject * const Type;
	PyObject * (*Initialize)(PyObject *);
	PyObject * (*FromOid)(Oid);
};

struct PyPgCI_Query {
	PyTypeObject * const Type;
	PyObject * (*Initialize)(PyObject *, PyObject *);
};

struct PyPgCI_HeapTuple {
	PyTypeObject * const Type;
	PyObject * (*Initialize)(PyObject *, PyObject *, HeapTuple);
};

struct PyPgCI_TupleDesc {
	PyTypeObject * const Type;
	PyObject * (*Initialize)(PyObject *, TupleDesc);
	PyObject * (*FromRelationId)(Oid);
};

struct PyPgCI_Savepoint {
	PyTypeObject * const Type;
};

struct PyPgCI_Transaction {
	PyTypeObject * const Type;
};

struct PyPgCI_Call {
	PyTypeObject * const Type;
	PyObject * (*Initialize)(PyObject *, PyObject *, PyObject *, PyObject *);
};

struct PyPgCI_Portal {
	PyTypeObject * const Type;
	PyObject * (*Initialize)
		(PyObject *, PyObject *, PyObject *, Query *, Plan *);
};

struct PyPgCI_FunctionCall {
	PyTypeObject * const Type;
	PyObject * (*Initialize)(PyObject *, PyObject *, PyObject *, PyObject *);
};

struct PyPgCI_ProceduralCall {
	PyTypeObject * const Type;
	PyObject * (*Initialize)(PyObject *, FunctionCallInfo);
	int (*InitializeParameters)(PyObject *);
};

struct PyPgCI_TriggerPull {
	PyTypeObject * const Type;
	PyObject * (*Initialize)(PyObject *, FunctionCallInfo);
};

#define D(R) struct PyPgCI_##R R;
struct PyPgCI_Root {
	D(PL)
	D(Error)
	D(Encoding)

	D(Object)
	D(Type)
	D(Function)
	D(Namespace)
	D(Relation)
	D(Query)

	D(TupleDesc)
	D(HeapTuple)

	D(Savepoint)
	D(Transaction)

	D(Call)
	D(Portal)
	D(FunctionCall)
	D(ProceduralCall)
	D(TriggerPull)
};
#undef D

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_cis_H */
/*
 * vim: ts=3:sw=3:noet:
 */
