/* $Id: call.h,v 1.8 2005/12/14 19:25:53 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/call.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/call.h,v 1.2 2004/12/15 13:05:14 flaw
 *//*
 * Postgres function call interface for Python header
 */
#ifndef PyPg_call_H
#define PyPg_call_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgCall_HEAD	\
	PyObject_HEAD			\
	PyObj call_obj;		\
	PyObj call_args;		\
	PyObj	call_out;		\
	PyObj call_ret;		\

typedef struct PyPgCall {
	PyPgCall_HEAD
} * PyPgCall;

extern PyTypeObject PyPgCall_Type;
PyObj PyPgCall_Initialize(PyObj, PyObj, PyObj, PyObj);

#define PyPgCall_NEW() \
	(PyObj) PyPgCall_Type.tp_alloc(&PyPgCall_Type, 0)
#define PyPgCall_New(F, A, X) PyPgCall_Initialize(PyPgCall_NEW(), F, A, X)

#define PyPgCall(SELF) ((PyPgCall) SELF)

#define PyPgCall_Check(SELF) (PyObject_TypeCheck((SELF), &PyPgCall_Type))
#define PyPgCall_CheckExact(SELF) ((SELF)->ob_type == &PyPgCall_Type)

#define PyPgCall_FetchObject(SELF)			(PyPgCall(SELF)->call_obj)
#define PyPgCall_FetchFunction(SELF)		(PyPgCall(SELF)->call_obj)
#define PyPgCall_FetchInput(SELF)			(PyPgCall(SELF)->call_args)
#define PyPgCall_FetchArguments(SELF)		(PyPgCall(SELF)->call_args)
#define PyPgCall_FetchOutput(SELF)			(PyPgCall(SELF)->call_out)
#define PyPgCall_FetchExpected(SELF)		(PyPgCall(SELF)->call_out)
#define PyPgCall_FetchReturned(SELF)		(PyPgCall(SELF)->call_ret)

#define PyPgCall_FixObject(SELF, OB)		(PyPgCall(SELF)->call_obj = OB)
#define PyPgCall_FixFunction(SELF, OB)		(PyPgCall(SELF)->call_obj = OB)
#define PyPgCall_FixInput(SELF, OB)			(PyPgCall(SELF)->call_args = OB)
#define PyPgCall_FixArguments(SELF, OB)	(PyPgCall(SELF)->call_args = OB)
#define PyPgCall_FixOutput(SELF, OB)		(PyPgCall(SELF)->call_out = OB)
#define PyPgCall_FixExpected(SELF, OB)		(PyPgCall(SELF)->call_out = OB)
#define PyPgCall_FixReturned(SELF, OB)		(PyPgCall(SELF)->call_ret = OB)

#define PyPgCall_FetchExpectedTupleDesc(SELF)	\
	PyPgTupleDesc_FetchTupleDesc(PyPgCall(SELF)->call_out)

#define PyPgCall_FetchProcedure(SELF) \
	(PyPgFunction_FetchProcedure(PyPgCall_FetchFunction(SELF)))
#define PyPgCall_FetchHeapTupleHeader(SELF) \
	(PyPgObject_FetchHeapTupleHeader(PyPgCall_FetchProcedure(SELF)))
#define PyPgCall_FetchProcStruct(SELF) \
	((Form_pg_proc) HeapTupleHeaderStructure(PyPgCall_FetchHeapTupleHeader(SELF)))
#define PyPgCall_FetchFunctionOid(SELF)	\
	(HeapTupleHeaderGetOid(PyPgCall_FetchHeapTupleHeader(SELF)))

#define PyPgCall_FetchFunctionCode(SELF)\
	(PyPgFunction_FetchCode((PyPgCall_FetchFunction(SELF))))
#define PyPgCall_FetchFunctionOutput(SELF)		\
	(PyPgFunction_FetchOutput(PyPgCall_FetchFunction(SELF)))

#define PyPgCall_IsPython(SELF) \
	(PyPgCall_FetchFunctionCode(SELF) != Py_None)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_call_H */
/*
 * vim: ts=3:sw=3:noet:
 */
