/* $Id: cis.h,v 1.9 2005/12/14 08:22:31 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * C Interface/API Structures
 */
#ifndef PyPg_cis_H
#define PyPg_cis_H 0
#ifdef __cplusplus
extern "C" {
#endif

#define PyPgCI_CObjectName "CI"

struct PyPgCI_PL {
	PGFunction Handler;
	PyObject * (*CodeFromData)(char *, int);
};

struct PyPgCI_Root {
	struct PyPgCI_PL PL;

	PyObject * _PyExc_PostgresError;
	PyObject * (*_PyExc_FromERRCODE)(int);
	PyObject * (*_PyErr_FromErrorData)(ErrorData *);
	void (*_PyErr_SetPgError)(void);

	const char * (*_PyEncoding_FromPgEncoding)(pg_enc);

	PyTypeObject * const _PyPgType_Type;
	PyPgTypeObject * const _PyPgObject_Type;
	PyPgTypeObject * const _PyPgPseudo_Type;
	PyPgTypeObject * const _PyPgArbitrary_Type;
	PyPgTypeObject * const _PyPgArray_Type;

	PyTypeObject * const _PyPgTupleDesc_Type;
	PyObject * _EmptyPyPgTupleDesc;
	PyObject * (*_PyPgTupleDesc_Initialize)(PyObject *, TupleDesc);
	PyObject * (*_PyPgTupleDesc_FromRelationId)(Oid);

	PyTypeObject * const _PyPgHeapTuple_Type;
	PyObject * _EmptyPyPgHeapTuple;
	PyObject * (*_PyPgHeapTuple_Initialize)(PyObject *, PyObject *, HeapTuple);
	HeapTuple (*_HeapTuple_FromTupleDescAndDatumNulls)
		(TupleDesc, Datum *, bool *);

	PyTypeObject * const _PyPgFunction_Type;
	PyObject * (*_PyPgFunction_FromOid)(Oid);

	PyTypeObject * const _PyPgQuery_Type;
	PyObject * (*_PyPgQuery_Initialize)(PyObject *, PyObject *);

	PyTypeObject * const _PyPgCall_Type;
	PyObject * (*_PyPgCall_Initialize)
		(PyObject *, PyObject *, PyObject *, PyObject *);

	PyTypeObject * const _PyPgFunctionCall_Type;
	PyObject * (*_PyPgFunctionCall_Initialize)
		(PyObject *, PyObject *, PyObject *, PyObject *);

	PyTypeObject * const _PyPgPortal_Type;
	PyObject * (*_PyPgPortal_Initialize) (PyObject *, PyObject *, PyObject *);

	PyTypeObject * const _PyPgProceduralCall_Type;
	PyObject * (*_PyPgProceduralCall_Initialize)(PyObject *, FunctionCallInfo);

	PyTypeObject * const _PyPgTriggerPull_Type;
	PyObject * (*_PyPgTriggerPull_Initialize)(PyObject *, FunctionCallInfo);

	PyObject * (*_PyPgType_FromOid)(Oid);
	PyObject * (*_PyPgType_FromPyObject)(PyObject *);
	PyObject * (*_PyPgObject_Initialize)(PyObject *, Datum);
	PyObject * (*_PyPgObject_FromPyPgTypeAndDatum)(PyObject *, Datum);
	PyObject * (*_PyPgObject_FromTypeOidAndDatum)(Oid, Datum);
	PyObject * (*_PyPgObject_FromPyPgTypeAndHeapTuple)(PyObject *, HeapTuple);

/*
 * Expands to a list of active types.
 * See pypg/type.h and pypg/postgres.h
 */
#define ACTION(NAME, ID) PyPgTypeObject * const PyPgTypeID(NAME);
	PyPgType_Builtins()
#undef ACTION
};

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_cis_H */
/*
 * vim: ts=3:sw=3:noet:
 */
