.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "UPDATE" "" "2009-12-10" "SQL - Language Statements" "SQL Commands"
.SH NAME
UPDATE \- update rows of a table

.SH SYNOPSIS
.sp
.nf
UPDATE [ ONLY ] \fItable\fR SET \fIcolumn\fR = { \fIexpression\fR | DEFAULT } [, ...]
    [ FROM \fIfromlist\fR ]
    [ WHERE \fIcondition\fR ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBUPDATE\fR changes the values of the specified
columns in all rows that satisfy the condition. Only the columns to
be modified need be mentioned in the statement; columns not explicitly
SET retain their previous values.
.PP
By default, \fBUPDATE\fR will update rows in the
specified table and all its subtables. If you wish to only update
the specific table mentioned, you must use the ONLY
clause.
.PP
You must have the UPDATE privilege on the table
to update it, as well as the SELECT
privilege to any table whose values are read in the
\fIexpression\fRs or
\fIcondition\fR.
.SH "PARAMETERS"
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of the table to update.
.TP
\fB\fIcolumn\fB\fR
The name of a column in \fItable\fR.
.TP
\fB\fIexpression\fB\fR
An expression to assign to the column. The expression may use the
old values of this and other columns in the table.
.TP
\fBDEFAULT\fR
Set the column to its default value (which will be NULL if no
specific default expression has been assigned to it).
.TP
\fB\fIfromlist\fB\fR
A list of table expressions, allowing columns from other tables
to appear in the WHERE condition and the update expressions.
.TP
\fB\fIcondition\fB\fR
An expression that returns a value of type \fBboolean\fR.
Only rows for which this expression returns true
will be updated.
.SH "OUTPUTS"
.PP
On successful completion, an \fBUPDATE\fR command returns a command
tag of the form
.sp
.nf
UPDATE \fIcount\fR
.sp
.fi
The \fIcount\fR is the number
of rows updated. If \fIcount\fR is
0, no rows matched the \fIcondition\fR (this is not considered
an error).
.SH "EXAMPLES"
.PP
Change the word Drama to Dramatic in the
column \fBkind\fR of the table films:
.sp
.nf
UPDATE films SET kind = 'Dramatic' WHERE kind = 'Drama';
.sp
.fi
.PP
Adjust temperature entries and reset precipitation to its default
value in one row of the table weather:
.sp
.nf
UPDATE weather SET temp_lo = temp_lo+1, temp_hi = temp_lo+15, prcp = DEFAULT
  WHERE city = 'San Francisco' AND date = '2003-07-03';
.sp
.fi
.SH "COMPATIBILITY"
.PP
This command conforms to the SQL standard. The
FROM clause is a
PostgreSQL extension.
