/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _ACTIVEMQ_COMMANDS_XATRANSACTIONIDTEST_H_
#define _ACTIVEMQ_COMMANDS_XATRANSACTIONIDTEST_H_

#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

namespace activemq {
namespace commands {

    class XATransactionIdTest : public CppUnit::TestFixture {

        CPPUNIT_TEST_SUITE( XATransactionIdTest );
        CPPUNIT_TEST( testConstructor );
        CPPUNIT_TEST( testConstructor2 );
        CPPUNIT_TEST( testEquals );
        CPPUNIT_TEST( testClone );
        CPPUNIT_TEST( testGetFormatId );
        CPPUNIT_TEST( testGetBranchQualifier );
        CPPUNIT_TEST( testGetGlobalTransactionId );
        CPPUNIT_TEST( testGetBranchQualifier1 );
        CPPUNIT_TEST( testGetGlobalTransactionId1 );
        CPPUNIT_TEST_SUITE_END();

    public:

        XATransactionIdTest();
        virtual ~XATransactionIdTest();

        void testConstructor();
        void testConstructor2();
        void testEquals();
        void testClone();
        void testGetFormatId();
        void testGetBranchQualifier();
        void testGetGlobalTransactionId();
        void testGetBranchQualifier1();
        void testGetGlobalTransactionId1();

    };

}}

#endif /* _ACTIVEMQ_COMMANDS_XATRANSACTIONIDTEST_H_ */
