/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common;

import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.NSAwareAttributeMatcher;
import org.apache.axiom.core.NamespaceDeclarationMatcher;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.Semantics;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.NSUtil;
import org.apache.axiom.om.impl.intf.AxiomAttribute;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomSourcedElement;

public final class AxiomSemantics
implements Semantics {
    public static final AxiomSemantics INSTANCE = new AxiomSemantics();
    public static final AttributeMatcher ATTRIBUTE_MATCHER = new NSAwareAttributeMatcher(INSTANCE, false, false);
    public static final AttributeMatcher NAMESPACE_DECLARATION_MATCHER = new NamespaceDeclarationMatcher(INSTANCE);
    public static final ClonePolicy<OMCloneOptions> CLONE_POLICY = new ClonePolicy<OMCloneOptions>(){

        @Override
        public Class<? extends CoreNode> getTargetNodeClass(OMCloneOptions options, CoreNode node) {
            if (options != null && options.isPreserveModel()) {
                return node.coreGetNodeClass();
            }
            if (options != null && options.isCopyOMDataSources() && node instanceof AxiomSourcedElement) {
                return AxiomSourcedElement.class;
            }
            return node.coreGetNodeType().getInterface();
        }

        @Override
        public boolean repairNamespaces(OMCloneOptions options) {
            return true;
        }

        @Override
        public boolean cloneAttributes(OMCloneOptions options) {
            return true;
        }

        @Override
        public boolean cloneChildren(OMCloneOptions options, NodeType nodeType) {
            return true;
        }

        @Override
        public void postProcess(OMCloneOptions options, CoreNode clone) {
            if (clone instanceof AxiomElement && ((AxiomElement)clone).isExpanded()) {
                AxiomElement element = (AxiomElement)clone;
                NSUtil.handleNamespace(element, element.getNamespace(), false, true);
                for (CoreAttribute attr = element.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                    if (!(attr instanceof AxiomAttribute)) continue;
                    NSUtil.handleNamespace(element, ((AxiomAttribute)attr).getNamespace(), true, true);
                }
            }
        }
    };

    private AxiomSemantics() {
    }

    @Override
    public DetachPolicy getDetachPolicy() {
        return DetachPolicy.NEW_DOCUMENT;
    }

    @Override
    public boolean isUseStrictNamespaceLookup() {
        return true;
    }

    @Override
    public boolean isParentNode(NodeType nodeType) {
        return nodeType == NodeType.DOCUMENT || nodeType == NodeType.NS_AWARE_ELEMENT;
    }

    @Override
    public RuntimeException toUncheckedException(CoreModelException ex) {
        return AxiomExceptionTranslator.translate(ex);
    }
}

