/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.sike;

import org.bouncycastle.pqc.crypto.sike.PointProj;
import org.bouncycastle.pqc.crypto.sike.SIKEEngine;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class SIDH {
    private SIKEEngine engine;

    public SIDH(SIKEEngine sIKEEngine) {
        this.engine = sIKEEngine;
    }

    protected void init_basis(long[] lArray, long[][] lArray2, long[][] lArray3, long[][] lArray4) {
        this.engine.fpx.fpcopy(lArray, 0, lArray2[0]);
        this.engine.fpx.fpcopy(lArray, this.engine.params.NWORDS_FIELD, lArray2[1]);
        this.engine.fpx.fpcopy(lArray, 2 * this.engine.params.NWORDS_FIELD, lArray3[0]);
        this.engine.fpx.fpcopy(lArray, 3 * this.engine.params.NWORDS_FIELD, lArray3[1]);
        this.engine.fpx.fpcopy(lArray, 4 * this.engine.params.NWORDS_FIELD, lArray4[0]);
        this.engine.fpx.fpcopy(lArray, 5 * this.engine.params.NWORDS_FIELD, lArray4[1]);
    }

    protected void EphemeralKeyGeneration_B(byte[] byArray, byte[] byArray2) {
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj2 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj3 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj4 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pointProjArray = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        long[][] lArray = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray7 = new long[3][2][this.engine.params.NWORDS_FIELD];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[] lArray8 = new long[this.engine.params.NWORDS_ORDER];
        this.init_basis(this.engine.params.B_gen, lArray, lArray2, lArray3);
        this.init_basis(this.engine.params.A_gen, pointProj2.X, pointProj3.X, pointProj4.X);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj2.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj3.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj4.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray4[0]);
        this.engine.fpx.mp2_add(lArray4, lArray4, lArray4);
        this.engine.fpx.mp2_add(lArray4, lArray4, lArray5);
        this.engine.fpx.mp2_add(lArray4, lArray5, lArray6);
        this.engine.fpx.mp2_add(lArray5, lArray5, lArray4);
        this.engine.fpx.decode_to_digits(byArray, this.engine.params.MSG_BYTES, lArray8, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(lArray, lArray2, lArray3, lArray8, this.engine.params.BOB, pointProj, lArray6);
        n = 0;
        for (int i = 1; i < this.engine.params.MAX_Bob; ++i) {
            while (n < this.engine.params.MAX_Bob - i) {
                pointProjArray[n2] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(pointProj.X, pointProjArray[n2].X);
                this.engine.fpx.fp2copy(pointProj.Z, pointProjArray[n2].Z);
                nArray[n2++] = n;
                int n4 = this.engine.params.strat_Bob[n3++];
                this.engine.isogeny.xTPLe(pointProj, pointProj, lArray5, lArray4, n4);
                n += n4;
            }
            this.engine.isogeny.get_3_isog(pointProj, lArray5, lArray4, lArray7);
            for (int j = 0; j < n2; ++j) {
                this.engine.isogeny.eval_3_isog(pointProjArray[j], lArray7);
            }
            this.engine.isogeny.eval_3_isog(pointProj2, lArray7);
            this.engine.isogeny.eval_3_isog(pointProj3, lArray7);
            this.engine.isogeny.eval_3_isog(pointProj4, lArray7);
            this.engine.fpx.fp2copy(pointProjArray[n2 - 1].X, pointProj.X);
            this.engine.fpx.fp2copy(pointProjArray[n2 - 1].Z, pointProj.Z);
            n = nArray[n2 - 1];
            --n2;
        }
        this.engine.isogeny.get_3_isog(pointProj, lArray5, lArray4, lArray7);
        this.engine.isogeny.eval_3_isog(pointProj2, lArray7);
        this.engine.isogeny.eval_3_isog(pointProj3, lArray7);
        this.engine.isogeny.eval_3_isog(pointProj4, lArray7);
        this.engine.isogeny.inv_3_way(pointProj2.Z, pointProj3.Z, pointProj4.Z);
        this.engine.fpx.fp2mul_mont(pointProj2.X, pointProj2.Z, pointProj2.X);
        this.engine.fpx.fp2mul_mont(pointProj3.X, pointProj3.Z, pointProj3.X);
        this.engine.fpx.fp2mul_mont(pointProj4.X, pointProj4.Z, pointProj4.X);
        this.engine.fpx.fp2_encode(pointProj2.X, byArray2, 0);
        this.engine.fpx.fp2_encode(pointProj3.X, byArray2, this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.fp2_encode(pointProj4.X, byArray2, 2 * this.engine.params.FP2_ENCODED_BYTES);
    }

    protected void EphemeralKeyGeneration_A(byte[] byArray, byte[] byArray2) {
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj2 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj3 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj pointProj4 = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pointProjArray = new PointProj[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][] lArray = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray2 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray7 = new long[3][2][this.engine.params.NWORDS_FIELD];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[this.engine.params.MAX_INT_POINTS_ALICE];
        long[] lArray8 = new long[this.engine.params.NWORDS_ORDER];
        this.init_basis(this.engine.params.A_gen, lArray, lArray2, lArray3);
        this.init_basis(this.engine.params.B_gen, pointProj2.X, pointProj3.X, pointProj4.X);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj2.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj3.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, pointProj4.Z[0]);
        this.engine.fpx.fpcopy(this.engine.params.Montgomery_one, 0, lArray4[0]);
        this.engine.fpx.mp2_add(lArray4, lArray4, lArray4);
        this.engine.fpx.mp2_add(lArray4, lArray4, lArray5);
        this.engine.fpx.mp2_add(lArray4, lArray5, lArray6);
        this.engine.fpx.mp2_add(lArray5, lArray5, lArray4);
        this.engine.fpx.decode_to_digits(byArray, 0, lArray8, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(lArray, lArray2, lArray3, lArray8, this.engine.params.ALICE, pointProj, lArray6);
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            PointProj pointProj5 = new PointProj(this.engine.params.NWORDS_FIELD);
            this.engine.isogeny.xDBLe(pointProj, pointProj5, lArray4, lArray5, this.engine.params.OALICE_BITS - 1);
            this.engine.isogeny.get_2_isog(pointProj5, lArray4, lArray5);
            this.engine.isogeny.eval_2_isog(pointProj2, pointProj5);
            this.engine.isogeny.eval_2_isog(pointProj3, pointProj5);
            this.engine.isogeny.eval_2_isog(pointProj4, pointProj5);
            this.engine.isogeny.eval_2_isog(pointProj, pointProj5);
        }
        n = 0;
        for (int i = 1; i < this.engine.params.MAX_Alice; ++i) {
            while (n < this.engine.params.MAX_Alice - i) {
                pointProjArray[n2] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(pointProj.X, pointProjArray[n2].X);
                this.engine.fpx.fp2copy(pointProj.Z, pointProjArray[n2].Z);
                nArray[n2++] = n;
                int n4 = this.engine.params.strat_Alice[n3++];
                this.engine.isogeny.xDBLe(pointProj, pointProj, lArray4, lArray5, 2 * n4);
                n += n4;
            }
            this.engine.isogeny.get_4_isog(pointProj, lArray4, lArray5, lArray7);
            for (int j = 0; j < n2; ++j) {
                this.engine.isogeny.eval_4_isog(pointProjArray[j], lArray7);
            }
            this.engine.isogeny.eval_4_isog(pointProj2, lArray7);
            this.engine.isogeny.eval_4_isog(pointProj3, lArray7);
            this.engine.isogeny.eval_4_isog(pointProj4, lArray7);
            this.engine.fpx.fp2copy(pointProjArray[n2 - 1].X, pointProj.X);
            this.engine.fpx.fp2copy(pointProjArray[n2 - 1].Z, pointProj.Z);
            n = nArray[n2 - 1];
            --n2;
        }
        this.engine.isogeny.get_4_isog(pointProj, lArray4, lArray5, lArray7);
        this.engine.isogeny.eval_4_isog(pointProj2, lArray7);
        this.engine.isogeny.eval_4_isog(pointProj3, lArray7);
        this.engine.isogeny.eval_4_isog(pointProj4, lArray7);
        this.engine.isogeny.inv_3_way(pointProj2.Z, pointProj3.Z, pointProj4.Z);
        this.engine.fpx.fp2mul_mont(pointProj2.X, pointProj2.Z, pointProj2.X);
        this.engine.fpx.fp2mul_mont(pointProj3.X, pointProj3.Z, pointProj3.X);
        this.engine.fpx.fp2mul_mont(pointProj4.X, pointProj4.Z, pointProj4.X);
        this.engine.fpx.fp2_encode(pointProj2.X, byArray2, 0);
        this.engine.fpx.fp2_encode(pointProj3.X, byArray2, this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.fp2_encode(pointProj4.X, byArray2, 2 * this.engine.params.FP2_ENCODED_BYTES);
    }

    protected void EphemeralSecretAgreement_A(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pointProjArray = new PointProj[this.engine.params.MAX_INT_POINTS_ALICE];
        long[][][] lArray = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray2 = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[this.engine.params.MAX_INT_POINTS_ALICE];
        long[] lArray7 = new long[this.engine.params.NWORDS_ORDER];
        this.engine.fpx.fp2_decode(byArray2, lArray[0], 0);
        this.engine.fpx.fp2_decode(byArray2, lArray[1], this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.fp2_decode(byArray2, lArray[2], 2 * this.engine.params.FP2_ENCODED_BYTES);
        this.engine.isogeny.get_A(lArray[0], lArray[1], lArray[2], lArray6);
        this.engine.fpx.mp_add(this.engine.params.Montgomery_one, this.engine.params.Montgomery_one, lArray5[0], this.engine.params.NWORDS_FIELD);
        this.engine.fpx.mp2_add(lArray6, lArray5, lArray4);
        this.engine.fpx.mp_add(lArray5[0], lArray5[0], lArray5[0], this.engine.params.NWORDS_FIELD);
        this.engine.fpx.decode_to_digits(byArray, 0, lArray7, this.engine.params.SECRETKEY_A_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(lArray[0], lArray[1], lArray[2], lArray7, this.engine.params.ALICE, pointProj, lArray6);
        if (this.engine.params.OALICE_BITS % 2 == 1) {
            PointProj pointProj2 = new PointProj(this.engine.params.NWORDS_FIELD);
            this.engine.isogeny.xDBLe(pointProj, pointProj2, lArray4, lArray5, this.engine.params.OALICE_BITS - 1);
            this.engine.isogeny.get_2_isog(pointProj2, lArray4, lArray5);
            this.engine.isogeny.eval_2_isog(pointProj, pointProj2);
        }
        n4 = 0;
        for (n2 = 1; n2 < this.engine.params.MAX_Alice; ++n2) {
            while (n4 < this.engine.params.MAX_Alice - n2) {
                pointProjArray[n5] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(pointProj.X, pointProjArray[n5].X);
                this.engine.fpx.fp2copy(pointProj.Z, pointProjArray[n5].Z);
                nArray[n5++] = n4;
                n3 = this.engine.params.strat_Alice[n6++];
                this.engine.isogeny.xDBLe(pointProj, pointProj, lArray4, lArray5, 2 * n3);
                n4 += n3;
            }
            this.engine.isogeny.get_4_isog(pointProj, lArray4, lArray5, lArray2);
            for (n = 0; n < n5; ++n) {
                this.engine.isogeny.eval_4_isog(pointProjArray[n], lArray2);
            }
            this.engine.fpx.fp2copy(pointProjArray[n5 - 1].X, pointProj.X);
            this.engine.fpx.fp2copy(pointProjArray[n5 - 1].Z, pointProj.Z);
            n4 = nArray[n5 - 1];
            --n5;
        }
        this.engine.isogeny.get_4_isog(pointProj, lArray4, lArray5, lArray2);
        this.engine.fpx.mp2_add(lArray4, lArray4, lArray4);
        this.engine.fpx.fp2sub(lArray4, lArray5, lArray4);
        this.engine.fpx.fp2add(lArray4, lArray4, lArray4);
        this.engine.isogeny.j_inv(lArray4, lArray5, lArray3);
        this.engine.fpx.fp2_encode(lArray3, byArray3, 0);
    }

    protected void EphemeralSecretAgreement_B(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        PointProj pointProj = new PointProj(this.engine.params.NWORDS_FIELD);
        PointProj[] pointProjArray = new PointProj[this.engine.params.MAX_INT_POINTS_BOB];
        long[][][] lArray = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][][] lArray2 = new long[3][2][this.engine.params.NWORDS_FIELD];
        long[][] lArray3 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray4 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray5 = new long[2][this.engine.params.NWORDS_FIELD];
        long[][] lArray6 = new long[2][this.engine.params.NWORDS_FIELD];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[this.engine.params.MAX_INT_POINTS_BOB];
        long[] lArray7 = new long[this.engine.params.NWORDS_ORDER];
        this.engine.fpx.fp2_decode(byArray2, lArray2[0], 0);
        this.engine.fpx.fp2_decode(byArray2, lArray2[1], this.engine.params.FP2_ENCODED_BYTES);
        this.engine.fpx.fp2_decode(byArray2, lArray2[2], 2 * this.engine.params.FP2_ENCODED_BYTES);
        this.engine.isogeny.get_A(lArray2[0], lArray2[1], lArray2[2], lArray6);
        this.engine.fpx.mp_add(this.engine.params.Montgomery_one, this.engine.params.Montgomery_one, lArray5[0], this.engine.params.NWORDS_FIELD);
        this.engine.fpx.mp2_add(lArray6, lArray5, lArray4);
        this.engine.fpx.mp2_sub_p2(lArray6, lArray5, lArray5);
        this.engine.fpx.decode_to_digits(byArray, this.engine.params.MSG_BYTES, lArray7, this.engine.params.SECRETKEY_B_BYTES, this.engine.params.NWORDS_ORDER);
        this.engine.isogeny.LADDER3PT(lArray2[0], lArray2[1], lArray2[2], lArray7, this.engine.params.BOB, pointProj, lArray6);
        n = 0;
        for (int i = 1; i < this.engine.params.MAX_Bob; ++i) {
            while (n < this.engine.params.MAX_Bob - i) {
                pointProjArray[n2] = new PointProj(this.engine.params.NWORDS_FIELD);
                this.engine.fpx.fp2copy(pointProj.X, pointProjArray[n2].X);
                this.engine.fpx.fp2copy(pointProj.Z, pointProjArray[n2].Z);
                nArray[n2++] = n;
                int n4 = this.engine.params.strat_Bob[n3++];
                this.engine.isogeny.xTPLe(pointProj, pointProj, lArray5, lArray4, n4);
                n += n4;
            }
            this.engine.isogeny.get_3_isog(pointProj, lArray5, lArray4, lArray);
            for (int j = 0; j < n2; ++j) {
                this.engine.isogeny.eval_3_isog(pointProjArray[j], lArray);
            }
            this.engine.fpx.fp2copy(pointProjArray[n2 - 1].X, pointProj.X);
            this.engine.fpx.fp2copy(pointProjArray[n2 - 1].Z, pointProj.Z);
            n = nArray[n2 - 1];
            --n2;
        }
        this.engine.isogeny.get_3_isog(pointProj, lArray5, lArray4, lArray);
        this.engine.fpx.fp2add(lArray4, lArray5, lArray6);
        this.engine.fpx.fp2add(lArray6, lArray6, lArray6);
        this.engine.fpx.fp2sub(lArray4, lArray5, lArray4);
        this.engine.isogeny.j_inv(lArray6, lArray4, lArray3);
        this.engine.fpx.fp2_encode(lArray3, byArray3, 0);
    }
}

