/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.util;

import java.util.Dictionary;
import org.ops4j.lang.NullArgumentException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestUtil.class);

    private ManifestUtil() {
    }

    public static String getHeader(Bundle bundle, String ... keys) {
        Bundle[] bundles;
        NullArgumentException.validateNotNull(bundle, "Bundle");
        BundleContext bundleContext = bundle.getBundleContext();
        NullArgumentException.validateNotNull(bundleContext, "BundleContext");
        Dictionary headers = bundle.getHeaders();
        for (String key : keys) {
            String value = (String)headers.get(key);
            if (value == null) continue;
            return value;
        }
        for (Bundle fragment : bundles = bundleContext.getBundles()) {
            String fragmentHost;
            if (fragment.getState() != 4 || (fragmentHost = (String)fragment.getHeaders().get("Fragment-Host")) == null || !fragmentHost.equals(bundle.getSymbolicName())) continue;
            headers = fragment.getHeaders();
            for (String key : keys) {
                String value = (String)headers.get(key);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public static String extractContextName(Bundle bundle) {
        String contextName = ManifestUtil.getHeader(bundle, "Web-ContextPath", "Webapp-Context");
        if (contextName == null) {
            LOG.debug("No 'Web-ContextPath' or 'Webapp-Context' manifest attribute specified");
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName == null) {
                contextName = String.valueOf(bundle.getBundleId());
                LOG.debug("Using bundle id [{}] as context name", (Object)contextName);
            } else {
                contextName = symbolicName;
                LOG.debug("Using bundle symbolic name [{}] as context name", (Object)contextName);
            }
        }
        if ((contextName = contextName.trim()).startsWith("/")) {
            contextName = contextName.substring(1);
        }
        return contextName;
    }
}

