/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl.methods;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlTypeInstantiator;
import org.apache.brooklyn.camp.brooklyn.spi.creation.EntitySpecConfiguration;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslAccessible;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslUtils;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslComponent;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.methods.DslToStringHelpers;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.parse.WorkflowTransformGet;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityDynamicType;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.persist.DeserializingClassRenamesProvider;
import org.apache.brooklyn.core.objs.AbstractConfigurationSupportInternal;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypePlanTransformer;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonSerializationUtils;
import org.apache.brooklyn.core.sensor.DependentConfiguration;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.workflow.steps.variables.TransformVariableWorkflowStep;
import org.apache.brooklyn.util.collections.Jsonya;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.json.BrooklynObjectsJsonMapper;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.xstream.ObjectWithDefaultStringImplConverter;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.javalang.coerce.TryCoercer;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.StringFunctions;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.yaml.Yamls;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynDslCommon {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynDslCommon.class);
    public static final String PREFIX = "$brooklyn:";
    private static boolean INITIALIZED = false;

    public static synchronized void registerSerializationHooks() {
        BrooklynDslCommon.registerSerializationHooks(false);
    }

    public static synchronized void registerSerializationHooks(boolean forceReinitialization) {
        if (INITIALIZED && !forceReinitialization) {
            return;
        }
        BrooklynJacksonSerializationUtils.JsonDeserializerForCommonBrooklynThings.BROOKLYN_PARSE_DSL_FUNCTION = DslUtils::parseBrooklynDsl;
        BrooklynObjectsJsonMapper.DslToStringSerialization.BROOKLYN_DSL_INTERFACE = BrooklynDslDeferredSupplier.class;
        BrooklynDslCommon.registerSpecCoercionAdapter();
        BrooklynDslCommon.registerWorkflowTransforms();
        INITIALIZED = true;
    }

    private static void registerSpecCoercionAdapter() {
        TypeCoercions.registerAdapter((String)"10-specs", (TryCoercer)new TryCoercer(){

            public <T> Maybe<T> tryCoerce(Object input, TypeToken<T> type) {
                ManagementContext mgmt;
                BiFunction dslParse = BrooklynJacksonSerializationUtils.JsonDeserializerForCommonBrooklynThings.BROOKLYN_PARSE_DSL_FUNCTION;
                if (!EntitySpec.class.isAssignableFrom(type.getRawType()) || dslParse == null) {
                    return null;
                }
                if (!(input instanceof Map)) {
                    return null;
                }
                Entity entity = BrooklynTaskTags.getContextEntity((Task)Tasks.current());
                ManagementContext managementContext = mgmt = entity != null ? ((EntityInternal)entity).getManagementContext() : null;
                if (mgmt == null) {
                    return null;
                }
                Map m = (Map)input;
                if (!m.containsKey("type") && !m.containsKey(BeanWithTypePlanTransformer.TYPE_UNAMBIGUOUS_KEY)) {
                    return null;
                }
                try {
                    BrooklynClassLoadingContext loader = RegisteredTypes.getClassLoadingContext((ManagementContext)mgmt, (Entity)entity);
                    Object spec = DslUtils.transformSpecialFlags(mgmt, loader, dslParse.apply(mgmt, MutableMap.of((Object)"$brooklyn:entitySpec", (Object)input)));
                    if (spec instanceof Supplier) {
                        spec = ((Supplier)spec).get();
                    }
                    return Maybe.of((Object)spec);
                }
                catch (Exception e) {
                    return Maybe.absent((Throwable)e);
                }
            }
        });
    }

    public static void registerWorkflowTransforms() {
        TransformVariableWorkflowStep.registerTransformation((String)"get", () -> new WorkflowTransformGet());
    }

    @DslAccessible
    public static DslComponent self() {
        return new DslComponent(DslComponent.Scope.THIS);
    }

    @DslAccessible
    public static DslComponent entity(Object id) {
        return DslComponent.newInstance(DslComponent.Scope.GLOBAL, id);
    }

    @DslAccessible
    public static DslComponent parent() {
        return new DslComponent(DslComponent.Scope.PARENT);
    }

    @DslAccessible
    public static DslComponent child(Object id) {
        return DslComponent.newInstance(DslComponent.Scope.CHILD, id);
    }

    @DslAccessible
    public static DslComponent sibling(Object id) {
        return DslComponent.newInstance(DslComponent.Scope.SIBLING, id);
    }

    @DslAccessible
    public static DslComponent descendant(Object id) {
        return DslComponent.newInstance(DslComponent.Scope.DESCENDANT, id);
    }

    @DslAccessible
    public static DslComponent ancestor(Object id) {
        return DslComponent.newInstance(DslComponent.Scope.ANCESTOR, id);
    }

    @DslAccessible
    public static DslComponent root() {
        return new DslComponent(DslComponent.Scope.ROOT);
    }

    @DslAccessible
    public static DslComponent scopeRoot() {
        return new DslComponent(DslComponent.Scope.SCOPE_ROOT);
    }

    @DslAccessible
    public static DslComponent component(Object id) {
        return BrooklynDslCommon.component("global", id);
    }

    @DslAccessible
    public static DslComponent component(String scope, Object id) {
        if (!DslComponent.Scope.isValid(scope)) {
            throw new IllegalArgumentException(scope + " is not a valid scope");
        }
        return DslComponent.newInstance(DslComponent.Scope.fromString(scope), id);
    }

    @DslAccessible
    public static DslComponent application(Object id) {
        return DslComponent.newInstance(DslComponent.Scope.APPLICATIONS, id);
    }

    @DslAccessible
    public static DslComponent member(Object id) {
        return DslComponent.newInstance(DslComponent.Scope.MEMBERS, id);
    }

    @DslAccessible
    public static BrooklynDslDeferredSupplier<?> config(Object keyName) {
        return new DslComponent(DslComponent.Scope.THIS, "").config(keyName);
    }

    @DslAccessible
    public static BrooklynDslDeferredSupplier<?> config(BrooklynObjectInternal obj, Object keyName) {
        return new DslBrooklynObjectConfigSupplier(obj, keyName);
    }

    @DslAccessible
    public static BrooklynDslDeferredSupplier<?> attributeWhenReady(Object sensorName) {
        return new DslComponent(DslComponent.Scope.THIS, "").attributeWhenReady(sensorName);
    }

    @DslAccessible
    public static BrooklynDslDeferredSupplier<?> entityId() {
        return new DslComponent(DslComponent.Scope.THIS, "").entityId();
    }

    @DslAccessible
    public static BrooklynDslDeferredSupplier<Sensor<?>> sensor(Object sensorName) {
        return new DslComponent(DslComponent.Scope.THIS, "").sensor(sensorName);
    }

    @DslAccessible
    public static Sensor<?> sensor(String clazzName, String sensorName) {
        try {
            Sensor sensor;
            String mappedClazzName = DeserializingClassRenamesProvider.INSTANCE.findMappedName(clazzName);
            Class clazz = new ClassLoaderUtils(BrooklynDslCommon.class).loadClass(mappedClazzName);
            if (Entity.class.isAssignableFrom(clazz)) {
                sensor = new EntityDynamicType(clazz).getSensor(sensorName);
            } else {
                Map sensors = EntityDynamicType.findSensors((Class)clazz, null);
                sensor = (Sensor)sensors.get(sensorName);
            }
            if (sensor == null) {
                throw new IllegalArgumentException("Sensor " + sensorName + " not found on class " + clazzName);
            }
            return sensor;
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @DslAccessible
    public static BrooklynDslDeferredSupplier<?> location() {
        return new DslComponent(DslComponent.Scope.THIS, "").location();
    }

    @DslAccessible
    public static BrooklynDslDeferredSupplier<?> location(Object index) {
        return new DslComponent(DslComponent.Scope.THIS, "").location(index);
    }

    @DslAccessible
    public static EntitySpecConfiguration entitySpec(Map<String, Object> arguments) {
        return new EntitySpecConfiguration(arguments);
    }

    @DslAccessible
    public static Object object(Map<String, Object> arguments) {
        Class type;
        ConfigBag config = ConfigBag.newInstance(arguments);
        String typeName = (String)BrooklynYamlTypeInstantiator.InstantiatorFromKey.extractTypeName("object", config).orNull();
        List constructorArgs = (List)config.getStringKeyMaybe("constructor.args").or((Object)ImmutableList.of());
        String factoryMethodName = (String)config.getStringKeyMaybe("factoryMethod.name").orNull();
        List factoryMethodArgs = (List)config.getStringKeyMaybe("factoryMethod.args").or((Object)ImmutableList.of());
        Map objectFields = (Map)config.getStringKeyMaybe("object.fields").or((Object)MutableMap.of());
        Map brooklynConfig = (Map)config.getStringKeyMaybe("brooklyn.config").or((Object)MutableMap.of());
        boolean deferred = (Boolean)TypeCoercions.coerce((Object)config.getStringKeyMaybe("deferred").or((Object)Boolean.FALSE), Boolean.class);
        String mappedTypeName = DeserializingClassRenamesProvider.INSTANCE.findMappedName(typeName);
        try {
            type = new ClassLoaderUtils(BrooklynDslCommon.class).loadClass(mappedTypeName);
        }
        catch (ClassNotFoundException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No local class " + typeName + " for DSL 'object'; assuming it is a registered type; will defer its loading");
            }
            return new DslObject(mappedTypeName, (List<Object>)constructorArgs, (Map<String, Object>)objectFields, (Map<String, Object>)brooklynConfig);
        }
        if (!deferred && DslUtils.resolved(constructorArgs) && DslUtils.resolved(factoryMethodArgs) && DslUtils.resolved(objectFields.values()) && DslUtils.resolved(brooklynConfig.values())) {
            if (factoryMethodName == null) {
                return DslObject.create(type, constructorArgs, objectFields, brooklynConfig);
            }
            return DslObject.create(type, factoryMethodName, factoryMethodArgs, objectFields, brooklynConfig);
        }
        if (factoryMethodName == null) {
            return new DslObject(type, (List<Object>)constructorArgs, (Map<String, Object>)objectFields, (Map<String, Object>)brooklynConfig);
        }
        return new DslObject(type, factoryMethodName, (List<Object>)factoryMethodArgs, (Map<String, Object>)objectFields, (Map<String, Object>)brooklynConfig);
    }

    @DslAccessible
    public static Object object(String argumentsMapAsYamlStringOrShorthand) {
        MutableList argL;
        Object arg = Yamls.parseAll((String)argumentsMapAsYamlStringOrShorthand).iterator().next();
        if (arg instanceof Map) {
            return BrooklynDslCommon.object((Map)arg);
        }
        if (arg instanceof Collection && (argL = MutableList.copyOf((Iterable)((Collection)arg))).size() >= 1) {
            return BrooklynDslCommon.object((Map<String, Object>)MutableMap.of((Object)"type", argL.remove(0), (Object)"constructor.args", (Object)argL));
        }
        if (arg instanceof String) {
            return BrooklynDslCommon.object((Map<String, Object>)MutableMap.of((Object)"type", arg, (Object)"constructor.args", Collections.emptyList()));
        }
        throw new IllegalArgumentException("Argument to object should be a map, or shorthand type name as string, or type name and constructor arguments as list");
    }

    @DslAccessible
    public static Object literal(Object expression) {
        return new DslLiteral(expression);
    }

    @DslAccessible
    public static Object urlEncode(Object arg) {
        if (DslUtils.resolved(arg)) {
            return arg == null ? null : Urls.encode((String)arg.toString());
        }
        return new DslUrlEncode(arg);
    }

    @DslAccessible
    public static Object formatString(Object pattern, Object ... args) {
        if (DslUtils.resolved(Lists.asList((Object)pattern, (Object[])args))) {
            return String.format(String.valueOf(pattern), args);
        }
        return new DslFormatString(pattern, args);
    }

    @DslAccessible
    public static Object regexReplacement(Object source, Object pattern, Object replacement) {
        if (DslUtils.resolved(Arrays.asList(source, pattern, replacement))) {
            return new Functions.RegexReplacer(String.valueOf(pattern), String.valueOf(replacement)).apply(String.valueOf(source));
        }
        return new DslRegexReplacement(source, pattern, replacement);
    }

    @DslAccessible
    public static DslExternal external(String providerName, String key) {
        return new DslExternal(providerName, key);
    }

    public static Object template(Object template) {
        return new DslComponent(DslComponent.Scope.THIS, "").template(template);
    }

    public static Object template(Object template, Map<?, ?> substitutions) {
        return new DslComponent(DslComponent.Scope.THIS, "").template(template, substitutions);
    }

    static {
        BrooklynDslCommon.registerSerializationHooks();
    }

    public static class DslFacades {
        @DslAccessible
        public static Object wrap(Entity entity) {
            return DslComponent.newInstance(DslComponent.Scope.GLOBAL, new EntitySupplier(entity.getId()));
        }

        private static class EntitySupplier
        implements DeferredSupplier<Entity>,
        ImmediateSupplier<Entity> {
            private String entityId;

            public EntitySupplier(String entityId) {
                this.entityId = entityId;
            }

            @JsonIgnore
            public Maybe<Entity> getImmediately() {
                EntityInternal entity = this.entity();
                if (entity == null) {
                    return Maybe.absent((String)"No entity available");
                }
                Entity targetEntity = entity.getManagementContext().getEntityManager().getEntity(this.entityId);
                return Maybe.of((Object)targetEntity);
            }

            public Entity get() {
                return (Entity)this.getImmediately().orNull();
            }

            private EntityInternal entity() {
                return (EntityInternal)BrooklynTaskTags.getTargetOrContextEntity((Task)Tasks.current());
            }
        }
    }

    public static class Functions {
        @DslAccessible
        public static Object regexReplacement(Object pattern, Object replacement) {
            if (DslUtils.resolved(pattern, replacement)) {
                return new StringFunctions.RegexReplacer(String.valueOf(pattern), String.valueOf(replacement));
            }
            return new DslRegexReplacer(pattern, replacement);
        }

        protected static class DslRegexReplacer
        extends BrooklynDslDeferredSupplier<Function<String, String>> {
            private static final long serialVersionUID = -2900037495440842269L;
            private Object pattern;
            private Object replacement;

            public DslRegexReplacer(Object pattern, Object replacement) {
                this.pattern = pattern;
                this.replacement = replacement;
            }

            @JsonIgnore
            public Maybe<Function<String, String>> getImmediately() {
                return DependentConfiguration.regexReplacementImmediately((Object)this.pattern, (Object)this.replacement);
            }

            @Override
            public Task<Function<String, String>> newTask() {
                return DependentConfiguration.regexReplacement((Object)this.pattern, (Object)this.replacement);
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{this.pattern, this.replacement});
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                DslRegexReplacer that = (DslRegexReplacer)DslRegexReplacer.class.cast(obj);
                return Objects.equal((Object)this.pattern, (Object)that.pattern) && Objects.equal((Object)this.replacement, (Object)that.replacement);
            }

            public String toString() {
                return DslToStringHelpers.fn("function.regexReplace", this.pattern, this.replacement);
            }
        }

        @Deprecated
        public static class RegexReplacer
        extends StringFunctions.RegexReplacer {
            public RegexReplacer(String pattern, String replacement) {
                super(pattern, replacement);
            }
        }
    }

    public static final class DslExternal
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = -3860334240490397057L;
        private final String providerName;
        private final String key;

        public DslExternal(String providerName, String key) {
            this.providerName = providerName;
            this.key = key;
        }

        public String getProviderName() {
            return this.providerName;
        }

        public String getKey() {
            return this.key;
        }

        @JsonIgnore
        public final Maybe<Object> getImmediately() {
            ManagementContextInternal managementContext = DslExternal.managementContext();
            return Maybe.of((Object)managementContext.getExternalConfigProviderRegistry().getConfig(this.providerName, this.key));
        }

        @Override
        public Task<Object> newTask() {
            return Tasks.builder().displayName("resolving external configuration: '" + this.key + "' from provider '" + this.providerName + "'").dynamic(false).body((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return this.getImmediately().get();
                }
            }).build();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.providerName, this.key});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslExternal that = (DslExternal)DslExternal.class.cast(obj);
            return Objects.equal((Object)this.providerName, (Object)that.providerName) && Objects.equal((Object)this.key, (Object)that.key);
        }

        public String toString() {
            return DslToStringHelpers.fn("external", this.providerName, this.key);
        }
    }

    public static class DslObject
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = 8878388748085419L;
        private final String typeName;
        private final String factoryMethodName;
        private final Class<?> type;
        private final List<Object> constructorArgs;
        private final List<Object> factoryMethodArgs;
        private final Map<String, Object> fields;
        private final Map<String, Object> config;

        public DslObject(String typeName, List<Object> constructorArgs, Map<String, Object> fields, Map<String, Object> config) {
            this.typeName = (String)Preconditions.checkNotNull((Object)typeName, (Object)"typeName");
            this.type = null;
            this.constructorArgs = (List)Preconditions.checkNotNull(constructorArgs, (Object)"constructorArgs");
            this.factoryMethodName = null;
            this.factoryMethodArgs = ImmutableList.of();
            this.fields = MutableMap.copyOf(fields);
            this.config = MutableMap.copyOf(config);
        }

        public DslObject(Class<?> type, List<Object> constructorArgs, Map<String, Object> fields, Map<String, Object> config) {
            this.typeName = null;
            this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
            this.constructorArgs = (List)Preconditions.checkNotNull(constructorArgs, (Object)"constructorArgs");
            this.factoryMethodName = null;
            this.factoryMethodArgs = ImmutableList.of();
            this.fields = MutableMap.copyOf(fields);
            this.config = MutableMap.copyOf(config);
        }

        public DslObject(String typeName, String factoryMethodName, List<Object> factoryMethodArgs, Map<String, Object> fields, Map<String, Object> config) {
            this.typeName = (String)Preconditions.checkNotNull((Object)typeName, (Object)"typeName");
            this.type = null;
            this.constructorArgs = ImmutableList.of();
            this.factoryMethodName = factoryMethodName;
            this.factoryMethodArgs = (List)Preconditions.checkNotNull(factoryMethodArgs, (Object)"factoryMethodArgs");
            this.fields = MutableMap.copyOf(fields);
            this.config = MutableMap.copyOf(config);
        }

        public DslObject(Class<?> type, String factoryMethodName, List<Object> factoryMethodArgs, Map<String, Object> fields, Map<String, Object> config) {
            this.typeName = null;
            this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
            this.constructorArgs = ImmutableList.of();
            this.factoryMethodName = factoryMethodName;
            this.factoryMethodArgs = (List)Preconditions.checkNotNull(factoryMethodArgs, (Object)"factoryMethodArgs");
            this.fields = MutableMap.copyOf(fields);
            this.config = MutableMap.copyOf(config);
        }

        @JsonIgnore
        public Maybe<Object> getImmediately() {
            Class<?> clazz = this.getOrLoadType();
            final ExecutionContext executionContext = DslObject.entity().getExecutionContext();
            Function<Object, Object> resolver = new Function<Object, Object>(){

                public Object apply(Object value) {
                    Maybe result = Tasks.resolving((Object)value, Object.class).context(executionContext).deep().immediately(true).getMaybe();
                    if (result.isAbsent()) {
                        throw new ImmediateSupplier.ImmediateValueNotAvailableException();
                    }
                    return result.get();
                }
            };
            try {
                MutableMap resolvedFields = MutableMap.copyOf((Map)Maps.transformValues(this.fields, (Function)resolver));
                MutableMap resolvedConfig = MutableMap.copyOf((Map)Maps.transformValues(this.config, (Function)resolver));
                MutableList resolvedConstructorArgs = MutableList.copyOf((Iterable)Lists.transform(this.constructorArgs, (Function)resolver));
                MutableList resolvedFactoryMethodArgs = MutableList.copyOf((Iterable)Lists.transform(this.factoryMethodArgs, (Function)resolver));
                Object result = this.factoryMethodName == null ? DslObject.create(clazz, resolvedConstructorArgs, resolvedFields, resolvedConfig) : DslObject.create(clazz, this.factoryMethodName, resolvedFactoryMethodArgs, resolvedFields, resolvedConfig);
                return Maybe.of(result);
            }
            catch (ImmediateSupplier.ImmediateValueNotAvailableException e) {
                return Maybe.absent((Throwable)e);
            }
        }

        @Override
        public Task<Object> newTask() {
            Class<?> clazz = this.getOrLoadType();
            final ExecutionContext executionContext = DslObject.entity().getExecutionContext();
            Function<Object, Object> resolver = new Function<Object, Object>(){

                public Object apply(Object value) {
                    try {
                        return Tasks.resolveDeepValueWithoutCoercion((Object)value, (ExecutionContext)executionContext);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
            };
            return Tasks.builder().displayName("building instance of '" + clazz + "'").tag((Object)"TRANSIENT").dynamic(false).body((Callable)new Callable<Object>((Function)resolver, clazz){
                final /* synthetic */ Function val$resolver;
                final /* synthetic */ Class val$clazz;
                {
                    this.val$resolver = function;
                    this.val$clazz = clazz;
                }

                @Override
                public Object call() throws Exception {
                    MutableMap resolvedFields = MutableMap.copyOf((Map)Maps.transformValues((Map)fields, (Function)this.val$resolver));
                    MutableMap resolvedConfig = MutableMap.copyOf((Map)Maps.transformValues((Map)config, (Function)this.val$resolver));
                    MutableList resolvedConstructorArgs = MutableList.copyOf((Iterable)Lists.transform((List)constructorArgs, (Function)this.val$resolver));
                    MutableList resolvedFactoryMethodArgs = MutableList.copyOf((Iterable)Lists.transform((List)factoryMethodArgs, (Function)this.val$resolver));
                    if (factoryMethodName == null) {
                        return DslObject.create(this.val$clazz, resolvedConstructorArgs, resolvedFields, resolvedConfig);
                    }
                    return DslObject.create(this.val$clazz, factoryMethodName, resolvedFactoryMethodArgs, resolvedFields, resolvedConfig);
                }
            }).build();
        }

        @JsonIgnore
        protected Class<?> getOrLoadType() {
            Class type = this.type;
            if (type == null) {
                EntityInternal entity = DslObject.entity();
                try {
                    Object inst;
                    if (entity == null) {
                        throw new IllegalStateException("Cannot invoke without a Task running the context of an entity");
                    }
                    RegisteredType rt = DslObject.managementContext().getTypeRegistry().get(this.typeName, RegisteredTypeLoadingContexts.loader((BrooklynClassLoadingContext)RegisteredTypes.getClassLoadingContext((Entity)entity)));
                    if (rt != null && (inst = DslObject.managementContext().getTypeRegistry().create(rt, null, null)) != null) {
                        return inst.getClass();
                    }
                    type = new ClassLoaderUtils(BrooklynDslCommon.class, (Entity)entity).loadClass(this.typeName);
                }
                catch (ClassNotFoundException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            return type;
        }

        public static <T> T create(Class<T> type, List<?> constructorArgs, Map<String, ?> fields, Map<String, ?> config) {
            try {
                Object bean = Reflections.invokeConstructorFromArgs(type, (Object[])constructorArgs.toArray()).get();
                BeanUtils.populate((Object)bean, fields);
                if (config.size() > 0) {
                    if (bean instanceof Configurable) {
                        ConfigBag configBag = ConfigBag.newInstance(config);
                        FlagUtils.setFieldsFromFlags((Object)bean, (ConfigBag)configBag);
                        FlagUtils.setAllConfigKeys((Configurable)((Configurable)bean), (ConfigBag)configBag, (boolean)true);
                    } else {
                        LOG.warn("While building object, type " + type + " is not 'Configurable'; cannot apply supplied config (continuing)");
                    }
                }
                return (T)bean;
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public static Object create(Class<?> type, String factoryMethodName, List<?> factoryMethodArgs, Map<String, ?> fields, Map<String, ?> config) {
            try {
                Optional coercer = Optional.of((Object)TypeCoercions.asTypeCoercer());
                Object bean = Reflections.invokeMethodFromArgs(type, (String)factoryMethodName, factoryMethodArgs, (boolean)false, (Optional)coercer).get();
                BeanUtils.populate((Object)bean, fields);
                if (config.size() > 0) {
                    if (bean instanceof Configurable) {
                        ConfigBag configBag = ConfigBag.newInstance(config);
                        FlagUtils.setFieldsFromFlags((Object)bean, (ConfigBag)configBag);
                        FlagUtils.setAllConfigKeys((Configurable)((Configurable)bean), (ConfigBag)configBag, (boolean)true);
                    } else {
                        LOG.warn("While building object via factory method '" + factoryMethodName + "', type " + (bean == null ? "<null>" : bean.getClass()) + " is not 'Configurable'; cannot apply supplied config (continuing)");
                    }
                }
                return bean;
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.type, this.fields, this.config});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslObject that = (DslObject)DslObject.class.cast(obj);
            return Objects.equal(this.type, that.type) && Objects.equal(this.fields, that.fields) && Objects.equal(this.config, that.config);
        }

        public String toString() {
            String arg;
            if (this.dsl instanceof String && Strings.isNonBlank((CharSequence)((String)this.dsl))) {
                return (String)this.dsl;
            }
            String string = arg = this.type != null ? this.type.getName() : this.typeName;
            if (!this.constructorArgs.isEmpty()) {
                arg = MutableList.of((Object)arg).appendAll(this.constructorArgs).toString();
            }
            return DslToStringHelpers.fn("object", arg);
        }
    }

    @Deprecated
    private static class FormatString
    extends DslFormatString {
        public FormatString(Object pattern, Object[] args) {
            super(pattern, args);
        }
    }

    public static class DslRegexReplacement
    extends BrooklynDslDeferredSupplier<String> {
        private static final long serialVersionUID = 737189899361183341L;
        private Object source;
        private Object pattern;
        private Object replacement;

        public DslRegexReplacement(Object source, Object pattern, Object replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.source = source;
        }

        public Object getSource() {
            return this.source;
        }

        public Object getPattern() {
            return this.pattern;
        }

        public Object getReplacement() {
            return this.replacement;
        }

        @JsonIgnore
        public Maybe<String> getImmediately() {
            return DependentConfiguration.regexReplacementImmediately((Object)this.source, (Object)this.pattern, (Object)this.replacement);
        }

        @Override
        public Task<String> newTask() {
            return DependentConfiguration.regexReplacement((Object)this.source, (Object)this.pattern, (Object)this.replacement);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.source, this.pattern, this.replacement});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslRegexReplacement that = (DslRegexReplacement)DslRegexReplacement.class.cast(obj);
            return Objects.equal((Object)this.pattern, (Object)that.pattern) && Objects.equal((Object)this.replacement, (Object)that.replacement) && Objects.equal((Object)this.source, (Object)that.source);
        }

        public String toString() {
            return DslToStringHelpers.fn("regexReplace", this.source, this.pattern, this.replacement);
        }
    }

    public static class DslFormatString
    extends BrooklynDslDeferredSupplier<String> {
        private static final long serialVersionUID = -4849297712650560863L;
        private final Object pattern;
        private final Object[] args;

        public DslFormatString(Object pattern, Object ... args) {
            this.pattern = pattern;
            this.args = args;
        }

        public Object getPattern() {
            return this.pattern;
        }

        public Object[] getArgs() {
            return this.args;
        }

        @JsonIgnore
        public final Maybe<String> getImmediately() {
            return DependentConfiguration.formatStringImmediately((Object)this.pattern, (Object[])this.args);
        }

        @Override
        public Task<String> newTask() {
            return DependentConfiguration.formatString((Object)this.pattern, (Object[])this.args);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.pattern, this.args});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslFormatString that = (DslFormatString)DslFormatString.class.cast(obj);
            return Objects.equal((Object)this.pattern, (Object)that.pattern) && Arrays.deepEquals(this.args, that.args);
        }

        public String toString() {
            return DslToStringHelpers.fn("formatString", MutableList.builder().add(this.pattern).addAll(this.args).build());
        }
    }

    protected static class DslUrlEncode
    extends BrooklynDslDeferredSupplier<String> {
        private static final long serialVersionUID = -4849297712650560863L;
        private final Object arg;

        public DslUrlEncode(Object arg) {
            this.arg = arg;
        }

        @JsonIgnore
        public final Maybe<String> getImmediately() {
            return DependentConfiguration.urlEncodeImmediately((Object)this.arg);
        }

        @Override
        public Task<String> newTask() {
            return DependentConfiguration.urlEncode((Object)this.arg);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.arg});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslUrlEncode that = (DslUrlEncode)DslUrlEncode.class.cast(obj);
            return Objects.equal((Object)this.arg, (Object)that.arg);
        }

        public String toString() {
            return "$brooklyn:urlEncode(" + this.arg + ")";
        }
    }

    public static final class DslLiteral
    extends BrooklynDslDeferredSupplier<Object> {
        final String literalString;
        final String literalObjectJson;

        private DslLiteral() {
            this(null);
        }

        public DslLiteral(Object input) {
            this.literalString = input instanceof String ? (String)input : null;
            this.literalObjectJson = input == null || input instanceof String ? null : Jsonya.render((Object)input);
        }

        public String getLiteralObjectJson() {
            return this.literalObjectJson;
        }

        public String getLiteralString() {
            return this.literalString;
        }

        @Override
        public Task<Object> newTask() {
            return Tasks.builder().displayName("DSL literal value").tag((Object)"TRANSIENT").dynamic(false).body(() -> this.getImmediately().get()).build();
        }

        @JsonIgnore
        public Maybe<Object> getImmediately() {
            return Maybe.ofAllowingNull((Object)(this.literalObjectJson != null ? Yamls.parseAll((String)this.literalObjectJson).iterator().next() : this.literalString));
        }

        public String toString() {
            return "$brooklyn:literal(" + (this.literalString != null ? StringEscapes.JavaStringEscapes.wrapJavaString((String)this.literalString) : this.literalObjectJson) + ")";
        }
    }

    public static class DslBrooklynObjectConfigSupplier
    extends BrooklynDslDeferredSupplier<Object> {
        private static final long serialVersionUID = -2378555915585603381L;
        private BrooklynObjectInternal obj;
        @XStreamConverter(value=ObjectWithDefaultStringImplConverter.class)
        private Object keyName;

        public DslBrooklynObjectConfigSupplier(BrooklynObjectInternal obj, Object keyName) {
            Preconditions.checkNotNull((Object)obj, (Object)"obj");
            Preconditions.checkNotNull((Object)keyName, (Object)"keyName");
            this.obj = obj;
            this.keyName = keyName;
        }

        public BrooklynObjectInternal getObj() {
            return this.obj;
        }

        public Object getKeyName() {
            return this.keyName;
        }

        protected String resolveKeyName(boolean immediately) {
            if (this.keyName instanceof String) {
                return (String)this.keyName;
            }
            return (String)Tasks.resolving((Object)this.keyName).as(String.class).context(DslComponent.findExecutionContext(this)).immediately(immediately).description("Resolving key name from " + this.keyName).get();
        }

        @JsonIgnore
        public Maybe<Object> getImmediately() {
            if (this.obj instanceof Entity) {
                Preconditions.checkState((boolean)DslBrooklynObjectConfigSupplier.entity().getApplicationId().equals(((Entity)this.obj).getApplicationId()));
            }
            String keyNameS = this.resolveKeyName(true);
            ConfigKey key = ConfigKeys.newConfigKey(Object.class, (String)keyNameS);
            Maybe result = ((AbstractConfigurationSupportInternal)this.obj.config()).getNonBlocking(key, true);
            return Maybe.cast((Maybe)result);
        }

        @Override
        public Task<Object> newTask() {
            return Tasks.builder().displayName("retrieving config for " + this.keyName + " on " + this.obj).tag((Object)"TRANSIENT").dynamic(false).body((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    String keyNameS = this.resolveKeyName(true);
                    ConfigKey key = ConfigKeys.newConfigKey(Object.class, (String)keyNameS);
                    return obj.getConfig(key);
                }
            }).build();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.obj, this.keyName});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DslBrooklynObjectConfigSupplier that = (DslBrooklynObjectConfigSupplier)DslBrooklynObjectConfigSupplier.class.cast(obj);
            return Objects.equal((Object)this.obj, (Object)that.obj) && Objects.equal((Object)this.keyName, (Object)that.keyName);
        }

        public String toString() {
            return DslToStringHelpers.concat(DslToStringHelpers.internal(this.obj), ".", DslToStringHelpers.fn("config", this.keyName));
        }
    }
}

