/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl.parse;

import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.parse.FunctionWithArgs;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.parse.PropertyAccess;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.parse.QuotedString;
import org.apache.brooklyn.util.collections.MutableList;

public class DslParser {
    private final String expression;
    int index = -1;

    public DslParser(String expression) {
        this.expression = expression;
    }

    public synchronized Object parse() {
        if (this.index >= 0) {
            throw new IllegalStateException("Parser can only be used once");
        }
        ++this.index;
        Object result = this.next();
        if (this.index < this.expression.length()) {
            throw new IllegalStateException("Unexpected character at position " + this.index + " in " + this.expression);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object next() {
        String fn;
        boolean isProperty;
        int start = this.index;
        boolean bl = isProperty = this.index > 0 && this.expression.charAt(this.index - 1) == '[' || this.index > 1 && this.expression.charAt(this.index - 1) == '\"' && this.expression.charAt(this.index - 2) == '[';
        if (!isProperty) {
            this.skipWhitespace();
            if (this.index >= this.expression.length()) {
                throw new IllegalStateException("Unexpected end of expression to parse, looking for content since position " + start);
            }
            if (this.expression.charAt(this.index) == '\"') {
                int stringStart = this.index++;
                while (true) {
                    if (this.index >= this.expression.length()) {
                        throw new IllegalStateException("Unexpected end of expression to parse, looking for close quote since position " + stringStart);
                    }
                    char c = this.expression.charAt(this.index);
                    if (c == '\"') break;
                    if (c == '\\') {
                        ++this.index;
                    }
                    ++this.index;
                }
                ++this.index;
                return new QuotedString(this.expression.substring(stringStart, this.index));
            }
        }
        MutableList result = new MutableList();
        int fnStart = this.index;
        boolean bl2 = isProperty = this.expression.charAt(fnStart) == '[';
        if (!isProperty) {
            char c;
            while (this.index < this.expression.length() && (Character.isJavaIdentifierPart(c = this.expression.charAt(this.index)) || c == ':' || c == '.' && this.expression.substring(0, this.index).endsWith("function"))) {
                ++this.index;
            }
        }
        String string = fn = isProperty ? "" : this.expression.substring(fnStart, this.index);
        if (fn.length() == 0 && !isProperty) {
            throw new IllegalStateException("Expected a function name or double-quoted string at position " + start);
        }
        this.skipWhitespace();
        if (this.index >= this.expression.length() || this.expression.charAt(this.index) != '(' && this.expression.charAt(this.index) != '[') return new PropertyAccess(fn);
        int parenStart = this.index;
        MutableList args = new MutableList();
        if (this.expression.charAt(this.index) == '[') {
            if (!fn.isEmpty()) {
                return new PropertyAccess(fn);
            }
            if (this.expression.charAt(this.index + 1) == '\"') {
                ++this.index;
            }
        }
        ++this.index;
        while (true) {
            this.skipWhitespace();
            if (this.index >= this.expression.length()) {
                throw new IllegalStateException("Unexpected end of arguments to function '" + fn + "', no close parenthesis matching character at position " + parenStart);
            }
            char c = this.expression.charAt(this.index);
            if (isProperty && c == '\"') {
                ++this.index;
                break;
            }
            if (c == ')' || c == ']') break;
            if (c == ',') {
                if (args.isEmpty()) {
                    throw new IllegalStateException("Invalid character at position" + this.index);
                }
                ++this.index;
            } else if (!args.isEmpty() && !isProperty) {
                throw new IllegalStateException("Expected , before position" + this.index);
            }
            args.add(this.next());
        }
        if (fn.isEmpty()) {
            Object arg = args.get(0);
            if (arg instanceof PropertyAccess) {
                result.add(arg);
            } else if (arg instanceof FunctionWithArgs) {
                FunctionWithArgs holder = (FunctionWithArgs)arg;
                if (holder.getArgs() != null && !holder.getArgs().isEmpty()) throw new IllegalStateException("Expected empty FunctionWithArgs - arguments present!");
                result.add(new PropertyAccess(holder.getFunction()));
            } else {
                result.add(new PropertyAccess(arg));
            }
        } else {
            result.add(new FunctionWithArgs(fn, (List<Object>)args));
        }
        ++this.index;
        while (true) {
            Object next;
            this.skipWhitespace();
            if (this.index >= this.expression.length()) {
                return result;
            }
            char c = this.expression.charAt(this.index);
            if (c == '.') {
                int chainStart = this.index++;
                next = this.next();
                if (next instanceof List) {
                    result.addAll((Collection)next);
                    continue;
                }
                if (!(next instanceof PropertyAccess)) throw new IllegalStateException("Expected functions following position " + chainStart);
                result.add(next);
                continue;
            }
            if (c != '[') return result;
            int selectorsStart = this.index;
            next = this.next();
            if (!(next instanceof List)) throw new IllegalStateException("Expected property selectors following position " + selectorsStart);
            result.addAll((Collection)next);
            this.skipWhitespace();
            if (this.index >= this.expression.length()) return result;
        }
    }

    private void skipWhitespace() {
        while (this.index < this.expression.length() && Character.isWhitespace(this.expression.charAt(this.index))) {
            ++this.index;
        }
    }
}

