/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.policy.v1beta1.PodDisruptionBudgetStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodDisruptionBudgetStatusFluent<A extends PodDisruptionBudgetStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private Integer currentHealthy;
    private Integer desiredHealthy;
    private Map<String, String> disruptedPods;
    private Integer disruptionsAllowed;
    private Integer expectedPods;
    private Long observedGeneration;
    private Map<String, Object> additionalProperties;

    public PodDisruptionBudgetStatusFluent() {
    }

    public PodDisruptionBudgetStatusFluent(PodDisruptionBudgetStatus instance) {
        PodDisruptionBudgetStatus podDisruptionBudgetStatus = instance = instance != null ? instance : new PodDisruptionBudgetStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withCurrentHealthy(instance.getCurrentHealthy());
            this.withDesiredHealthy(instance.getDesiredHealthy());
            this.withDisruptedPods(instance.getDisruptedPods());
            this.withDisruptionsAllowed(instance.getDisruptionsAllowed());
            this.withExpectedPods(instance.getExpectedPods());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withConditions(instance.getConditions());
            this.withCurrentHealthy(instance.getCurrentHealthy());
            this.withDesiredHealthy(instance.getDesiredHealthy());
            this.withDisruptedPods(instance.getDisruptedPods());
            this.withDisruptionsAllowed(instance.getDisruptionsAllowed());
            this.withExpectedPods(instance.getExpectedPods());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public Integer getCurrentHealthy() {
        return this.currentHealthy;
    }

    public A withCurrentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
        return (A)((Object)this);
    }

    public boolean hasCurrentHealthy() {
        return this.currentHealthy != null;
    }

    public Integer getDesiredHealthy() {
        return this.desiredHealthy;
    }

    public A withDesiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
        return (A)((Object)this);
    }

    public boolean hasDesiredHealthy() {
        return this.desiredHealthy != null;
    }

    public A addToDisruptedPods(String key, String value) {
        if (this.disruptedPods == null && key != null && value != null) {
            this.disruptedPods = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.disruptedPods.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDisruptedPods(Map<String, String> map) {
        if (this.disruptedPods == null && map != null) {
            this.disruptedPods = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.disruptedPods.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromDisruptedPods(String key) {
        if (this.disruptedPods == null) {
            return (A)((Object)this);
        }
        if (key != null && this.disruptedPods != null) {
            this.disruptedPods.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromDisruptedPods(Map<String, String> map) {
        if (this.disruptedPods == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.disruptedPods == null) continue;
                this.disruptedPods.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getDisruptedPods() {
        return this.disruptedPods;
    }

    public <K, V> A withDisruptedPods(Map<String, String> disruptedPods) {
        this.disruptedPods = disruptedPods == null ? null : new LinkedHashMap<String, String>(disruptedPods);
        return (A)((Object)this);
    }

    public boolean hasDisruptedPods() {
        return this.disruptedPods != null;
    }

    public Integer getDisruptionsAllowed() {
        return this.disruptionsAllowed;
    }

    public A withDisruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
        return (A)((Object)this);
    }

    public boolean hasDisruptionsAllowed() {
        return this.disruptionsAllowed != null;
    }

    public Integer getExpectedPods() {
        return this.expectedPods;
    }

    public A withExpectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
        return (A)((Object)this);
    }

    public boolean hasExpectedPods() {
        return this.expectedPods != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodDisruptionBudgetStatusFluent that = (PodDisruptionBudgetStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentHealthy, that.currentHealthy)) {
            return false;
        }
        if (!Objects.equals(this.desiredHealthy, that.desiredHealthy)) {
            return false;
        }
        if (!Objects.equals(this.disruptedPods, that.disruptedPods)) {
            return false;
        }
        if (!Objects.equals(this.disruptionsAllowed, that.disruptionsAllowed)) {
            return false;
        }
        if (!Objects.equals(this.expectedPods, that.expectedPods)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.currentHealthy, this.desiredHealthy, this.disruptedPods, this.disruptionsAllowed, this.expectedPods, this.observedGeneration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentHealthy != null) {
            sb.append("currentHealthy:");
            sb.append(this.currentHealthy + ",");
        }
        if (this.desiredHealthy != null) {
            sb.append("desiredHealthy:");
            sb.append(this.desiredHealthy + ",");
        }
        if (this.disruptedPods != null && !this.disruptedPods.isEmpty()) {
            sb.append("disruptedPods:");
            sb.append(this.disruptedPods + ",");
        }
        if (this.disruptionsAllowed != null) {
            sb.append("disruptionsAllowed:");
            sb.append(this.disruptionsAllowed + ",");
        }
        if (this.expectedPods != null) {
            sb.append("expectedPods:");
            sb.append(this.expectedPods + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

