/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.ExecutionManager;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementClass;
import org.apache.brooklyn.api.mgmt.entitlement.EntitlementManager;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.DslUtils;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.EntityManagementUtils;
import org.apache.brooklyn.core.mgmt.entitlement.EntitlementPredicates;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.steps.CustomWorkflowStep;
import org.apache.brooklyn.core.workflow.store.WorkflowStatePersistenceViaSensors;
import org.apache.brooklyn.rest.api.EntityApi;
import org.apache.brooklyn.rest.domain.EntitySummary;
import org.apache.brooklyn.rest.domain.LocationSummary;
import org.apache.brooklyn.rest.domain.RelationSummary;
import org.apache.brooklyn.rest.domain.TaskSummary;
import org.apache.brooklyn.rest.filter.HaHotStateRequired;
import org.apache.brooklyn.rest.resources.AbstractBrooklynRestResource;
import org.apache.brooklyn.rest.resources.ApplicationResource;
import org.apache.brooklyn.rest.transform.EntityTransformer;
import org.apache.brooklyn.rest.transform.LocationTransformer;
import org.apache.brooklyn.rest.transform.TaskTransformer;
import org.apache.brooklyn.rest.util.EntityRelationUtils;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HaHotStateRequired
public class EntityResource
extends AbstractBrooklynRestResource
implements EntityApi {
    private static final Logger log = LoggerFactory.getLogger(EntityResource.class);
    @Context
    private UriInfo uriInfo;

    public List<EntitySummary> list(String application) {
        return FluentIterable.from((Iterable)this.brooklyn().getApplication(application).getChildren()).filter(EntitlementPredicates.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY)).transform(EntityTransformer.fromEntity(this.ui.getBaseUriBuilder())).toList();
    }

    public EntitySummary get(String application, String entityName) {
        Entity entity = this.brooklyn().getEntity(application, entityName);
        if (Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            return EntityTransformer.entitySummary(entity, this.ui.getBaseUriBuilder());
        }
        throw WebResourceUtils.forbidden("User '%s' is not authorized to get entity '%s'", Entitlements.getEntitlementContext().user(), entity);
    }

    public List<EntitySummary> getChildren(String application, String entity) {
        return FluentIterable.from((Iterable)this.brooklyn().getEntity(application, entity).getChildren()).filter(EntitlementPredicates.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY)).transform(EntityTransformer.fromEntity(this.ui.getBaseUriBuilder())).toList();
    }

    public List<RelationSummary> getRelations(String applicationId, String entityId) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        if (entity != null) {
            return EntityRelationUtils.getRelations(entity);
        }
        return Collections.emptyList();
    }

    public Response addChildren(String applicationToken, String entityToken, Boolean start, String timeoutS, String yaml) {
        Response.ResponseBuilder response;
        Entity parent = this.brooklyn().getEntity(applicationToken, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)parent)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entityToken);
        }
        EntityManagementUtils.CreationResult added = EntityManagementUtils.addChildren((Entity)parent, (String)yaml, (Boolean)start).blockUntilComplete(timeoutS == null ? Duration.millis((Number)20) : Duration.of((Object)timeoutS));
        if (((List)added.get()).size() == 1) {
            Entity child = (Entity)Iterables.getOnlyElement((Iterable)((Iterable)added.get()));
            URI ref = WebResourceUtils.serviceAbsoluteUriBuilder(this.uriInfo.getBaseUriBuilder(), EntityApi.class, "get").build(new Object[]{child.getApplicationId(), child.getId()});
            response = Response.created((URI)ref);
        } else {
            response = Response.status((Response.Status)Response.Status.CREATED);
        }
        return response.entity((Object)TaskTransformer.taskSummary(added.task(), this.ui.getBaseUriBuilder(), this.resolving(null), null)).build();
    }

    public List<TaskSummary> listTasks(String applicationId, String entityId, int limit, Boolean recurse, Boolean suppressSecrets) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        return TaskTransformer.fromTasks(MutableList.copyOf((Iterable)BrooklynTaskTags.getTasksInEntityContext((ExecutionManager)this.mgmt().getExecutionManager(), (Entity)entity)), limit, recurse, entity, this.ui, this.resolving(null), suppressSecrets, TaskTransformer.TaskSummaryMode.NONE);
    }

    public TaskSummary getTask(String applicationToken, String entityToken, String taskId, Boolean suppressSecrets) {
        Entity entity = this.brooklyn().getEntity(applicationToken, entityToken);
        if (entity != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.SEE_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to see the task '%s' for the entity '%s'", Entitlements.getEntitlementContext().user(), taskId, entity);
        }
        Task t = this.mgmt().getExecutionManager().getTask(taskId);
        if (t == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s'", taskId);
        }
        Entity entityOfTask = BrooklynTaskTags.getContextEntity((Task)t);
        if (entityOfTask == null) {
            throw WebResourceUtils.notFound("Cannot find task '%s' on entity", taskId);
        }
        if (!entityOfTask.equals(entity)) {
            throw WebResourceUtils.notFound("Cannot find task '%s' on entity '%s'", taskId, entity.getId());
        }
        return TaskTransformer.fromTask(this.ui.getBaseUriBuilder(), this.resolving(null), suppressSecrets).apply(t);
    }

    public List<Object> listTags(String applicationId, String entityId) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        return (List)this.resolving(MutableList.copyOf((Iterable)entity.tags().getTags())).preferJson(true).resolve();
    }

    public void addTag(String applicationId, String entityId, Object tag) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        entity.tags().addTag(tag);
    }

    public boolean deleteTag(String applicationId, String entityId, Object tag) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        return entity.tags().removeTag(tag);
    }

    public void upsertTag(String applicationId, String entityId, String tagKey, Object tagValue) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        BrooklynTags.upsertSingleKeyMapValueTag((BrooklynObject.TagSupport)entity.tags(), (String)tagKey, (Object)tagValue);
    }

    public Object getTag(String applicationId, String entityId, String tagKey) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        return BrooklynTags.findSingleKeyMapValue((String)tagKey, Object.class, (Iterable)entity.tags().getTags());
    }

    public Response getIcon(String applicationId, String entityId) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        String url = RegisteredTypes.getIconUrl((BrooklynObject)entity);
        if (url == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (this.brooklyn().isUrlServerSideAndSafe(url)) {
            MediaType mime = WebResourceUtils.getImageMediaTypeFromExtension(Files.getFileExtension((String)url));
            InputStream content = ResourceUtils.create((Object)entity).getResourceFromUrl(url);
            return Response.ok((Object)content, (MediaType)mime).build();
        }
        return Response.temporaryRedirect((URI)URI.create(url)).build();
    }

    public Response rename(String application, String entity, String newName) {
        Entity instance = this.brooklyn().getEntity(application, entity);
        if (instance != null && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.RENAME_ENTITY, (Object)instance)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to rename the entity '%s'", Entitlements.getEntitlementContext().user(), entity);
        }
        instance.setDisplayName(newName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    public Response expunge(String application, String entity, boolean release) {
        Entity instance = this.brooklyn().getEntity(application, entity);
        Task<?> task = this.brooklyn().expunge(instance, release);
        if (instance.getDisplayName() == null || !instance.getDisplayName().startsWith("[DESTROYING] ")) {
            instance.setDisplayName("[DESTROYING] " + instance.getDisplayName());
        }
        TaskSummary summary = TaskTransformer.fromTask(this.ui.getBaseUriBuilder(), this.resolving(null), false).apply(task);
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)summary).build();
    }

    public List<EntitySummary> getDescendants(String application, String entity, String typeRegex) {
        return EntityTransformer.entitySummaries(this.brooklyn().descendantsOfType(application, entity, typeRegex), this.ui.getBaseUriBuilder());
    }

    public Map<String, Object> getDescendantsSensor(String application, String entity, String sensor, String typeRegex, Boolean suppressSecrets) {
        Iterable<Entity> descs = this.brooklyn().descendantsOfType(application, entity, typeRegex);
        return ApplicationResource.getSensorMap(sensor, descs, this.resolving(null), suppressSecrets);
    }

    public List<LocationSummary> getLocations(String application, String entity) {
        ArrayList result = Lists.newArrayList();
        Entity e = this.brooklyn().getEntity(application, entity);
        for (Location l : e.getLocations()) {
            result.add(LocationTransformer.newInstance(this.mgmt(), l, LocationTransformer.LocationDetailLevel.NONE, this.ui.getBaseUriBuilder()));
        }
        return result;
    }

    public String getSpec(String applicationToken, String entityToken) {
        Entity entity = this.brooklyn().getEntity(applicationToken, entityToken);
        BrooklynTags.NamedStringTag spec = BrooklynTags.findFirstNamedStringTag((String)"yaml_spec", (Iterable)entity.tags().getTags());
        if (spec == null) {
            return null;
        }
        return (String)this.resolving(null).getValueForDisplay(spec.getContents(), false, true, null);
    }

    public List<Object> getSpecList(String applicationId, String entityId) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        List specTag = BrooklynTags.findSpecHierarchyTag((Iterable)entity.tags().getTags());
        return (List)this.resolving(specTag).preferJson(true).resolve();
    }

    public Response getWorkflows(String applicationId, String entityId, Boolean suppressSecrets) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        return Response.ok((Object)this.resolving(null).getValueForDisplay(MutableList.copyOf(new WorkflowStatePersistenceViaSensors(this.mgmt()).getWorkflows(entity).values()), true, true, suppressSecrets, true)).build();
    }

    public Response getWorkflow(String applicationId, String entityId, String workflowId, Boolean suppressSecrets) {
        return Response.ok((Object)this.resolving(null).getValueForDisplay(this.findWorkflow(applicationId, entityId, workflowId), true, true, suppressSecrets)).build();
    }

    public Response deleteWorkflow(String applicationId, String entityId, String workflowId, Boolean suppressSecrets) {
        WorkflowExecutionContext w = this.findWorkflow(applicationId, entityId, workflowId);
        boolean deleted = WorkflowStatePersistenceViaSensors.get((ManagementContext)this.mgmt()).deleteWorkflow(w);
        if (!deleted) {
            throw WebResourceUtils.badRequest("Workflow '%s' could not be deleted. If running it may need cancelled first.", workflowId);
        }
        return Response.ok((Object)this.resolving(null).getValueForDisplay(w, true, true, suppressSecrets)).build();
    }

    WorkflowExecutionContext findWorkflow(String applicationId, String entityId, String workflowId) {
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        WorkflowExecutionContext w = (WorkflowExecutionContext)new WorkflowStatePersistenceViaSensors(this.mgmt()).getWorkflows(entity).get(workflowId);
        if (w == null) {
            throw WebResourceUtils.notFound("Cannot find workflow with ID '%s'", workflowId);
        }
        return w;
    }

    public TaskSummary replayWorkflow(String applicationId, String entityId, String workflowId, String step, String reason, Boolean force) {
        Task t;
        WorkflowExecutionContext w = this.findWorkflow(applicationId, entityId, workflowId);
        Entity entity = this.brooklyn().getEntity(applicationId, entityId);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.INVOKE_EFFECTOR, (Object)Entitlements.EntityAndItem.of((Entity)entity, (Object)Entitlements.StringAndArgument.of((String)"replay-workflow", (Object)workflowId)))) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to replay workflow '%s' on '%s'", Entitlements.getEntitlementContext().user(), workflowId, entity);
        }
        boolean forced = Boolean.TRUE.equals(force);
        if (forced && !Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)entity)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s', required to forcibly replay workflow", Entitlements.getEntitlementContext().user(), entity);
        }
        String msg = "Replaying workflow " + workflowId + " on " + entity + ", from step '" + step + "', reason '" + reason + "'";
        if (forced) {
            log.warn(msg);
        } else {
            log.debug(msg);
        }
        if (reason == null) {
            reason = "API replay" + (forced ? " forced" : "");
        }
        WorkflowExecutionContext.Factory wf = w.factory(false);
        if ("end".equalsIgnoreCase(step)) {
            t = wf.createTaskReplaying(wf.makeInstructionsForReplayResuming(reason, forced));
        } else if ("last".equalsIgnoreCase(step)) {
            t = wf.createTaskReplaying(wf.makeInstructionsForReplayingFromLastReplayable(reason, forced));
        } else if ("start".equalsIgnoreCase(step)) {
            t = wf.createTaskReplaying(wf.makeInstructionsForReplayingFromStart(reason, forced));
        } else {
            Maybe stepNumberRequested = TypeCoercions.tryCoerce((Object)step, Integer.class);
            if (stepNumberRequested.isPresent()) {
                t = wf.createTaskReplaying(wf.makeInstructionsForReplayingFromStep(((Integer)stepNumberRequested.get()).intValue(), reason, forced));
            } else {
                throw new IllegalStateException("Unsupported to resume from '" + step + "'");
            }
        }
        DynamicTasks.submit((TaskAdaptable)t, (Entity)entity);
        return TaskTransformer.taskSummary(t, this.ui.getBaseUriBuilder(), this.resolving(null), null);
    }

    public TaskSummary runWorkflow(String applicationToken, String entityToken, String timeoutS, String yaml) {
        CustomWorkflowStep workflow;
        Entity target = this.brooklyn().getEntity(applicationToken, entityToken);
        if (!Entitlements.isEntitled((EntitlementManager)this.mgmt().getEntitlementManager(), (EntitlementClass)Entitlements.MODIFY_ENTITY, (Object)target)) {
            throw WebResourceUtils.forbidden("User '%s' is not authorized to modify entity '%s'", Entitlements.getEntitlementContext().user(), entityToken);
        }
        try {
            workflow = (CustomWorkflowStep)BeanWithTypeUtils.newYamlMapper((ManagementContext)this.mgmt(), (boolean)true, (BrooklynClassLoadingContext)RegisteredTypes.getClassLoadingContext((Entity)target), (boolean)true).readerFor(CustomWorkflowStep.class).readValue(yaml);
            if (workflow.getInput() != null) {
                workflow.setInput((Map)DslUtils.parseBrooklynDsl((ManagementContext)this.mgmt(), (Object)workflow.getInput()));
            }
        }
        catch (JsonProcessingException e) {
            throw WebResourceUtils.badRequest(e);
        }
        WorkflowExecutionContext execution = workflow.newWorkflowExecution(target, (String)Strings.firstNonBlank((CharSequence[])new String[]{workflow.getName(), workflow.getId(), "API workflow invocation"}), null, (Map)MutableMap.of((Object)"tags", (Object)MutableList.of((Object)MutableMap.of((Object)"workflow_yaml", (Object)yaml))));
        Task task = (Task)Entities.submit((Entity)target, (TaskAdaptable)((TaskAdaptable)execution.getTask(true).get()));
        task.blockUntilEnded(timeoutS == null ? Duration.millis((Number)20) : ("never".equalsIgnoreCase(timeoutS) ? Duration.PRACTICALLY_FOREVER : ("always".equalsIgnoreCase(timeoutS) ? Duration.ZERO : Duration.of((Object)timeoutS))));
        URI ref = WebResourceUtils.serviceAbsoluteUriBuilder(this.uriInfo.getBaseUriBuilder(), EntityApi.class, "getWorkflow").build(new Object[]{target.getApplicationId(), target.getId(), execution.getWorkflowId()});
        Response.ResponseBuilder response = Response.created((URI)ref);
        return TaskTransformer.taskSummary(task, this.ui.getBaseUriBuilder(), this.resolving(null), null);
    }

    @Beta
    public static class InterestingTasksFirstComparator
    implements Comparator<Task<?>> {
        Entity optionalEntityContext;

        public InterestingTasksFirstComparator() {
            this(null);
        }

        public InterestingTasksFirstComparator(Entity entity) {
            this.optionalEntityContext = entity;
        }

        @Override
        public int compare(Task<?> o1, Task<?> o2) {
            long t1;
            if (!Objects.equal((Object)o1.isSubmitted(), (Object)o2.isSubmitted())) {
                return o1.isSubmitted() ? -1 : 1;
            }
            if (!Objects.equal((Object)o1.isDone(), (Object)o2.isDone())) {
                return !o1.isDone() ? -1 : 1;
            }
            if (!Objects.equal((Object)o1.isBegun(), (Object)o2.isBegun())) {
                return !o1.isBegun() ? -1 : 1;
            }
            long now = System.currentTimeMillis();
            long l = o1.isDone() ? o1.getEndTimeUtc() : (t1 = o1.isBegun() ? o1.getStartTimeUtc() : o1.getSubmitTimeUtc());
            long u1 = now - t1;
            long t2 = o2.isDone() ? o2.getEndTimeUtc() : (o2.isBegun() ? o2.getStartTimeUtc() : o2.getSubmitTimeUtc());
            long u2 = now - t2;
            if (u1 != u2) {
                return u1 > u2 ? 1 : -1;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

