/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.util;

import java.util.Locale;

public class StringEscapeUtils {
    private static final int HEX_RADIX = 16;
    private static final int UNICODE_LEN = 4;

    public static String unescapeJava(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder out = new StringBuilder(sz);
        StringBuilder unicode = new StringBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\'': {
                        out.append('\'');
                        break;
                    }
                    case '\"': {
                        out.append('\"');
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        break;
                    }
                    case 'b': {
                        out.append('\b');
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.append(ch);
        }
        if (hadSlash) {
            out.append('\\');
        }
        return out.toString();
    }

    public static String escapeJava(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuilder out = new StringBuilder(sz * 2);
        block11: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.append("\\u").append(StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.append("\\u0").append(StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.append("\\u00").append(StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00").append(StringEscapeUtils.hex(ch));
                            break;
                        }
                        out.append("\\u000").append(StringEscapeUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\"': {
                    out.append('\\');
                    out.append('\"');
                    continue block11;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    continue block11;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return out.toString();
    }

    public static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }
}

