/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Function;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.functions.CredentialsFromAdminAccess;

public class PersistNodeCredentialsModule
extends AbstractModule {
    protected void configure() {
        this.install(new FactoryModuleBuilder().implement((TypeLiteral)new TypeLiteral<Function<NodeMetadata, NodeMetadata>>(){}, (Annotation)Names.named((String)"ifAdminAccess"), RefreshCredentialsForNodeIfRanAdminAccess.class).implement((TypeLiteral)new TypeLiteral<Function<NodeMetadata, NodeMetadata>>(){}, (Annotation)Names.named((String)"always"), RefreshCredentialsForNode.class).build(PersistNodeCredentials.class));
    }

    static class RefreshCredentialsForNode
    extends RefreshCredentialsForNodeIfRanAdminAccess {
        @Inject
        public RefreshCredentialsForNode(Map<String, Credentials> credentialStore, @Assisted @Nullable Statement statement) {
            super(credentialStore, statement);
        }

        @Override
        public NodeMetadata apply(NodeMetadata input) {
            if ((input = super.apply(input)).getCredentials() != null) {
                this.credentialStore.put("node#" + input.getId(), input.getCredentials());
            }
            return input;
        }
    }

    static class RefreshCredentialsForNodeIfRanAdminAccess
    implements Function<NodeMetadata, NodeMetadata> {
        protected final Map<String, Credentials> credentialStore;
        protected final Statement statement;

        @Inject
        protected RefreshCredentialsForNodeIfRanAdminAccess(Map<String, Credentials> credentialStore, @Nullable @Assisted Statement statement) {
            this.credentialStore = credentialStore;
            this.statement = statement;
        }

        public NodeMetadata apply(NodeMetadata input) {
            if (this.statement == null) {
                return input;
            }
            Credentials credentials = CredentialsFromAdminAccess.INSTANCE.apply(this.statement);
            if (credentials != null) {
                LoginCredentials creds = LoginCredentials.fromCredentials((Credentials)credentials);
                input = NodeMetadataBuilder.fromNodeMetadata(input).credentials(creds).build();
                this.credentialStore.put("node#" + input.getId(), (Credentials)input.getCredentials());
            }
            return input;
        }
    }
}

