/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.drivers.EntityDriver;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.drivers.downloads.DownloadSubstituters;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNode;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNodeDriver;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNodeImpl;
import org.apache.brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.file.ArchiveBuilder;
import org.apache.brooklyn.util.core.file.ArchiveUtils;
import org.apache.brooklyn.util.core.file.BrooklynOsCommands;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynNodeSshDriver
extends JavaSoftwareProcessSshDriver
implements BrooklynNodeDriver {
    private static final Logger log = LoggerFactory.getLogger(BrooklynNodeSshDriver.class);

    public BrooklynNodeSshDriver(BrooklynNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public BrooklynNodeImpl getEntity() {
        return (BrooklynNodeImpl)super.getEntity();
    }

    public String getBrooklynHome() {
        return this.getRunDir();
    }

    @Override
    protected String getLogFileLocation() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "console"});
    }

    protected String getPidFile() {
        return Os.mergePathsUnix((String[])new String[]{this.getRunDir(), "pid_java"});
    }

    @Override
    protected String getInstallLabelExtraSalt() {
        String downloadUrl = (String)this.entity.getConfig(BrooklynNode.DOWNLOAD_URL);
        String uploadUrl = (String)this.entity.getConfig(BrooklynNode.DISTRO_UPLOAD_URL);
        if (Objects.equal((Object)downloadUrl, (Object)BrooklynNode.DOWNLOAD_URL.getConfigKey().getDefaultValue()) && Objects.equal((Object)uploadUrl, (Object)BrooklynNode.DISTRO_UPLOAD_URL.getDefaultValue())) {
            return null;
        }
        return Identifiers.makeIdFromHash((long)Objects.hashCode((Object[])new Object[]{downloadUrl, uploadUrl}));
    }

    @Override
    public String getArchiveNameFormat() {
        String subpath = (String)this.entity.getConfig(BrooklynNode.SUBPATH_IN_ARCHIVE);
        if (subpath == null) {
            String uploadUrl = (String)this.entity.getConfig(BrooklynNode.DISTRO_UPLOAD_URL);
            String origDownloadName = uploadUrl;
            if (origDownloadName == null) {
                origDownloadName = (String)this.entity.getAttribute(BrooklynNode.DOWNLOAD_URL);
            }
            if (origDownloadName != null) {
                origDownloadName = DownloadSubstituters.substitute((String)origDownloadName, (Map)DownloadSubstituters.getBasicEntitySubstitutions((EntityDriver)this));
                origDownloadName = Urls.decode((String)origDownloadName);
                String downloadName = origDownloadName = Urls.getBasename((String)origDownloadName);
                downloadName = Strings.removeFromEnd((String)downloadName, (String)".tar.gz");
                downloadName = Strings.removeFromEnd((String)downloadName, (String)".tgz");
                if (!(downloadName = Strings.removeFromEnd((String)downloadName, (String)".zip")).equals(origDownloadName)) {
                    subpath = downloadName = Strings.removeFromEnd((String)downloadName, (String)"-dist");
                }
            }
        }
        if (subpath == null) {
            subpath = "brooklyn-dist-%s";
        }
        return subpath;
    }

    @Override
    public void clearInstallDir() {
        super.setInstallDir(null);
        super.setExpandedInstallDir(null);
    }

    @Override
    public void install() {
        String uploadUrl = (String)this.entity.getConfig(BrooklynNode.DISTRO_UPLOAD_URL);
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        this.newScript((String)"createInstallDir").body.append((CharSequence)("mkdir -p " + this.getInstallDir())).failOnNonZeroResultCode().execute();
        ArrayList commands = Lists.newArrayList();
        if (uploadUrl != null) {
            boolean exists;
            boolean bl = exists = this.newScript((String)"checkIfInstalled").body.append("cd " + this.getInstallDir(), "test -f BROOKLYN").execute() == 0;
            if (!exists) {
                InputStream distroStream = this.resource.getResourceFromUrl(uploadUrl);
                this.getMachine().copyTo(distroStream, this.getInstallDir() + "/" + saveAs);
            }
        } else {
            commands.addAll(BrooklynOsCommands.bash((Location)this.getMachine()).commandsToDownloadUrlsAs(urls, saveAs));
        }
        commands.add(BrooklynOsCommands.bash((Location)this.getMachine()).INSTALL_TAR);
        commands.add("tar xzfv " + saveAs);
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append(commands).execute();
    }

    @Override
    public void customize() {
        this.newScript((String)"customizing").failOnNonZeroResultCode().body.append(String.format("[ -d %1$s ] || ln -s . %1$s", this.getExpandedInstallDir(), this.getExpandedInstallDir()), String.format("cp -R %s/* .", this.getExpandedInstallDir()), "mkdir -p ./lib/dropins/").execute();
        SshMachineLocation machine = this.getMachine();
        BrooklynNodeImpl entity = this.getEntity();
        String brooklynGlobalPropertiesRemotePath = (String)entity.getConfig(BrooklynNode.BROOKLYN_GLOBAL_PROPERTIES_REMOTE_PATH);
        String brooklynGlobalPropertiesContents = (String)entity.getConfig(BrooklynNode.BROOKLYN_GLOBAL_PROPERTIES_CONTENTS);
        String brooklynGlobalPropertiesUri = (String)entity.getConfig(BrooklynNode.BROOKLYN_GLOBAL_PROPERTIES_URI);
        String brooklynLocalPropertiesRemotePath = this.processTemplateContents((String)entity.getConfig(BrooklynNode.BROOKLYN_LOCAL_PROPERTIES_REMOTE_PATH));
        String brooklynLocalPropertiesContents = (String)entity.getConfig(BrooklynNode.BROOKLYN_LOCAL_PROPERTIES_CONTENTS);
        String brooklynLocalPropertiesUri = (String)entity.getConfig(BrooklynNode.BROOKLYN_LOCAL_PROPERTIES_URI);
        String brooklynCatalogInitialBomRemotePath = this.processTemplateContents((String)entity.getConfig(BrooklynNode.BROOKLYN_CATALOG_INITIAL_BOM_REMOTE_PATH));
        String brooklynCatalogInitialBomUri = (String)entity.getConfig(BrooklynNode.BROOKLYN_CATALOG_INITIAL_BOM_URI);
        String brooklynCatalogInitialBomContents = (String)entity.getConfig(BrooklynNode.BROOKLYN_CATALOG_INITIAL_BOM_CONTENTS);
        if (brooklynGlobalPropertiesContents != null || brooklynGlobalPropertiesUri != null) {
            BrooklynNode.ExistingFileBehaviour onExisting = (BrooklynNode.ExistingFileBehaviour)((Object)entity.getConfig(BrooklynNode.ON_EXISTING_PROPERTIES_FILE));
            Integer checkExists = (Integer)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"ls \"" + brooklynGlobalPropertiesRemotePath + "\""}).allowingNonZeroExitCode())).get();
            boolean doUpload = true;
            if (checkExists == 0) {
                switch (onExisting) {
                    case USE_EXISTING: {
                        doUpload = false;
                        break;
                    }
                    case OVERWRITE: {
                        break;
                    }
                    case DO_NOT_USE: {
                        throw new IllegalStateException("Properties file " + brooklynGlobalPropertiesContents + " already exists and even though it is not being used, content for it was supplied");
                    }
                    case FAIL: {
                        throw new IllegalStateException("Properties file " + brooklynGlobalPropertiesContents + " already exists and " + BrooklynNode.ON_EXISTING_PROPERTIES_FILE + " response is to fail");
                    }
                    default: {
                        throw new IllegalStateException("Properties file " + brooklynGlobalPropertiesContents + " already exists and " + BrooklynNode.ON_EXISTING_PROPERTIES_FILE + " response " + onExisting + " is unknown");
                    }
                }
            }
            if (onExisting == BrooklynNode.ExistingFileBehaviour.DO_NOT_USE) {
                log.warn("Global properties supplied when told not to use them; no global properties exists, so it will be installed, but it will not be used.");
            }
            if (doUpload) {
                this.uploadFileContents(brooklynGlobalPropertiesContents, brooklynGlobalPropertiesUri, brooklynGlobalPropertiesRemotePath);
            }
        }
        if (brooklynLocalPropertiesContents != null || brooklynLocalPropertiesUri != null) {
            this.uploadFileContents(brooklynLocalPropertiesContents, brooklynLocalPropertiesUri, brooklynLocalPropertiesRemotePath);
        }
        if (brooklynCatalogInitialBomContents != null || brooklynCatalogInitialBomUri != null) {
            this.uploadFileContents(brooklynCatalogInitialBomContents, brooklynCatalogInitialBomUri, brooklynCatalogInitialBomRemotePath);
        }
        for (Map.Entry entry : ((Map)this.getEntity().getAttribute((AttributeSensor)BrooklynNode.COPY_TO_RUNDIR)).entrySet()) {
            String remotePath;
            ImmutableMap substitutions = ImmutableMap.of((Object)"RUN", (Object)this.getRunDir());
            String localResource = (String)entry.getKey();
            String resolvedRemotePath = remotePath = (String)entry.getValue();
            for (Map.Entry substitution : substitutions.entrySet()) {
                String key = (String)substitution.getKey();
                String val = (String)substitution.getValue();
                resolvedRemotePath = resolvedRemotePath.replace("${" + key + "}", val).replace("$" + key, val);
            }
            machine.copyTo((Map)MutableMap.of((Object)"permissions", (Object)"0600"), this.resource.getResourceFromUrl(localResource), resolvedRemotePath);
        }
        for (Map.Entry entry : this.getEntity().getClasspath()) {
            String filename = null;
            String url = null;
            if (entry instanceof String) {
                url = (String)((Object)entry);
            } else if (entry instanceof Map) {
                url = (String)((Map)((Object)entry)).get("url");
                filename = (String)((Map)((Object)entry)).get("filename");
            }
            Preconditions.checkNotNull((Object)url, (Object)"url");
            MutableList filesToDelete = MutableList.of();
            if (Urls.isDirectory((String)url)) {
                File jarFile = ArchiveBuilder.jar().addDirContentsAt(new File(url), "").create();
                filesToDelete.add(jarFile);
                url = jarFile.getAbsolutePath();
            }
            if (filename == null) {
                filename = this.getFilename(url);
            }
            ArchiveUtils.deploy((Map)MutableMap.of(), (String)url, (SshMachineLocation)machine, (String)this.getRunDir(), (String)Os.mergePaths((String[])new String[]{this.getRunDir(), "lib", "dropins"}), (String)filename);
            filesToDelete.forEach(f -> f.delete());
        }
        String cmd = (String)entity.getConfig(BrooklynNode.EXTRA_CUSTOMIZATION_SCRIPT);
        if (Strings.isNonBlank((CharSequence)cmd)) {
            DynamicTasks.queueIfPossible((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{cmd}).summary("Bespoke BrooklynNode customization script")).requiringExitCodeZero()).orSubmitAndBlock((Entity)this.getEntity());
        }
    }

    private String getFilename(String url) {
        String destFile = url.contains("?") ? url.substring(0, url.indexOf(63)) : url;
        destFile = destFile.substring(destFile.lastIndexOf(47) + 1);
        return destFile;
    }

    @Override
    public void launch() {
        String app = (String)this.getEntity().getAttribute((AttributeSensor)BrooklynNode.APP);
        String locations = (String)this.getEntity().getAttribute((AttributeSensor)BrooklynNode.LOCATIONS);
        boolean hasLocalBrooklynProperties = this.getEntity().getConfig(BrooklynNode.BROOKLYN_LOCAL_PROPERTIES_CONTENTS) != null || this.getEntity().getConfig(BrooklynNode.BROOKLYN_LOCAL_PROPERTIES_URI) != null;
        boolean hasLocalCatalogInitialBom = this.getEntity().getConfig(BrooklynNode.BROOKLYN_CATALOG_INITIAL_BOM_CONTENTS) != null || this.getEntity().getConfig(BrooklynNode.BROOKLYN_CATALOG_INITIAL_BOM_URI) != null;
        String localBrooklynPropertiesPath = this.processTemplateContents((String)this.getEntity().getConfig(BrooklynNode.BROOKLYN_LOCAL_PROPERTIES_REMOTE_PATH));
        String localCatalogInitialBomPath = this.processTemplateContents((String)this.getEntity().getConfig(BrooklynNode.BROOKLYN_CATALOG_INITIAL_BOM_REMOTE_PATH));
        InetAddress bindAddress = (InetAddress)this.getEntity().getAttribute((AttributeSensor)BrooklynNode.WEB_CONSOLE_BIND_ADDRESS);
        InetAddress publicAddress = (InetAddress)this.getEntity().getAttribute((AttributeSensor)BrooklynNode.WEB_CONSOLE_PUBLIC_ADDRESS);
        String cmd = (String)this.entity.getConfig(BrooklynNode.LAUNCH_COMMAND);
        if (Strings.isBlank((CharSequence)cmd)) {
            cmd = "./bin/brooklyn";
        }
        cmd = "nohup " + cmd + " launch";
        if (app != null) {
            cmd = cmd + " --app " + app;
        }
        if (locations != null) {
            cmd = cmd + " --locations " + locations;
        }
        if (this.entity.getConfig(BrooklynNode.ON_EXISTING_PROPERTIES_FILE) == BrooklynNode.ExistingFileBehaviour.DO_NOT_USE) {
            cmd = cmd + " --noGlobalBrooklynProperties";
        }
        if (hasLocalBrooklynProperties) {
            cmd = cmd + " --localBrooklynProperties " + localBrooklynPropertiesPath;
        }
        if (hasLocalCatalogInitialBom) {
            cmd = cmd + " --catalogInitial " + localCatalogInitialBomPath;
        }
        Integer webPort = null;
        if (this.getEntity().isHttpProtocolEnabled("http")) {
            webPort = (Integer)this.getEntity().getAttribute((AttributeSensor)BrooklynNode.HTTP_PORT);
            Networking.checkPortsValid((Map)ImmutableMap.of((Object)"webPort", (Object)webPort));
        } else if (this.getEntity().isHttpProtocolEnabled("https")) {
            webPort = (Integer)this.getEntity().getAttribute((AttributeSensor)BrooklynNode.HTTPS_PORT);
            Networking.checkPortsValid((Map)ImmutableMap.of((Object)"webPort", (Object)webPort));
        }
        if (webPort != null) {
            cmd = cmd + " --port " + webPort;
        } else if (this.getEntity().getEnabledHttpProtocols().isEmpty()) {
            cmd = cmd + " --noConsole";
        } else {
            throw new IllegalStateException("Unknown web protocol in " + BrooklynNode.ENABLED_HTTP_PROTOCOLS + " (" + this.getEntity().getEnabledHttpProtocols() + "); expecting 'http' or 'https'");
        }
        if (bindAddress != null) {
            cmd = cmd + " --bindAddress " + bindAddress.getHostAddress();
        }
        if (publicAddress != null) {
            cmd = cmd + " --publicAddress " + publicAddress.getHostName();
        }
        if (((Boolean)this.getEntity().getAttribute((AttributeSensor)BrooklynNode.NO_WEB_CONSOLE_AUTHENTICATION)).booleanValue()) {
            cmd = cmd + " --noConsoleSecurity";
        }
        if (Strings.isNonBlank((CharSequence)((CharSequence)this.getEntity().getConfig(BrooklynNode.EXTRA_LAUNCH_PARAMETERS)))) {
            cmd = cmd + " " + (String)this.getEntity().getConfig(BrooklynNode.EXTRA_LAUNCH_PARAMETERS);
        }
        cmd = cmd + String.format(" >> %s/console 2>&1 </dev/null &", this.getRunDir());
        log.info("Starting brooklyn on {} using command {}", (Object)this.getMachine(), (Object)cmd);
        this.newScript(ImmutableMap.of((Object)"usePidFile", (Object)(((Boolean)this.entity.getConfig(BrooklynNode.LAUNCH_COMMAND_CREATES_PID_FILE)).booleanValue() ? Boolean.valueOf((boolean)false) : this.getPidFile())), (String)"launching").body.append(String.format("export BROOKLYN_CLASSPATH=%s", this.getRunDir() + "/lib/\"*\""), String.format("export BROOKLYN_HOME=%s", this.getBrooklynHome()), String.format(cmd, new Object[0])).failOnNonZeroResultCode().execute();
    }

    @Override
    public boolean isRunning() {
        ImmutableMap flags = ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile());
        int result = this.newScript((Map<String, ?>)flags, "check-running").execute();
        return result == 0;
    }

    @Override
    public void stop() {
        ImmutableMap flags = ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile());
        this.newScript((Map<String, ?>)flags, "stopping").execute();
    }

    @Override
    public void kill() {
        ImmutableMap flags = ImmutableMap.of((Object)"usePidFile", (Object)this.getPidFile());
        this.newScript((Map<String, ?>)flags, "killing").execute();
    }

    @Override
    public Map<String, String> getShellEnvironment() {
        Map<String, String> orig = super.getShellEnvironment();
        String origClasspath = orig.get("CLASSPATH");
        String newClasspath = (origClasspath == null ? "" : origClasspath + ":") + this.getRunDir() + "/conf/:" + this.getRunDir() + "/lib/\"*\"";
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        results.putAll(orig);
        results.put("BROOKLYN_CLASSPATH", newClasspath);
        results.put("BROOKLYN_HOME", this.getBrooklynHome());
        results.put("RUN", this.getRunDir());
        return results;
    }

    private void uploadFileContents(String contents, String alternativeUri, String remotePath) {
        Preconditions.checkNotNull((Object)remotePath, (Object)"remotePath");
        SshMachineLocation machine = this.getMachine();
        String tempRemotePath = String.format("%s/upload.tmp", this.getRunDir());
        if (contents == null && alternativeUri == null) {
            throw new IllegalStateException("No contents supplied for file " + remotePath);
        }
        InputStream stream = contents != null ? new ByteArrayInputStream(contents.getBytes()) : this.resource.getResourceFromUrl(alternativeUri);
        MutableMap flags = MutableMap.of((Object)SshTool.PROP_PERMISSIONS.getName(), (Object)"0600");
        machine.copyTo((Map)flags, stream, tempRemotePath);
        this.newScript((String)"customizing").failOnNonZeroResultCode().body.append(String.format("mkdir -p %s", remotePath.subSequence(0, remotePath.lastIndexOf("/"))), String.format("cp -p %s %s", tempRemotePath, remotePath), String.format("rm -f %s", tempRemotePath)).execute();
    }
}

