/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.framework.FrameworkLookup;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.catalog.internal.CatalogBundleLoader;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.server.BrooklynServerPaths;
import org.apache.brooklyn.core.typereg.BrooklynCatalogBundleResolver;
import org.apache.brooklyn.core.typereg.BrooklynCatalogBundleResolvers;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.osgi.Osgis;
import org.apache.brooklyn.util.core.osgi.SystemFrameworkLoader;
import org.apache.brooklyn.util.core.xstream.OsgiClassPrefixer;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.ReferenceWithError;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.repeat.Repeater;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.commons.lang3.tuple.Pair;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiManager {
    private static final Logger log = LoggerFactory.getLogger(OsgiManager.class);
    public static final ConfigKey<Boolean> USE_OSGI = BrooklynServerConfig.USE_OSGI;
    public static final ConfigKey<Boolean> REUSE_OSGI = ConfigKeys.newBooleanConfigKey("brooklyn.osgi.reuse", "Whether the OSGi container can reuse a previous one and itself can be reused, defaulting to false, often overridden in tests for efficiency (and will ignore the cache dir)", false);
    protected static final boolean REUSED_FRAMEWORKS_ARE_KEPT_RUNNING = true;
    public static final ConfigKey<Boolean> OSGI_STARTUP_COMPLETE = ConfigKeys.newBooleanConfigKey("brooklyn.osgi.startup.complete");
    final ManagementContext mgmt;
    final OsgiClassPrefixer osgiClassPrefixer;
    Framework framework;
    private boolean reuseFramework;
    private Set<Bundle> bundlesAtStartup;
    private File brooklynBundlesCacheDir;
    private File osgiFrameworkCacheDir;
    final ManagedBundlesRecord managedBundlesRecord = new ManagedBundlesRecord();
    private static AtomicInteger numberOfReusableFrameworksCreated = new AtomicInteger();
    private static final List<Framework> OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE = MutableList.of();

    public OsgiManager(ManagementContext mgmt) {
        this.mgmt = mgmt;
        this.osgiClassPrefixer = new OsgiClassPrefixer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.framework != null) {
            throw new IllegalStateException("OSGi framework already set in this management context");
        }
        try {
            this.brooklynBundlesCacheDir = Os.newTempDir((String)"brooklyn-osgi-brooklyn-bundles-cache");
            Os.deleteOnExitRecursively((File)this.brooklynBundlesCacheDir);
            if (((Boolean)this.mgmt.getConfig().getConfig(REUSE_OSGI)).booleanValue()) {
                this.reuseFramework = true;
                List<Framework> list = OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE;
                synchronized (list) {
                    if (!OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE.isEmpty()) {
                        this.framework = OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE.remove(0);
                    }
                }
                if (this.framework != null) {
                    log.debug("Reusing OSGi framework container from " + this.framework.getBundleContext().getProperty("org.osgi.framework.storage") + " for mgmt node " + this.mgmt.getManagementNodeId());
                    return;
                }
                this.osgiFrameworkCacheDir = Os.newTempDir((String)"brooklyn-osgi-reusable-container");
                Os.deleteOnExitRecursively((File)this.osgiFrameworkCacheDir);
                if (numberOfReusableFrameworksCreated.incrementAndGet() % 10 == 0) {
                    log.warn("Possible leak of reusable OSGi containers (" + numberOfReusableFrameworksCreated + " total)");
                }
            } else {
                this.osgiFrameworkCacheDir = BrooklynServerPaths.getOsgiCacheDirCleanedIfNeeded(this.mgmt);
            }
            this.framework = Osgis.getFramework(this.osgiFrameworkCacheDir.getAbsolutePath(), false);
            log.debug("OSGi framework container created in " + this.osgiFrameworkCacheDir + " mgmt node " + this.mgmt.getManagementNodeId() + (this.reuseFramework ? "(reusable, " + numberOfReusableFrameworksCreated.get() + " total)" : ""));
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            if (this.reuseFramework && this.framework != null) {
                this.bundlesAtStartup = MutableSet.copyOf(Arrays.asList(this.framework.getBundleContext().getBundles()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.reuseFramework) {
            for (Bundle b : this.framework.getBundleContext().getBundles()) {
                if (this.bundlesAtStartup.contains(b)) continue;
                try {
                    log.trace("Uninstalling " + b + " from OSGi container in " + this.framework.getBundleContext().getProperty("org.osgi.framework.storage"));
                    b.uninstall();
                }
                catch (BundleException e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.warn("Unable to uninstall " + b + "; container in " + this.framework.getBundleContext().getProperty("org.osgi.framework.storage") + " will not be reused: " + (Object)((Object)e), (Throwable)e);
                    this.reuseFramework = false;
                    break;
                }
            }
        }
        if (!this.reuseFramework) {
            try {
                this.framework.stop();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
            Osgis.ungetFramework(this.framework);
            Reflections.getFieldValueMaybe((Object)this.framework, (String)"m_resolver").mapMaybe(resolver -> Reflections.getFieldValueMaybe((Object)resolver, (String)"m_executor")).transformNow(ex -> {
                if (ex instanceof ExecutorService) {
                    return ((ExecutorService)ex).shutdownNow();
                }
                return null;
            });
            System.gc();
            System.gc();
            System.runFinalization();
            System.runFinalization();
            System.gc();
            System.gc();
        }
        if (this.reuseFramework) {
            List<Framework> e = OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE;
            synchronized (e) {
                OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE.add(this.framework);
            }
        } else if (BrooklynServerPaths.isOsgiCacheForCleaning(this.mgmt, this.osgiFrameworkCacheDir)) {
            final AtomicReference deletionResult = new AtomicReference();
            Repeater.create((String)"Delete OSGi cache dir").until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    deletionResult.set(Os.deleteRecursively((File)OsgiManager.this.osgiFrameworkCacheDir));
                    return ((Os.DeletionResult)deletionResult.get()).wasSuccessful();
                }
            }).limitTimeTo(Duration.ONE_SECOND).backoffTo(Duration.millis((Number)50)).run();
            if (((Os.DeletionResult)deletionResult.get()).getThrowable() != null) {
                log.debug("Unable to delete " + this.osgiFrameworkCacheDir + " (possibly being modified concurrently?): " + ((Os.DeletionResult)deletionResult.get()).getThrowable());
            }
        }
        this.osgiFrameworkCacheDir = null;
        this.framework = null;
        Os.deleteRecursively((File)this.brooklynBundlesCacheDir);
        this.brooklynBundlesCacheDir = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static Maybe<Framework> tryPeekFrameworkForReuse() {
        List<Framework> list = OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE;
        synchronized (list) {
            if (!OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE.isEmpty()) {
                return Maybe.of((Object)OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE.get(0));
            }
        }
        return Maybe.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static List<Framework> peekFrameworksForReuse() {
        List<Framework> list = OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE;
        synchronized (list) {
            return ImmutableList.copyOf(OSGI_FRAMEWORK_CONTAINERS_FOR_REUSE);
        }
    }

    public ManagementContext getManagementContext() {
        return this.mgmt;
    }

    public void clearManagedBundles() {
        this.managedBundlesRecord.clear();
    }

    public Map<String, ManagedBundle> getManagedBundles() {
        return this.managedBundlesRecord.getManagedBundles();
    }

    public String getManagedBundleId(VersionedName vn) {
        return this.managedBundlesRecord.getManagedBundleId(vn);
    }

    public ManagedBundle getManagedBundle(VersionedName vn) {
        return this.managedBundlesRecord.getManagedBundle(vn);
    }

    public ManagedBundle getManagedBundleFromUrl(String url) {
        return this.managedBundlesRecord.getManagedBundleFromUrl(url);
    }

    public ReferenceWithError<OsgiBundleInstallationResult> install(Supplier<InputStream> zipIn) {
        return BrooklynCatalogBundleResolvers.install(this.getManagementContext(), zipIn, null);
    }

    public ReferenceWithError<OsgiBundleInstallationResult> installDeferredStart(@Nullable ManagedBundle knownBundleMetadata, @Nullable Supplier<InputStream> zipIn, boolean validateTypes) {
        BrooklynCatalogBundleResolver.BundleInstallationOptions options = new BrooklynCatalogBundleResolver.BundleInstallationOptions();
        options.setDeferredStart(true);
        if (knownBundleMetadata != null) {
            options.setFormat(knownBundleMetadata.getFormat());
        }
        options.setValidateTypes(validateTypes);
        options.setKnownBundleMetadata(knownBundleMetadata);
        return BrooklynCatalogBundleResolvers.install(this.getManagementContext(), zipIn, options);
    }

    @Deprecated
    public ReferenceWithError<OsgiBundleInstallationResult> install(Supplier<InputStream> input, String format, boolean force) {
        return this.install(input, format, force, null);
    }

    public ReferenceWithError<OsgiBundleInstallationResult> install(Supplier<InputStream> input, String format, boolean force, Boolean deleteable) {
        BrooklynCatalogBundleResolver.BundleInstallationOptions options = new BrooklynCatalogBundleResolver.BundleInstallationOptions();
        options.setFormat(format);
        options.setForceUpdateOfNonSnapshots(force);
        options.setDeleteable(deleteable);
        return BrooklynCatalogBundleResolvers.install(this.getManagementContext(), input, options);
    }

    @Beta
    public ReferenceWithError<OsgiBundleInstallationResult> installBrooklynBomBundle(@Nullable ManagedBundle knownBundleMetadata, Supplier<InputStream> input, boolean start, boolean loadCatalogBom, boolean forceUpdateOfNonSnapshots) {
        return this.installBrooklynBomBundle(knownBundleMetadata, input, start, loadCatalogBom, forceUpdateOfNonSnapshots, true, false);
    }

    @Beta
    public ReferenceWithError<OsgiBundleInstallationResult> installBrooklynBomBundle(@Nullable ManagedBundle knownBundleMetadata, Supplier<InputStream> input, boolean start, boolean loadCatalogBom, boolean forceUpdateOfNonSnapshots, boolean validate, boolean deferredStart) {
        BrooklynCatalogBundleResolver.BundleInstallationOptions options = new BrooklynCatalogBundleResolver.BundleInstallationOptions();
        options.setKnownBundleMetadata(knownBundleMetadata);
        options.setStart(start);
        options.setLoadCatalogBom(loadCatalogBom);
        options.setForceUpdateOfNonSnapshots(forceUpdateOfNonSnapshots);
        options.setValidateTypes(validate);
        options.setDeferredStart(deferredStart);
        return BrooklynCatalogBundleResolvers.install(this.getManagementContext(), input, options);
    }

    public OsgiBundleInstallationResult uninstallUploadedBundle(ManagedBundle bundleMetadata) {
        return (OsgiBundleInstallationResult)this.uninstallUploadedBundle(bundleMetadata, false).get();
    }

    public ReferenceWithError<OsgiBundleInstallationResult> uninstallUploadedBundle(ManagedBundle bundleMetadata, boolean force) {
        return this.uninstallUploadedBundle(bundleMetadata, force, false);
    }

    public ReferenceWithError<OsgiBundleInstallationResult> uninstallUploadedBundle(ManagedBundle bundleMetadata, boolean force, boolean leaveInOsgi) {
        RuntimeException e;
        OsgiBundleInstallationResult result = new OsgiBundleInstallationResult();
        result.metadata = bundleMetadata;
        MutableList errors = MutableList.of();
        boolean uninstalledItems = false;
        try {
            try {
                Iterable<RegisteredType> itemsRemoved = this.uninstallCatalogItemsFromBundle(bundleMetadata.getVersionedName());
                for (RegisteredType t : itemsRemoved) {
                    result.addType(t);
                }
                uninstalledItems = true;
            }
            catch (Exception e2) {
                Exceptions.propagateIfFatal((Throwable)e2);
                if (!force) {
                    Exceptions.propagate((Throwable)e2);
                }
                log.warn("Error uninstalling catalog items of " + bundleMetadata + ": " + e2);
                errors.add(e2);
            }
            BundleUpgradeParser.CatalogUpgrades.clearBundleInStoredUpgrades(this.mgmt, bundleMetadata.getVersionedName());
            if (!this.managedBundlesRecord.remove(bundleMetadata)) {
                e = new IllegalStateException("No such bundle registered with Brooklyn when uninstalling: " + bundleMetadata);
                if (!force) {
                    Exceptions.propagate((Throwable)e);
                }
                log.warn(e.getMessage());
                errors.add(e);
            }
            try {
                this.mgmt.getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)bundleMetadata);
            }
            catch (Exception e3) {
                Exceptions.propagateIfFatal((Throwable)e3);
                if (!force) {
                    Exceptions.propagate((Throwable)e3);
                }
                log.warn("Error handling unmanagement of " + bundleMetadata + ": " + e3);
                errors.add(e3);
            }
            if (!leaveInOsgi) {
                Maybe<Bundle> bundle = this.findBundle(bundleMetadata);
                result.bundle = (Bundle)bundle.orNull();
                if (bundle.isAbsent()) {
                    IllegalStateException e4 = new IllegalStateException("No such bundle installed in OSGi when uninstalling: " + bundleMetadata);
                    if (!force) {
                        Exceptions.propagate((Throwable)e4);
                    }
                    log.warn(e4.getMessage());
                    errors.add(e4);
                } else {
                    try {
                        ((Bundle)bundle.get()).stop();
                        ((Bundle)bundle.get()).uninstall();
                    }
                    catch (BundleException e5) {
                        Exceptions.propagateIfFatal((Throwable)e5);
                        if (!force) {
                            Exceptions.propagate((Throwable)e5);
                        }
                        log.warn("Error stopping and uninstalling " + bundleMetadata + ": " + (Object)((Object)e5));
                        errors.add(e5);
                    }
                }
            }
        }
        catch (Exception e6) {
            Exceptions.propagateIfFatal((Throwable)e6);
            if (!force) {
                Exceptions.propagate((Throwable)e6);
            }
            log.warn("Error removing " + bundleMetadata + ": " + e6);
            errors.add(e6);
        }
        if (errors.isEmpty()) {
            result.message = "Uninstalled " + bundleMetadata + " (type count " + result.typesInstalled.size() + ", OSGi " + result.bundle + ")";
            result.code = OsgiBundleInstallationResult.ResultCode.BUNDLE_REMOVED;
            return ReferenceWithError.newInstanceWithoutError((Object)result);
        }
        e = Exceptions.create((String)("Error removing bundle " + bundleMetadata), (Iterable)errors);
        result.message = Exceptions.collapseText((Throwable)e);
        result.code = uninstalledItems ? OsgiBundleInstallationResult.ResultCode.ERROR_REMOVING_BUNDLE_OTHER : OsgiBundleInstallationResult.ResultCode.ERROR_REMOVING_BUNDLE_IN_USE;
        return ReferenceWithError.newInstanceThrowingError((Object)result, (Throwable)e);
    }

    @Beta
    public Iterable<RegisteredType> uninstallCatalogItemsFromBundle(VersionedName bundle) {
        ImmutableList thingsFromHere = ImmutableList.copyOf(this.getTypesFromBundle(bundle));
        log.debug("Uninstalling items from bundle " + bundle + ": " + thingsFromHere);
        for (RegisteredType t : thingsFromHere) {
            this.mgmt.getCatalog().deleteCatalogItem(t.getSymbolicName(), t.getVersion());
        }
        return thingsFromHere;
    }

    @Beta
    public Iterable<RegisteredType> getTypesFromBundle(VersionedName vn) {
        return this.mgmt.getTypeRegistry().getMatching(RegisteredTypePredicates.containingBundle(vn));
    }

    @Deprecated
    public synchronized Bundle registerBundle(CatalogItem.CatalogBundle bundleMetadata) {
        try {
            Bundle alreadyBundle = this.checkBundleInstalledThrowIfInconsistent((OsgiBundleWithUrl)bundleMetadata, true);
            if (alreadyBundle != null) {
                return alreadyBundle;
            }
            Bundle bundleInstalled = Osgis.install(this.framework, bundleMetadata.getUrl());
            this.checkCorrectlyInstalled((OsgiBundleWithUrl)bundleMetadata, bundleInstalled);
            return bundleInstalled;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Bundle from " + bundleMetadata.getUrl() + " failed to install: " + e.getMessage(), e);
        }
    }

    @Beta
    public void loadBrooklynBundleWithCatalogBom(Bundle bundle, @Nullable String bomText, boolean force, boolean validate, Map<RegisteredType, RegisteredType> result) {
        try {
            new CatalogBundleLoader(this.mgmt).scanForCatalog(bundle, bomText, force, validate, result);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Error installing catalog items from BOM in " + bundle + (Strings.isNonBlank((CharSequence)bomText) ? " (with specified BOM text)" : ""), ex);
        }
    }

    void checkCorrectlyInstalled(OsgiBundleWithUrl bundle, Bundle b) {
        String nv = b.getSymbolicName() + ":" + b.getVersion().toString();
        if (!OsgiManager.isBundleNameEqualOrAbsent(bundle, b)) {
            throw new IllegalStateException("Bundle already installed as " + nv + " but user explicitly requested " + bundle);
        }
        List<Bundle> matches = Osgis.bundleFinder(this.framework).symbolicName(b.getSymbolicName()).version(b.getVersion().toString()).findAll();
        if (matches.isEmpty()) {
            log.error("OSGi could not find bundle " + nv + " in search after installing it from " + bundle);
        } else if (matches.size() == 1) {
            log.debug("Bundle from " + bundle.getUrl() + " successfully installed as " + nv + " (" + b + ")");
        } else {
            log.warn("OSGi has multiple bundles matching " + nv + ", when installing " + bundle + "; not guaranteed which versions will be consumed");
        }
    }

    private Bundle checkBundleInstalledThrowIfInconsistent(OsgiBundleWithUrl bundleMetadata, boolean requireUrlIfNotAlreadyPresent) {
        String bundleUrl = bundleMetadata.getUrl();
        if (bundleUrl != null) {
            Maybe<Bundle> installedBundle = Osgis.bundleFinder(this.framework).requiringFromUrl(bundleUrl).find();
            if (installedBundle.isPresent()) {
                Bundle b = (Bundle)installedBundle.get();
                String nv = b.getSymbolicName() + ":" + b.getVersion().toString();
                if (!OsgiManager.isBundleNameEqualOrAbsent(bundleMetadata, b)) {
                    throw new IllegalStateException("User requested bundle " + bundleMetadata + " but already installed as " + nv);
                }
                log.trace("Bundle from " + bundleUrl + " already installed as " + nv + "; not re-registering");
                return b;
            }
        } else {
            Maybe<Bundle> installedBundle = bundleMetadata.isNameResolved() ? Osgis.bundleFinder(this.framework).symbolicName(bundleMetadata.getSymbolicName()).version(bundleMetadata.getSuppliedVersionString()).find() : Maybe.absent((String)"Bundle metadata does not have URL nor does it have both name and version");
            if (installedBundle.isPresent()) {
                log.trace("Bundle " + bundleMetadata + " installed from " + ((Bundle)installedBundle.get()).getLocation());
            } else if (requireUrlIfNotAlreadyPresent) {
                throw new IllegalStateException("Bundle " + bundleMetadata + " not previously registered, but URL is empty.", Maybe.Absent.getException(installedBundle));
            }
            return (Bundle)installedBundle.orNull();
        }
        return null;
    }

    public static boolean isBundleNameEqualOrAbsent(OsgiBundleWithUrl bundle, Bundle b) {
        return !bundle.isNameResolved() || bundle.getSymbolicName().equals(b.getSymbolicName()) && bundle.getOsgiVersionString().equals(b.getVersion().toString());
    }

    public <T> Maybe<Class<T>> tryResolveClass(String type, OsgiBundleWithUrl ... osgiBundles) {
        return this.tryResolveClass(type, Arrays.asList(osgiBundles));
    }

    public <T> Maybe<Class<T>> tryResolveClass(String type, Iterable<? extends OsgiBundleWithUrl> osgiBundles) {
        MutableMap bundleProblems = MutableMap.of();
        MutableSet extraMessages = MutableSet.of();
        for (OsgiBundleWithUrl osgiBundleWithUrl : osgiBundles) {
            try {
                Maybe<Bundle> bundle = this.findBundle(osgiBundleWithUrl);
                if (bundle.isPresent()) {
                    String typeToLoad;
                    Bundle b = (Bundle)bundle.get();
                    Optional<String> strippedType = this.osgiClassPrefixer.stripMatchingPrefix(b, type);
                    String string = typeToLoad = strippedType.isPresent() ? (String)strippedType.get() : type;
                    if (this.osgiClassPrefixer.hasPrefix(typeToLoad)) {
                        bundleProblems.put(osgiBundleWithUrl, new UserFacingException("Bundle does not match prefix in type name '" + typeToLoad + "'"));
                        continue;
                    }
                    Class clazz = SystemFrameworkLoader.get().loadClassFromBundle(typeToLoad, b);
                    return Maybe.of((Object)clazz);
                }
                bundleProblems.put(osgiBundleWithUrl, Maybe.getException(bundle));
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                bundleProblems.put(osgiBundleWithUrl, e);
                Throwable cause = e.getCause();
                if (cause == null || cause.getMessage() == null || !cause.getMessage().contains("Unresolved constraint in bundle")) continue;
                if (BrooklynVersion.INSTANCE.getVersionFromOsgiManifest() == null) {
                    extraMessages.add("No brooklyn-core OSGi manifest available. OSGi will not work.");
                }
                if (BrooklynVersion.isDevelopmentEnvironment()) {
                    extraMessages.add("Your development environment may not have created necessary files. Doing a maven build then retrying may fix the issue.");
                }
                if (!extraMessages.isEmpty()) {
                    log.warn(Strings.join((Iterable)extraMessages, (String)" "));
                }
                log.warn("Unresolved constraint resolving OSGi bundle " + osgiBundleWithUrl + " to load " + type + ": " + cause.getMessage());
                if (!log.isDebugEnabled()) continue;
                log.debug("Trace for OSGi resolution failure", (Throwable)e);
            }
        }
        if (bundleProblems.size() == 1) {
            Throwable error = (Throwable)Iterables.getOnlyElement(bundleProblems.values());
            if (error instanceof ClassNotFoundException && error.getCause() != null && error.getCause().getMessage() != null) {
                error = Exceptions.collapseIncludingAllCausalMessages((Throwable)error);
            }
            return Maybe.absent((String)("Unable to resolve class " + type + " in " + Iterables.getOnlyElement(bundleProblems.keySet()) + (extraMessages.isEmpty() ? "" : " (" + Strings.join((Iterable)extraMessages, (String)" ") + ")")), (Throwable)error);
        }
        return Maybe.absent((Throwable)Exceptions.create((String)("Unable to resolve class " + type + ": " + bundleProblems + (extraMessages.isEmpty() ? "" : " (" + Strings.join((Iterable)extraMessages, (String)" ") + ")")), bundleProblems.values()));
    }

    protected Maybe<Bundle> findBundle(ManagedBundle managedBundle) {
        Bundle bundle;
        if (managedBundle.getOsgiUniqueUrl() != null && (bundle = this.framework.getBundleContext().getBundle(managedBundle.getOsgiUniqueUrl())) != null) {
            return Maybe.of((Object)bundle);
        }
        return this.findBundle((OsgiBundleWithUrl)managedBundle);
    }

    public Maybe<Bundle> findBundle(OsgiBundleWithUrl catalogBundle) {
        Osgis.BundleFinder bundleFinder;
        Maybe<Bundle> result = null;
        if (catalogBundle.getUrl() != null) {
            bundleFinder = Osgis.bundleFinder(this.framework);
            bundleFinder.requiringFromUrl(catalogBundle.getUrl());
            result = bundleFinder.find();
            if (result.isPresent()) {
                return result;
            }
            ManagedBundle mb = this.getManagedBundleFromUrl(catalogBundle.getUrl());
            if (mb != null) {
                bundleFinder.requiringFromUrl(null);
                bundleFinder.symbolicName(mb.getSymbolicName()).version(mb.getSuppliedVersionString());
                result = bundleFinder.find();
                if (result.isPresent()) {
                    return result;
                }
            }
        }
        if (catalogBundle.getSymbolicName() != null) {
            bundleFinder = Osgis.bundleFinder(this.framework);
            bundleFinder.symbolicName(catalogBundle.getSymbolicName()).version(catalogBundle.getSuppliedVersionString());
            return bundleFinder.find();
        }
        if (result != null) {
            return result;
        }
        return Maybe.absent((String)("Insufficient information in " + catalogBundle + " to find bundle"));
    }

    public URL getResource(String name, Iterable<? extends OsgiBundleWithUrl> osgiBundles) {
        for (OsgiBundleWithUrl osgiBundleWithUrl : osgiBundles) {
            try {
                URL result;
                Maybe<Bundle> bundle = this.findBundle(osgiBundleWithUrl);
                if (!bundle.isPresent()) continue;
                if (!name.endsWith(".class") && (result = ((Bundle)bundle.get()).getEntry(name)) != null) {
                    return result;
                }
                result = ((Bundle)bundle.get()).getResource(name);
                if (result == null) continue;
                return result;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
            }
        }
        return null;
    }

    public Iterable<URL> getResources(String name, Iterable<? extends OsgiBundleWithUrl> osgiBundles) {
        MutableSet resources = MutableSet.of();
        for (OsgiBundleWithUrl osgiBundleWithUrl : osgiBundles) {
            try {
                Maybe<Bundle> bundle = this.findBundle(osgiBundleWithUrl);
                if (!bundle.isPresent()) continue;
                boolean isClass = name.endsWith(".class");
                if (!isClass) {
                    resources.putIfNotNull((Object)((Bundle)bundle.get()).getEntry(name));
                }
                Enumeration result = ((Bundle)bundle.get()).getResources(name);
                resources.addAll(Collections.list(result));
                if (!isClass) continue;
                resources.putIfNotNull((Object)((Bundle)bundle.get()).getEntry(name));
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
            }
        }
        return resources;
    }

    public Framework getFramework() {
        return this.framework;
    }

    public void addInstalledWrapperBundle(ManagedBundle mb) {
        this.managedBundlesRecord.addInstalledWrapperBundle(mb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ManagedBundle> getInstalledWrapperBundles() {
        ManagedBundlesRecord managedBundlesRecord = this.managedBundlesRecord;
        synchronized (managedBundlesRecord) {
            return MutableSet.copyOf(this.managedBundlesRecord.wrapperBundles.values());
        }
    }

    public File getBundleFile(ManagedBundle mb) {
        return this.managedBundlesRecord.fileFor(mb);
    }

    class ManagedBundlesRecord {
        private final Map<String, ManagedBundle> managedBundlesByUid = MutableMap.of();
        private final Map<VersionedName, String> managedBundlesUidByVersionedName = MutableMap.of();
        private final Map<String, String> managedBundlesUidByUrl = MutableMap.of();
        private final Map<VersionedName, ManagedBundle> wrapperBundles = MutableMap.of();

        ManagedBundlesRecord() {
        }

        synchronized void clear() {
            this.managedBundlesByUid.clear();
            this.managedBundlesUidByVersionedName.clear();
            this.managedBundlesUidByUrl.clear();
            this.wrapperBundles.clear();
        }

        synchronized Map<String, ManagedBundle> getManagedBundles() {
            return ImmutableMap.copyOf(this.managedBundlesByUid);
        }

        synchronized String getManagedBundleId(VersionedName vn) {
            return this.managedBundlesUidByVersionedName.get(VersionedName.toOsgiVersionedName((VersionedName)vn));
        }

        synchronized ManagedBundle getManagedBundle(VersionedName vn) {
            return this.managedBundlesByUid.get(this.managedBundlesUidByVersionedName.get(VersionedName.toOsgiVersionedName((VersionedName)vn)));
        }

        synchronized String getManagedBundleIdFromUrl(String url) {
            return this.managedBundlesUidByUrl.get(url);
        }

        synchronized ManagedBundle getManagedBundleFromUrl(String url) {
            String id = this.getManagedBundleIdFromUrl(url);
            if (id == null) {
                return null;
            }
            return this.managedBundlesByUid.get(id);
        }

        synchronized void setManagedBundleUrl(String url, String id) {
            this.managedBundlesUidByUrl.put(url, id);
        }

        synchronized void addManagedBundle(OsgiBundleInstallationResult result, File f) {
            this.updateManagedBundleFileAndMetadata(result, f);
            this.managedBundlesUidByVersionedName.put(VersionedName.toOsgiVersionedName((VersionedName)result.getMetadata().getVersionedName()), result.getMetadata().getId());
            if (Strings.isNonBlank((CharSequence)result.getMetadata().getUrl())) {
                this.managedBundlesUidByUrl.put(result.getMetadata().getUrl(), result.getMetadata().getId());
            }
            FrameworkLookup.invalidateCaches();
        }

        private File fileFor(ManagedBundle managedBundle) {
            return new File(OsgiManager.this.brooklynBundlesCacheDir, managedBundle.getId() + "-" + managedBundle.getVersionedName().toOsgiString().replace(":", ".-.") + ".jar");
        }

        synchronized void addInstalledWrapperBundle(ManagedBundle mb) {
            this.wrapperBundles.put(mb.getVersionedName(), mb);
        }

        private synchronized void removeInstalledWrapperBundle(ManagedBundle mb) {
            this.wrapperBundles.remove(mb.getVersionedName());
        }

        synchronized boolean remove(ManagedBundle bundleMetadata) {
            ManagedBundle metadata = OsgiManager.this.managedBundlesRecord.managedBundlesByUid.remove(bundleMetadata.getId());
            if (metadata == null) {
                return false;
            }
            OsgiManager.this.managedBundlesRecord.managedBundlesUidByVersionedName.remove(bundleMetadata.getVersionedName());
            OsgiManager.this.managedBundlesRecord.managedBundlesUidByUrl.remove(bundleMetadata.getUrl());
            this.removeInstalledWrapperBundle(bundleMetadata);
            this.fileFor(bundleMetadata).delete();
            FrameworkLookup.invalidateCaches();
            return true;
        }

        synchronized Pair<File, ManagedBundle> updateManagedBundleFileAndMetadata(OsgiBundleInstallationResult result, File fNew) {
            File fCached = this.fileFor(result.getMetadata());
            File fBak = new File(fCached.getAbsolutePath() + ".bak");
            if (fBak.equals(fNew)) {
                throw new IllegalStateException("Cannot update to a backup copy; use rollback instead");
            }
            if (fCached.exists()) {
                log.debug("Replacing and backing up old Brooklyn local copy of bundle file " + fCached);
                fCached.renameTo(fBak);
            } else {
                log.debug("Creating Brooklyn local copy of bundle file " + fCached);
            }
            try (FileInputStream fin = new FileInputStream(fNew);
                 FileOutputStream fout = new FileOutputStream(fCached);){
                Streams.copy((InputStream)fin, (OutputStream)fout);
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            ManagedBundle mbBak = this.managedBundlesByUid.put(result.getMetadata().getId(), result.getMetadata());
            FrameworkLookup.invalidateCaches();
            return Pair.of((Object)fBak, (Object)mbBak);
        }

        synchronized File rollbackManagedBundleFileAndMetadata(OsgiBundleInstallationResult result, File fBak, ManagedBundle mbBak) {
            log.debug("Rolling back to back Brooklyn local copy of bundle file " + fBak);
            if (!fBak.exists()) {
                throw new IllegalStateException("Cannot rollback to " + fBak + " as file does not exist");
            }
            File fCached = this.fileFor(result.getMetadata());
            if (fCached.exists()) {
                fCached.delete();
            } else {
                log.warn("No pre-existing bundle file " + fCached + " when rolling back; ignoring");
            }
            fBak.renameTo(fCached);
            this.managedBundlesByUid.put(result.getMetadata().getId(), mbBak);
            FrameworkLookup.invalidateCaches();
            return fCached;
        }
    }
}

