/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs.proxy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.effector.EffectorWithBody;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.internal.EntityTransientCopyInternal;
import org.apache.brooklyn.core.mgmt.internal.EffectorUtils;
import org.apache.brooklyn.core.objs.proxy.AbstractBrooklynObjectProxyImpl;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityProxyImpl
extends AbstractBrooklynObjectProxyImpl<Entity>
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EntityProxyImpl.class);
    private static final Set<AbstractBrooklynObjectProxyImpl.MethodSignature> ENTITY_NON_EFFECTOR_METHODS = Sets.newLinkedHashSet();
    private static final Set<AbstractBrooklynObjectProxyImpl.MethodSignature> ENTITY_PERMITTED_READ_ONLY_METHODS;

    public EntityProxyImpl(Entity entity) {
        super((BrooklynObject)Preconditions.checkNotNull((Object)entity, (Object)"entity"));
    }

    @Override
    protected Entity getProxy(Entity instance, boolean requireNonProxy) {
        if (!requireNonProxy && !(instance instanceof AbstractEntity)) {
            return instance;
        }
        return ((AbstractEntity)instance).getProxy();
    }

    @Override
    protected void resetProxy(Entity instance, Entity preferredProxy) {
        ((AbstractEntity)instance).resetProxy(preferredProxy);
    }

    @Override
    protected boolean isPermittedReadOnlyMethod(AbstractBrooklynObjectProxyImpl.MethodSignature sig) {
        return ENTITY_PERMITTED_READ_ONLY_METHODS.contains(sig);
    }

    protected boolean isPermittedReadWriteStandardMethod(AbstractBrooklynObjectProxyImpl.MethodSignature sig) {
        return ENTITY_NON_EFFECTOR_METHODS.contains(sig);
    }

    @Override
    protected Object invokeOther(Method m, Object[] argsPreNullFix) throws IllegalAccessException, InvocationTargetException {
        Object[] args;
        AbstractBrooklynObjectProxyImpl.MethodSignature sig = new AbstractBrooklynObjectProxyImpl.MethodSignature(m);
        Object[] objectArray = args = argsPreNullFix == null ? new Object[]{} : argsPreNullFix;
        if (this.isPermittedReadWriteStandardMethod(sig)) {
            return m.invoke((Object)this.delegate, args);
        }
        Effector<?> eff = this.findEffector(m, args);
        if (eff != null) {
            Map parameters = EffectorUtils.prepareArgsForEffectorAsMapFromArray(eff, args);
            TaskAdaptable task = ((EffectorWithBody)eff).getBody().newTask((Entity)this.delegate, eff, ConfigBag.newInstance(parameters));
            TaskTags.markInessential(task);
            return DynamicTasks.get(task.asTask(), (Entity)this.delegate);
        }
        return super.invokeOther(m, args);
    }

    private Effector<?> findEffector(Method m, Object[] args) {
        String name = m.getName();
        Set effectors = ((Entity)this.delegate).getEntityType().getEffectors();
        for (Effector contender : effectors) {
            if (!name.equals(contender.getName())) continue;
            return contender;
        }
        return null;
    }

    static {
        for (Method m : Entity.class.getMethods()) {
            ENTITY_NON_EFFECTOR_METHODS.add(new AbstractBrooklynObjectProxyImpl.MethodSignature(m));
        }
        for (Method m : EntityLocal.class.getMethods()) {
            ENTITY_NON_EFFECTOR_METHODS.add(new AbstractBrooklynObjectProxyImpl.MethodSignature(m));
        }
        for (Method m : EntityInternal.class.getMethods()) {
            ENTITY_NON_EFFECTOR_METHODS.add(new AbstractBrooklynObjectProxyImpl.MethodSignature(m));
        }
        ENTITY_PERMITTED_READ_ONLY_METHODS = Sets.newLinkedHashSet();
        for (Method m : EntityTransientCopyInternal.class.getMethods()) {
            ENTITY_PERMITTED_READ_ONLY_METHODS.add(new AbstractBrooklynObjectProxyImpl.MethodSignature(m));
        }
        if (!ENTITY_NON_EFFECTOR_METHODS.containsAll(ENTITY_PERMITTED_READ_ONLY_METHODS)) {
            LinkedHashSet<AbstractBrooklynObjectProxyImpl.MethodSignature> extras = new LinkedHashSet<AbstractBrooklynObjectProxyImpl.MethodSignature>(ENTITY_PERMITTED_READ_ONLY_METHODS);
            extras.removeAll(ENTITY_NON_EFFECTOR_METHODS);
            throw new IllegalStateException("Entity read-only methods contains items not known as Entity methods: " + extras);
        }
        for (Method m : EntityTransientCopyInternal.SpecialEntityTransientCopyInternal.class.getMethods()) {
            ENTITY_PERMITTED_READ_ONLY_METHODS.add(new AbstractBrooklynObjectProxyImpl.MethodSignature(m));
        }
    }
}

