/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.javalang;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class UrlClassLoader
extends URLClassLoader {
    private URL[] urls;

    public UrlClassLoader(URL ... urls) {
        super(UrlClassLoader.tidy(urls));
        this.urls = urls;
    }

    public UrlClassLoader(String ... urls) {
        this(UrlClassLoader.asUrls(urls));
    }

    private static URL[] asUrls(String[] urls) {
        URL[] urlo = new URL[urls.length];
        try {
            for (int i = 0; i < urls.length; ++i) {
                urlo[i] = new URL(urls[i]);
            }
        }
        catch (MalformedURLException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return urlo;
    }

    private static URL[] tidy(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = ResourceUtils.tidy(urls[i]);
        }
        return urls;
    }

    public String toString() {
        return "UrlClassLoader" + Arrays.asList(this.urls);
    }
}

