/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.route53.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;
import org.jclouds.route53.Route53Api;
import org.jclouds.route53.domain.ResourceRecordSet;
import org.jclouds.route53.domain.ResourceRecordSetIterable;
import org.jclouds.route53.features.ResourceRecordSetApi;

@Beta
public class ResourceRecordSetIterableToPagedIterable
extends CallerArg0ToPagedIterable<ResourceRecordSet, ResourceRecordSetIterableToPagedIterable> {
    private final Route53Api api;

    @Inject
    protected ResourceRecordSetIterableToPagedIterable(Route53Api api) {
        this.api = (Route53Api)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<ResourceRecordSet>> markerToNextForCallingArg0(String zoneId) {
        final ResourceRecordSetApi resourceResourceRecordSetApi = this.api.getResourceRecordSetApiForHostedZone(zoneId);
        return new Function<Object, IterableWithMarker<ResourceRecordSet>>(){

            public IterableWithMarker<ResourceRecordSet> apply(Object input) {
                return resourceResourceRecordSetApi.listAt((ResourceRecordSetIterable.NextRecord)ResourceRecordSetIterable.NextRecord.class.cast(input));
            }

            public String toString() {
                return "listResourceRecordSets()";
            }
        };
    }
}

