// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
package com.cloud.user;

import java.util.Map;

import com.cloud.utils.db.GenericDao;

public interface AccountDetailsDao extends GenericDao<AccountDetailVO, Long> {
    Map<String, String> findDetails(long accountId);

    void persist(long accountId, Map<String, String> details);

    AccountDetailVO findDetail(long accountId, String name);

    void deleteDetails(long accountId);

    /*
     * For these existing entries, they will get updated. For these new entries,
     * they will get created
     */
    void update(long accountId, Map<String, String> details);

    String getActualValue(AccountDetailVO accountDetailVO);
}
