/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionDeleteQueueMessage
extends PacketImpl {
    private SimpleString queueName;

    public SessionDeleteQueueMessage(SimpleString queueName) {
        super((byte)35);
        this.queueName = queueName;
    }

    public SessionDeleteQueueMessage() {
        super((byte)35);
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", queueName=" + String.valueOf(this.queueName));
        return sb.toString();
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.queueName);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.queueName = buffer.readSimpleString();
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.queueName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionDeleteQueueMessage)) {
            return false;
        }
        SessionDeleteQueueMessage other = (SessionDeleteQueueMessage)obj;
        return Objects.equals(this.queueName, other.queueName);
    }
}

