/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.files;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreMonitor
extends ActiveMQScheduledComponent {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Set<Callback> callbackList = new HashSet<Callback>();
    private final Set<FileStore> stores = new HashSet<FileStore>();
    private Double maxUsage;
    private Long minDiskFree;
    private final Object monitorLock = new Object();
    private final IOCriticalErrorListener ioCriticalErrorListener;
    private final FileStoreMonitorType type;

    public FileStoreMonitor(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, Number referenceValue, IOCriticalErrorListener ioCriticalErrorListener, FileStoreMonitorType type) {
        super(scheduledExecutorService, executor, checkPeriod, timeUnit, false);
        this.type = type;
        if (type == FileStoreMonitorType.MaxDiskUsage) {
            this.maxUsage = referenceValue.doubleValue();
        } else {
            this.minDiskFree = referenceValue.longValue();
        }
        this.ioCriticalErrorListener = ioCriticalErrorListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStoreMonitor addCallback(Callback callback) {
        Object object = this.monitorLock;
        synchronized (object) {
            this.callbackList.add(callback);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStoreMonitor removeCallback(Callback callback) {
        Object object = this.monitorLock;
        synchronized (object) {
            this.callbackList.remove(callback);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStoreMonitor addStore(File file) throws IOException {
        Object object = this.monitorLock;
        synchronized (object) {
            if (file != null && file.exists()) {
                try {
                    this.addStore(Files.getFileStore(file.toPath()));
                }
                catch (IOException e) {
                    logger.error("Error getting file store for {}", (Object)file.getAbsolutePath(), (Object)e);
                    throw e;
                }
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStoreMonitor addStore(FileStore store) {
        Object object = this.monitorLock;
        synchronized (object) {
            this.stores.add(store);
            return this;
        }
    }

    public void run() {
        this.tick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        Object object = this.monitorLock;
        synchronized (object) {
            boolean ok = true;
            long usableSpace = 0L;
            long totalSpace = 0L;
            for (FileStore store : this.stores) {
                try {
                    usableSpace = store.getUsableSpace();
                    totalSpace = this.getTotalSpace(store);
                    if (this.type == FileStoreMonitorType.MinDiskFree) {
                        ok = usableSpace > this.minDiskFree;
                    } else {
                        boolean bl = ok = FileStoreMonitor.calculateUsage(usableSpace, totalSpace) < this.maxUsage;
                    }
                    if (ok) continue;
                    break;
                }
                catch (IOException ioe) {
                    this.ioCriticalErrorListener.onIOException((Throwable)ioe, "IO Error while calculating disk usage", null);
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            for (Callback callback : this.callbackList) {
                callback.tick(usableSpace, totalSpace, ok, this.type);
            }
        }
    }

    public double getMaxUsage() {
        return this.maxUsage;
    }

    public long getMinDiskFree() {
        return this.minDiskFree;
    }

    public FileStoreMonitor setMaxUsage(double maxUsage) {
        this.maxUsage = maxUsage;
        return this;
    }

    public FileStoreMonitor setMinDiskFree(long minDiskFree) {
        this.minDiskFree = minDiskFree;
        return this;
    }

    public static double calculateUsage(long usableSpace, long totalSpace) {
        if (totalSpace == 0L) {
            return 0.0;
        }
        return 1.0 - (double)usableSpace / (double)totalSpace;
    }

    private long getTotalSpace(FileStore store) throws IOException {
        long totalSpace = store.getTotalSpace();
        if (totalSpace < 0L) {
            totalSpace = Long.MAX_VALUE;
        }
        return totalSpace;
    }

    public static enum FileStoreMonitorType {
        MaxDiskUsage,
        MinDiskFree;

    }

    public static interface Callback {
        public void tick(long var1, long var3, boolean var5, FileStoreMonitorType var6);
    }
}

