/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.layers;

import java.io.OutputStream;
import org.apache.daffodil.api.layers.Layer;
import org.apache.daffodil.io.DataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.runtime1.layers.LayerRuntime;
import org.apache.daffodil.runtime1.layers.LayerVarsRuntime;
import scala.Int$;

public class JavaIOOutputStream
extends OutputStream {
    private final DataOutputStream dos;
    private final Layer layer;
    private boolean closed;
    private int nBytes;

    public JavaIOOutputStream(DataOutputStream dos, Layer layer) {
        this.dos = dos;
        this.layer = layer;
        this.closed = false;
        this.nBytes = 0;
    }

    private LayerRuntime lr() {
        return this.layer.getLayerRuntime();
    }

    private LayerVarsRuntime lvr() {
        return this.lr().layerVarsRuntime();
    }

    private FormatInfo finfo() {
        return this.lr().finfo();
    }

    @Override
    public void write(int b) {
        boolean wasWritten = this.dos.putLong(Int$.MODULE$.int2long(b), 8, this.finfo());
        if (wasWritten) {
            ++this.nBytes;
            return;
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.dos.setFinished(this.finfo());
            try {
                this.lvr().callGettersToPopulateResultVars(this.layer);
            }
            finally {
                this.closed = true;
            }
            return;
        }
    }
}

