/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Comparator;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.PartitioningFeature;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.SketchPartitionLimits;
import org.apache.datasketches.quantilescommon.SortedView;

public interface GenericSortedView<T>
extends PartitioningFeature<T>,
SketchPartitionLimits,
SortedView {
    default public double[] getCDF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        GenericSortedView.validateItems(splitPoints, this.getComparator());
        int len = splitPoints.length + 1;
        double[] buckets = new double[len];
        for (int i = 0; i < len - 1; ++i) {
            buckets[i] = this.getRank(splitPoints[i], searchCrit);
        }
        buckets[len - 1] = 1.0;
        return buckets;
    }

    public Comparator<? super T> getComparator();

    public T getMaxItem();

    public T getMinItem();

    default public double[] getPMF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        GenericSortedView.validateItems(splitPoints, this.getComparator());
        double[] buckets = this.getCDF(splitPoints, searchCrit);
        int i = buckets.length;
        while (i-- > 1) {
            int n = i;
            buckets[n] = buckets[n] - buckets[i - 1];
        }
        return buckets;
    }

    public T getQuantile(double var1, QuantileSearchCriteria var3);

    public T[] getQuantiles();

    public double getRank(T var1, QuantileSearchCriteria var2);

    @Override
    public GenericSortedViewIterator<T> iterator();

    public static <T> void validateItems(T[] items, Comparator<? super T> comparator) {
        int len = items.length;
        if (len == 1 && items[0] == null) {
            throw new SketchesArgumentException("Items must be unique, monotonically increasing and not null.");
        }
        for (int j = 0; j < len - 1; ++j) {
            if (items[j] != null && items[j + 1] != null && comparator.compare(items[j], items[j + 1]) < 0) continue;
            throw new SketchesArgumentException("Items must be unique, monotonically increasing and not null.");
        }
    }
}

