/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BitPacking;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.DirectCompactCompressedSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.ForwardCompatibility;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapCompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.WrappedCompactCompressedSketch;
import org.apache.datasketches.theta.WrappedCompactSketch;
import org.apache.datasketches.thetacommon.ThetaUtil;

public abstract class CompactSketch
extends Sketch {
    public static CompactSketch heapify(Memory srcMem) {
        return CompactSketch.heapify(srcMem, 9001L, false);
    }

    public static CompactSketch heapify(Memory srcMem, long expectedSeed) {
        return CompactSketch.heapify(srcMem, expectedSeed, true);
    }

    private static CompactSketch heapify(Memory srcMem, long seed, boolean enforceSeed) {
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        Family family = Family.idToFamily(familyID);
        if (family != Family.COMPACT) {
            throw new IllegalArgumentException("Corrupted: " + String.valueOf((Object)family) + " is not Compact!");
        }
        if (serVer == 4) {
            return CompactSketch.heapifyV4(srcMem, seed, enforceSeed);
        }
        if (serVer == 3) {
            boolean empty;
            int flags = PreambleUtil.extractFlags(srcMem);
            boolean srcOrdered = (flags & 0x10) != 0;
            boolean bl = empty = (flags & 4) != 0;
            if (enforceSeed && !empty) {
                PreambleUtil.checkMemorySeedHash(srcMem, seed);
            }
            return CompactOperations.memoryToCompact(srcMem, srcOrdered, null);
        }
        short seedHash = ThetaUtil.computeSeedHash(seed);
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, seedHash);
        }
        if (serVer == 2) {
            return ForwardCompatibility.heapify2to3(srcMem, enforceSeed ? seedHash : (short)PreambleUtil.extractSeedHash(srcMem));
        }
        throw new SketchesArgumentException("Unknown Serialization Version: " + serVer);
    }

    public static CompactSketch wrap(Memory srcMem) {
        return CompactSketch.wrap(srcMem, 9001L, false);
    }

    public static CompactSketch wrap(Memory srcMem, long expectedSeed) {
        return CompactSketch.wrap(srcMem, expectedSeed, true);
    }

    private static CompactSketch wrap(Memory srcMem, long seed, boolean enforceSeed) {
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        Family family = Family.idToFamily(familyID);
        if (family != Family.COMPACT) {
            throw new IllegalArgumentException("Corrupted: " + String.valueOf((Object)family) + " is not Compact!");
        }
        short seedHash = ThetaUtil.computeSeedHash(seed);
        if (serVer == 4) {
            return DirectCompactCompressedSketch.wrapInstance(srcMem, enforceSeed ? seedHash : (short)PreambleUtil.extractSeedHash(srcMem));
        }
        if (serVer == 3) {
            boolean readOnly;
            boolean compactFlag;
            if (PreambleUtil.isEmptyFlag(srcMem)) {
                return EmptyCompactSketch.getHeapInstance(srcMem);
            }
            if (SingleItemSketch.otherCheckForSingleItem(srcMem)) {
                return SingleItemSketch.heapify(srcMem, enforceSeed ? seedHash : (short)PreambleUtil.extractSeedHash(srcMem));
            }
            int flags = PreambleUtil.extractFlags(srcMem);
            boolean bl = compactFlag = (flags & 8) > 0;
            if (!compactFlag) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have compact flag set");
            }
            boolean bl2 = readOnly = (flags & 2) > 0;
            if (!readOnly) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have Read-Only flag set");
            }
            return DirectCompactSketch.wrapInstance(srcMem, enforceSeed ? seedHash : (short)PreambleUtil.extractSeedHash(srcMem));
        }
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(srcMem, seedHash);
        }
        if (serVer == 2) {
            return ForwardCompatibility.heapify2to3(srcMem, enforceSeed ? seedHash : (short)PreambleUtil.extractSeedHash(srcMem));
        }
        throw new SketchesArgumentException("Corrupted: Serialization Version " + serVer + " not recognized.");
    }

    public static CompactSketch wrap(byte[] bytes) {
        return CompactSketch.wrap(bytes, 9001L, false);
    }

    public static CompactSketch wrap(byte[] bytes, long expectedSeed) {
        return CompactSketch.wrap(bytes, expectedSeed, true);
    }

    private static CompactSketch wrap(byte[] bytes, long seed, boolean enforceSeed) {
        byte serVer = bytes[1];
        byte familyId = bytes[2];
        Family family = Family.idToFamily(familyId);
        if (family != Family.COMPACT) {
            throw new IllegalArgumentException("Corrupted: " + String.valueOf((Object)family) + " is not Compact!");
        }
        short seedHash = ThetaUtil.computeSeedHash(seed);
        if (serVer == 4) {
            return WrappedCompactCompressedSketch.wrapInstance(bytes, seedHash);
        }
        if (serVer == 3) {
            boolean readOnly;
            boolean compactFlag;
            byte flags = bytes[5];
            if ((flags & 4) > 0) {
                return EmptyCompactSketch.getHeapInstance(Memory.wrap((byte[])bytes));
            }
            byte preLongs = bytes[0];
            if (SingleItemSketch.otherCheckForSingleItem(preLongs, serVer, familyId, flags)) {
                return SingleItemSketch.heapify(Memory.wrap((byte[])bytes), enforceSeed ? seedHash : ByteArrayUtil.getShortLE(bytes, 6));
            }
            boolean bl = compactFlag = (flags & 8) > 0;
            if (!compactFlag) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have compact flag set");
            }
            boolean bl2 = readOnly = (flags & 2) > 0;
            if (!readOnly) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have Read-Only flag set");
            }
            return WrappedCompactSketch.wrapInstance(bytes, enforceSeed ? seedHash : ByteArrayUtil.getShortLE(bytes, 6));
        }
        if (serVer == 1) {
            return ForwardCompatibility.heapify1to3(Memory.wrap((byte[])bytes), seedHash);
        }
        if (serVer == 2) {
            return ForwardCompatibility.heapify2to3(Memory.wrap((byte[])bytes), enforceSeed ? seedHash : ByteArrayUtil.getShortLE(bytes, 6));
        }
        throw new SketchesArgumentException("Corrupted: Serialization Version " + serVer + " not recognized.");
    }

    @Override
    public abstract CompactSketch compact(boolean var1, WritableMemory var2);

    @Override
    public int getCompactBytes() {
        return this.getCurrentBytes();
    }

    @Override
    int getCurrentDataLongs() {
        return this.getRetainedEntries(true);
    }

    @Override
    public Family getFamily() {
        return Family.COMPACT;
    }

    @Override
    public boolean isCompact() {
        return true;
    }

    @Override
    public double getEstimate() {
        return Sketch.estimate(this.getThetaLong(), this.getRetainedEntries());
    }

    public byte[] toByteArrayCompressed() {
        if (!this.isOrdered() || this.getRetainedEntries() == 0 || this.getRetainedEntries() == 1 && !this.isEstimationMode()) {
            return this.toByteArray();
        }
        return this.toByteArrayV4();
    }

    private int computeMinLeadingZeros() {
        long previous = 0L;
        long ored = 0L;
        HashIterator it = this.iterator();
        while (it.next()) {
            long delta = it.get() - previous;
            ored |= delta;
            previous = it.get();
        }
        return Long.numberOfLeadingZeros(ored);
    }

    private byte[] toByteArrayV4() {
        int preambleLongs = this.isEstimationMode() ? 2 : 1;
        int entryBits = 64 - this.computeMinLeadingZeros();
        int compressedBits = entryBits * this.getRetainedEntries();
        int numEntriesBytes = PreambleUtil.wholeBytesToHoldBits(32 - Integer.numberOfLeadingZeros(this.getRetainedEntries()));
        int sizeBytes = preambleLongs * 8 + numEntriesBytes + PreambleUtil.wholeBytesToHoldBits(compressedBits);
        byte[] bytes = new byte[sizeBytes];
        WritableMemory mem = WritableMemory.writableWrap((byte[])bytes);
        int offsetBytes = 0;
        mem.putByte((long)offsetBytes++, (byte)preambleLongs);
        mem.putByte((long)offsetBytes++, (byte)4);
        mem.putByte((long)offsetBytes++, (byte)Family.COMPACT.getID());
        mem.putByte((long)offsetBytes++, (byte)entryBits);
        mem.putByte((long)offsetBytes++, (byte)numEntriesBytes);
        mem.putByte((long)offsetBytes++, (byte)26);
        mem.putShort((long)offsetBytes, this.getSeedHash());
        offsetBytes += 2;
        if (this.isEstimationMode()) {
            mem.putLong((long)offsetBytes, this.getThetaLong());
            offsetBytes += 8;
        }
        int numEntries = this.getRetainedEntries();
        for (int i = 0; i < numEntriesBytes; ++i) {
            mem.putByte((long)offsetBytes++, (byte)(numEntries & 0xFF));
            numEntries >>>= 8;
        }
        long previous = 0L;
        long[] deltas = new long[8];
        HashIterator it = this.iterator();
        int i = 0;
        while (i + 7 < this.getRetainedEntries()) {
            for (int j = 0; j < 8; ++j) {
                it.next();
                deltas[j] = it.get() - previous;
                previous = it.get();
            }
            BitPacking.packBitsBlock8(deltas, 0, bytes, offsetBytes, entryBits);
            offsetBytes += entryBits;
            i += 8;
        }
        int offsetBits = 0;
        while (i < this.getRetainedEntries()) {
            it.next();
            long delta = it.get() - previous;
            previous = it.get();
            BitPacking.packBits(delta, entryBits, bytes, offsetBytes, offsetBits);
            offsetBytes += offsetBits + entryBits >>> 3;
            offsetBits = offsetBits + entryBits & 7;
            ++i;
        }
        return bytes;
    }

    private static CompactSketch heapifyV4(Memory srcMem, long seed, boolean enforceSeed) {
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        int entryBits = PreambleUtil.extractEntryBitsV4(srcMem);
        int numEntriesBytes = PreambleUtil.extractNumEntriesBytesV4(srcMem);
        short seedHash = (short)PreambleUtil.extractSeedHash(srcMem);
        if (enforceSeed) {
            PreambleUtil.checkMemorySeedHash(srcMem, seed);
        }
        int offsetBytes = 8;
        long theta = Long.MAX_VALUE;
        if (preLongs > 1) {
            theta = PreambleUtil.extractThetaLongV4(srcMem);
            offsetBytes += 8;
        }
        int numEntries = 0;
        for (int i = 0; i < numEntriesBytes; ++i) {
            numEntries |= Byte.toUnsignedInt(srcMem.getByte((long)offsetBytes++)) << (i << 3);
        }
        long[] entries = new long[numEntries];
        byte[] bytes = new byte[entryBits];
        int i = 0;
        while (i + 7 < numEntries) {
            srcMem.getByteArray((long)offsetBytes, bytes, 0, entryBits);
            BitPacking.unpackBitsBlock8(entries, i, bytes, 0, entryBits);
            offsetBytes += entryBits;
            i += 8;
        }
        if (i < numEntries) {
            srcMem.getByteArray((long)offsetBytes, bytes, 0, PreambleUtil.wholeBytesToHoldBits((numEntries - i) * entryBits));
            int offsetBits = 0;
            offsetBytes = 0;
            while (i < numEntries) {
                BitPacking.unpackBits(entries, i, entryBits, bytes, offsetBytes, offsetBits);
                offsetBytes += offsetBits + entryBits >>> 3;
                offsetBits = offsetBits + entryBits & 7;
                ++i;
            }
        }
        long previous = 0L;
        for (i = 0; i < numEntries; ++i) {
            int n = i;
            entries[n] = entries[n] + previous;
            previous = entries[i];
        }
        return new HeapCompactSketch(entries, false, seedHash, numEntries, theta, true);
    }
}

