/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.sampling;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.sampling.ReservoirItemsSketch;
import org.apache.datasketches.sampling.VarOptItemsSamples;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.datasketches.sampling.VarOptItemsSketchTest;
import org.apache.datasketches.sampling.VarOptItemsUnion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VarOptItemsUnionTest {
    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k = 25;
        int n = 30;
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)25);
        union.update(VarOptItemsSketchTest.getUnweightedLongsVIS(25, 30));
        byte[] bytes = union.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        seg.set(ValueLayout.JAVA_BYTE, 1L, (byte)0);
        VarOptItemsUnion.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadPreLongs() {
        int k = 25;
        int n = 30;
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)25);
        union.update(VarOptItemsSketchTest.getUnweightedLongsVIS(25, 30));
        byte[] bytes = union.toByteArray((ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        MemorySegment seg = MemorySegment.ofArray(bytes);
        seg.set(ValueLayout.JAVA_BYTE, 0L, (byte)(Family.VAROPT.getMinPreLongs() - 1));
        VarOptItemsUnion.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)new ArrayOfLongsSerDe());
        Assert.fail();
    }

    @Test
    public void unionEmptySketch() {
        int k = 2048;
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] sketchBytes = VarOptItemsSketch.newInstance((int)2048).toByteArray((ArrayOfItemsSerDe)serDe);
        MemorySegment seg = MemorySegment.ofArray(sketchBytes);
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)2048);
        union.update(seg, (ArrayOfItemsSerDe)serDe);
        VarOptItemsSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)0L);
        Assert.assertEquals((int)result.getHRegionCount(), (int)0);
        Assert.assertEquals((int)result.getRRegionCount(), (int)0);
        Assert.assertTrue((boolean)Double.isNaN(result.getTau()));
    }

    @Test
    public void unionTwoExactSketches() {
        int n = 4;
        int k = 10;
        VarOptItemsSketch sk1 = VarOptItemsSketch.newInstance((int)10);
        VarOptItemsSketch sk2 = VarOptItemsSketch.newInstance((int)10);
        for (int i = 1; i <= 4; ++i) {
            sk1.update((Object)i, (double)i);
            sk2.update((Object)(-i), (double)i);
        }
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)10);
        union.update(sk1);
        union.update(sk2);
        VarOptItemsSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)8L);
        Assert.assertEquals((int)result.getHRegionCount(), (int)8);
        Assert.assertEquals((int)result.getRRegionCount(), (int)0);
    }

    @Test
    public void unionHeavySamplingSketch() {
        int i;
        int n1 = 20;
        int k1 = 10;
        int n2 = 6;
        int k2 = 5;
        VarOptItemsSketch sk1 = VarOptItemsSketch.newInstance((int)10);
        VarOptItemsSketch sk2 = VarOptItemsSketch.newInstance((int)5);
        for (i = 1; i <= 20; ++i) {
            sk1.update((Object)i, (double)i);
        }
        for (i = 1; i < 6; ++i) {
            sk2.update((Object)(-i), (double)i + 1000.0);
        }
        sk2.update((Object)-6, 1000000.0);
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)10);
        union.update(sk1);
        union.update(sk2);
        VarOptItemsSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)26L);
        Assert.assertEquals((int)result.getK(), (int)5);
        Assert.assertEquals((int)result.getHRegionCount(), (int)1);
        Assert.assertEquals((int)result.getRRegionCount(), (int)4);
        union.reset();
        Assert.assertEquals((double)union.getOuterTau(), (double)0.0);
        result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)10);
        Assert.assertEquals((long)result.getN(), (long)0L);
    }

    @Test
    public void unionIdenticalSamplingSketches() {
        int k = 20;
        int n = 50;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(20, 50);
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)20);
        union.update(sketch);
        union.update(sketch);
        VarOptItemsSketch result = union.getResult();
        double expectedWeight = 100.0;
        Assert.assertEquals((long)result.getN(), (long)100L);
        Assert.assertEquals((double)result.getTotalWtR(), (double)expectedWeight);
        sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(20, 21);
        union.update(sketch);
        result = union.getResult();
        expectedWeight = 121.0;
        Assert.assertEquals((long)result.getN(), (long)121L);
        Assert.assertEquals((double)result.getTotalWtR(), (double)expectedWeight, (double)1.0E-10);
        union.reset();
        Assert.assertEquals((double)union.getOuterTau(), (double)0.0);
        result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)20);
        Assert.assertEquals((long)result.getN(), (long)0L);
    }

    @Test
    public void unionSmallSamplingSketch() {
        int kSmall = 16;
        int n1 = 32;
        int n2 = 64;
        int kMax = 128;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(16, 32);
        sketch.update((Object)-1L, 34.0);
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)128);
        union.update(sketch);
        sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(16, 64);
        union.update(sketch);
        VarOptItemsSketch result = union.getResult();
        Assert.assertEquals((long)result.getN(), (long)97L);
        Assert.assertEquals((double)result.getTotalWtR(), (double)96.0, (double)1.0E-10);
    }

    @Test
    public void unionExactReservoirSketch() {
        int k = 20;
        long n = 40L;
        VarOptItemsSketch baseVis = VarOptItemsSketch.newInstance((int)20);
        for (long i = 1L; i <= 40L; ++i) {
            baseVis.update((Object)(-i), (double)i);
        }
        baseVis.update((Object)-41L, 1600.0);
        baseVis.update((Object)-42L, 1600.0);
        baseVis.update((Object)-43L, 1600.0);
        VarOptItemsUnion union1 = VarOptItemsUnion.newInstance((int)20);
        union1.update(baseVis);
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        MemorySegment unionImg = MemorySegment.ofArray(union1.toByteArray((ArrayOfItemsSerDe)serDe));
        VarOptItemsUnion union2 = VarOptItemsUnion.heapify((MemorySegment)unionImg, (ArrayOfItemsSerDe)serDe);
        VarOptItemsUnionTest.compareUnionsExact(union1, union2);
        VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)20);
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)20);
        union2.update((ReservoirItemsSketch)null);
        union2.update(ris);
        VarOptItemsUnionTest.compareUnionsExact(union1, union2);
        for (long i = 1L; i < 19L; ++i) {
            ris.update((Object)i);
            vis.update((Object)i, 1.0);
        }
        union1.update(vis);
        union2.update(ris);
        VarOptItemsUnionTest.compareUnionsEquivalent(union1, union2);
    }

    @Test
    public void unionSamplingReservoirSketch() {
        int k = 20;
        long n = 400L;
        VarOptItemsUnion union1 = VarOptItemsUnion.newInstance((int)20);
        VarOptItemsUnion union2 = VarOptItemsUnion.newInstance((int)20);
        VarOptItemsUnionTest.compareUnionsExact(union1, union2);
        VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)20);
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)20);
        for (long i = 1L; i < 400L; ++i) {
            ris.update((Object)i);
            vis.update((Object)i, 1.0);
        }
        union1.update(vis);
        union2.update(ris);
        VarOptItemsUnionTest.compareUnionsEquivalent(union1, union2);
        union1.update(vis);
        union2.update(ris);
        VarOptItemsUnionTest.compareUnionsEquivalent(union1, union2);
        VarOptItemsSketch newVis = VarOptItemsSketch.newInstance((int)20);
        for (long i = 1L; i <= 400L; ++i) {
            newVis.update((Object)(-i), (double)i);
        }
        newVis.update((Object)-401L, 160000.0);
        newVis.update((Object)-402L, 160000.0);
        newVis.update((Object)-403L, 160000.0);
        union1.update(newVis);
        union2.update(newVis);
        VarOptItemsUnionTest.compareUnionsEquivalent(union1, union2);
    }

    @Test
    public void unionReservoirVariousTauValues() {
        long i;
        int k = 20;
        long n = 40L;
        VarOptItemsSketch baseVis = VarOptItemsSketch.newInstance((int)20);
        for (long i2 = 1L; i2 <= 40L; ++i2) {
            baseVis.update((Object)(-i2), 1.0);
        }
        VarOptItemsUnion union1 = VarOptItemsUnion.newInstance((int)20);
        union1.update(baseVis);
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        MemorySegment unionImg = MemorySegment.ofArray(union1.toByteArray((ArrayOfItemsSerDe)serDe));
        VarOptItemsUnion union2 = VarOptItemsUnion.heapify((MemorySegment)unionImg, (ArrayOfItemsSerDe)serDe);
        VarOptItemsUnionTest.compareUnionsExact(union1, union2);
        VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)20);
        ReservoirItemsSketch ris = ReservoirItemsSketch.newInstance((int)20);
        for (i = 1L; i < 80L; ++i) {
            ris.update((Object)i);
            vis.update((Object)i, 1.0);
        }
        union1.update(vis);
        union2.update(ris);
        VarOptItemsUnionTest.compareUnionsEquivalent(union1, union2);
        vis = VarOptItemsSketch.newInstance((int)20);
        ris = ReservoirItemsSketch.newInstance((int)20);
        for (i = 1L; i <= 21L; ++i) {
            ris.update((Object)i);
            vis.update((Object)i, 1.0);
        }
        union1.update(vis);
        union2.update(ris);
        VarOptItemsUnionTest.compareUnionsEquivalent(union1, union2);
    }

    @Test
    public void serializeEmptyUnion() {
        int k = 100;
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)100);
        union.update((VarOptItemsSketch)null);
        union.update(null, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
        ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
        byte[] bytes = union.toByteArray((ArrayOfItemsSerDe)serDe);
        Assert.assertEquals((int)bytes.length, (int)8);
        MemorySegment seg = MemorySegment.ofArray(bytes);
        VarOptItemsUnion rebuilt = VarOptItemsUnion.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)serDe);
        VarOptItemsSketch sketch = rebuilt.getResult();
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((String)rebuilt.toString(), (String)union.toString());
    }

    @Test
    public void serializeExactUnion() {
        int n1 = 32;
        int n2 = 64;
        int k = 128;
        VarOptItemsSketch<Long> sketch1 = VarOptItemsSketchTest.getUnweightedLongsVIS(128, 32);
        VarOptItemsSketch<Long> sketch2 = VarOptItemsSketchTest.getUnweightedLongsVIS(128, 64);
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)128);
        union.update(sketch1);
        union.update(sketch2);
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        byte[] unionBytes = union.toByteArray((ArrayOfItemsSerDe)serDe);
        MemorySegment seg = MemorySegment.ofArray(unionBytes);
        VarOptItemsUnion rebuilt = VarOptItemsUnion.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)serDe);
        VarOptItemsUnionTest.compareUnionsExact(rebuilt, union);
        Assert.assertEquals((String)rebuilt.toString(), (String)union.toString());
    }

    @Test
    public void serializeSamplingUnion() {
        int n = 256;
        int k = 128;
        VarOptItemsSketch<Long> sketch = VarOptItemsSketchTest.getUnweightedLongsVIS(128, 256);
        sketch.update((Object)257L, 1000.0);
        sketch.update((Object)258L, 1001.0);
        sketch.update((Object)259L, 1002.0);
        sketch.update((Object)260L, 1003.0);
        sketch.update((Object)261L, 1004.0);
        sketch.update((Object)262L, 1005.0);
        sketch.update((Object)263L, 1006.0);
        sketch.update((Object)264L, 1007.0);
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)128);
        union.update(sketch);
        ArrayOfLongsSerDe serDe = new ArrayOfLongsSerDe();
        byte[] unionBytes = union.toByteArray((ArrayOfItemsSerDe)serDe);
        MemorySegment seg = MemorySegment.ofArray(unionBytes);
        VarOptItemsUnion rebuilt = VarOptItemsUnion.heapify((MemorySegment)seg, (ArrayOfItemsSerDe)serDe);
        VarOptItemsUnionTest.compareUnionsExact(rebuilt, union);
        Assert.assertEquals((String)rebuilt.toString(), (String)union.toString());
    }

    private static <T> void compareUnionsExact(VarOptItemsUnion<T> u1, VarOptItemsUnion<T> u2) {
        Assert.assertEquals((double)u1.getOuterTau(), (double)u2.getOuterTau());
        VarOptItemsSketch sketch1 = u1.getResult();
        VarOptItemsSketch sketch2 = u2.getResult();
        Assert.assertEquals((long)sketch1.getN(), (long)sketch2.getN());
        Assert.assertEquals((int)sketch1.getHRegionCount(), (int)sketch2.getHRegionCount());
        Assert.assertEquals((int)sketch1.getRRegionCount(), (int)sketch2.getRRegionCount());
        VarOptItemsSamples s1 = sketch1.getSketchSamples();
        VarOptItemsSamples s2 = sketch2.getSketchSamples();
        Assert.assertEquals((int)s1.getNumSamples(), (int)s2.getNumSamples());
        Assert.assertEquals((double[])s1.weights(), (double[])s2.weights());
        Assert.assertEquals((Object[])s1.items(), (Object[])s2.items());
    }

    private static <T> void compareUnionsEquivalent(VarOptItemsUnion<T> u1, VarOptItemsUnion<T> u2) {
        Assert.assertEquals((double)u1.getOuterTau(), (double)u2.getOuterTau());
        VarOptItemsSketch sketch1 = u1.getResult();
        VarOptItemsSketch sketch2 = u2.getResult();
        Assert.assertEquals((long)sketch1.getN(), (long)sketch2.getN());
        Assert.assertEquals((int)sketch1.getHRegionCount(), (int)sketch2.getHRegionCount());
        Assert.assertEquals((int)sketch1.getRRegionCount(), (int)sketch2.getRRegionCount());
        VarOptItemsSamples s1 = sketch1.getSketchSamples();
        VarOptItemsSamples s2 = sketch2.getSketchSamples();
        Assert.assertEquals((int)s1.getNumSamples(), (int)s2.getNumSamples());
        Assert.assertEquals((double[])s1.weights(), (double[])s2.weights());
        for (int i = 0; i < sketch1.getHRegionCount(); ++i) {
            Assert.assertEquals((Object)s1.items(i), (Object)s2.items(i));
        }
    }

    private static void println(String msg) {
    }
}

