/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.adouble;

import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.UpdatableTupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleTupleSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AdoubleTest {
    private final DoubleSummary.Mode mode = DoubleSummary.Mode.Sum;

    @Test
    public void isEmpty() {
        int lgK = 12;
        DoubleTupleSketch sketch = new DoubleTupleSketch(12, this.mode);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        Assert.assertNotNull((Object)sketch.toString());
        TupleSketchIterator it = sketch.iterator();
        Assert.assertNotNull((Object)it);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void checkLowK() {
        UpdatableTupleSketchBuilder bldr = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Sum));
        bldr.setNominalEntries(16);
        UpdatableTupleSketch sk = bldr.build();
        Assert.assertEquals((int)sk.getLgK(), (int)4);
    }

    @Test
    public void serDeTest() {
        int lgK = 12;
        int K = 4096;
        DoubleTupleSketch a1Sk = new DoubleTupleSketch(12, DoubleSummary.Mode.AlwaysOne);
        int m = 8192;
        for (int key = 0; key < 8192; ++key) {
            a1Sk.update((long)key, Double.valueOf(1.0));
        }
        double est1 = a1Sk.getEstimate();
        MemorySegment seg = MemorySegment.ofArray(a1Sk.toByteArray());
        DoubleTupleSketch a1Sk2 = new DoubleTupleSketch(seg, DoubleSummary.Mode.AlwaysOne);
        double est2 = a1Sk2.getEstimate();
        Assert.assertEquals((double)est1, (double)est2);
    }

    @Test
    public void checkStringKey() {
        int lgK = 12;
        int K = 4096;
        DoubleTupleSketch a1Sk1 = new DoubleTupleSketch(12, DoubleSummary.Mode.AlwaysOne);
        int m = 2048;
        for (int key = 0; key < 2048; ++key) {
            a1Sk1.update(Integer.toHexString(key), Double.valueOf(1.0));
        }
        Assert.assertEquals((double)a1Sk1.getEstimate(), (double)2048.0);
    }

    @Test
    public void isEmptyWithSampling() {
        float samplingProbability = 0.1f;
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.1f).build();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((long)sketch.getThetaLong(), (long)Long.MAX_VALUE);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
    }

    @Test
    public void sampling() {
        float samplingProbability = 0.001f;
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.001f).build();
        sketch.update("a", (Object)1.0);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        Assert.assertTrue((sketch.getUpperBound(1) > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0, (double)1.0E-7);
        Assert.assertEquals((float)((float)sketch.getTheta()), (float)0.001f);
        Assert.assertEquals((float)((float)sketch.getTheta()), (float)0.001f);
    }

    @Test
    public void exactMode() {
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        for (int i = 1; i <= 4096; ++i) {
            sketch.update((long)i, (Object)1.0);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)4096.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)4096.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)4096.0);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        int count = 0;
        TupleSketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)4096);
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
    }

    @Test
    public void estimationMode() {
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        for (int i = 1; i <= 8192; ++i) {
            sketch.update((long)i, (Object)1.0);
        }
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)8192.0, (double)81.92);
        Assert.assertTrue((sketch.getEstimate() >= sketch.getLowerBound(1) ? 1 : 0) != 0);
        Assert.assertTrue((sketch.getEstimate() < sketch.getUpperBound(1) ? 1 : 0) != 0);
        int count = 0;
        TupleSketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
            ++count;
        }
        Assert.assertTrue((count >= 4096 ? 1 : 0) != 0);
        sketch.reset();
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertFalse((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)0.0);
        Assert.assertEquals((double)sketch.getUpperBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getLowerBound(1), (double)0.0);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
        Assert.assertEquals((double)sketch.getTheta(), (double)1.0);
    }

    @Test
    public void estimationModeWithSamplingNoResizing() {
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(0.5f).setResizeFactor(ResizeFactor.X1).build();
        for (int i = 0; i < 16384; ++i) {
            sketch.update((long)i, (Object)1.0);
        }
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)16384.0, (double)163.84);
        Assert.assertTrue((sketch.getEstimate() >= sketch.getLowerBound(1) ? 1 : 0) != 0);
        Assert.assertTrue((sketch.getEstimate() < sketch.getUpperBound(1) ? 1 : 0) != 0);
    }

    @Test
    public void updatesOfAllKeyTypes() {
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch.update(1L, (Object)1.0);
        sketch.update(2.0, (Object)1.0);
        byte[] bytes = new byte[]{3, 3};
        sketch.update(bytes, (Object)1.0);
        sketch.update(ByteBuffer.wrap(bytes), (Object)1.0);
        sketch.update(ByteBuffer.wrap(bytes, 0, 1), (Object)1.0);
        int[] ints = new int[]{4};
        sketch.update(ints, (Object)1.0);
        long[] longs = new long[]{5L};
        sketch.update(longs, (Object)1.0);
        sketch.update("a", (Object)1.0);
        Assert.assertEquals((double)sketch.getEstimate(), (double)7.0);
    }

    @Test
    public void doubleSummaryDefaultSumMode() {
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch.update(1L, (Object)1.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        TupleSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.7);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.7);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.8);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.5);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void doubleSummaryMinMode() {
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Min)).build();
        sketch.update(1L, (Object)1.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        TupleSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.7);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)0.7);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.8);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)0.7);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void doubleSummaryMaxMode() {
        UpdatableTupleSketch sketch = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(DoubleSummary.Mode.Max)).build();
        sketch.update(1L, (Object)1.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        TupleSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)0.7);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch.update(1L, (Object)2.0);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)1);
        it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)2.0);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void serializeDeserializeExact() throws Exception {
        UpdatableTupleSketch sketch1 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).build();
        sketch1.update(1L, (Object)1.0);
        UpdatableTupleSketch sketch2 = TupleSketch.heapifyUpdatableSketch((MemorySegment)MemorySegment.ofArray(sketch1.toByteArray()), (SummaryDeserializer)new DoubleSummaryDeserializer(), (SummaryFactory)new DoubleSummaryFactory(this.mode));
        Assert.assertEquals((double)sketch2.getEstimate(), (double)1.0);
        TupleSketchIterator it = sketch2.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
        Assert.assertFalse((boolean)it.next());
        sketch2.update(1L, (Object)1.0);
        Assert.assertEquals((double)sketch2.getEstimate(), (double)1.0);
        sketch2.update(2L, (Object)1.0);
        Assert.assertEquals((double)sketch2.getEstimate(), (double)2.0);
    }

    @Test
    public void serializeDeserializeEstimationNoResizing() throws Exception {
        UpdatableTupleSketch sketch1 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setResizeFactor(ResizeFactor.X1).build();
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 8192; ++i) {
                sketch1.update((long)i, (Object)1.0);
            }
        }
        sketch1.trim();
        byte[] bytes = sketch1.toByteArray();
        TupleSketch sketch2 = TupleSketch.heapifySketch((MemorySegment)MemorySegment.ofArray(bytes), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertTrue((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)sketch2.getEstimate(), (double)8192.0, (double)8110.08);
        Assert.assertEquals((double)sketch1.getTheta(), (double)sketch2.getTheta());
        TupleSketchIterator it = sketch2.iterator();
        int count = 0;
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)10.0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)4096);
    }

    @Test
    public void serializeDeserializeSampling() throws Exception {
        int sketchSize = 16384;
        int numberOfUniques = 16384;
        UpdatableTupleSketch sketch1 = new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setNominalEntries(16384).setSamplingProbability(0.5f).build();
        for (int i = 0; i < 16384; ++i) {
            sketch1.update((long)i, (Object)1.0);
        }
        TupleSketch sketch2 = TupleSketch.heapifySketch((MemorySegment)MemorySegment.ofArray(sketch1.toByteArray()), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertTrue((boolean)sketch2.isEstimationMode());
        Assert.assertEquals((double)(sketch2.getEstimate() / 16384.0), (double)1.0, (double)0.01);
        Assert.assertEquals((double)((double)sketch2.getRetainedEntries() / 16384.0), (double)0.5, (double)0.01);
        Assert.assertEquals((double)sketch1.getTheta(), (double)sketch2.getTheta());
    }

    @Test
    public void checkUpdatableSketch() {
        DoubleSummaryFactory dsumFact = new DoubleSummaryFactory(this.mode);
        UpdatableTupleSketchBuilder bldr = new UpdatableTupleSketchBuilder((SummaryFactory)dsumFact);
        UpdatableTupleSketch usk = bldr.build();
        byte[] byteArr = new byte[]{};
        usk.update(byteArr, (Object)0.0);
        int[] intArr = new int[]{};
        usk.update(intArr, (Object)1.0);
        long[] longArr = new long[]{};
        usk.update(longArr, (Object)2.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void invalidSamplingProbability() {
        new UpdatableTupleSketchBuilder((SummaryFactory)new DoubleSummaryFactory(this.mode)).setSamplingProbability(2.0f).build();
    }
}

