/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitApproxMatchFilter
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitApproxMatchFilter.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitApproxMatchFilter() {
        super("Init Approx Match filter Value");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(container.getTlvId(), 3);
        searchRequestDecorator.addCurrentFilter(filter);
        searchRequestDecorator.setTerminalFilter(filter);
        if (IS_DEBUG) {
            LOG.debug("Initialize Approx Match filter");
        }
    }
}

