/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.ipojo.ContextListener;
import org.apache.felix.ipojo.ContextSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceConfigurationSource
implements ContextSource {
    private Dictionary<String, Object> m_configuration;
    private List<ContextListener> m_listeners = new ArrayList<ContextListener>();

    public InstanceConfigurationSource(Dictionary<String, Object> configuration) {
        this.m_configuration = configuration;
    }

    public void reconfigure(Dictionary<String, Object> newConfiguration) {
        Object newValue;
        String key;
        Hashtable<String, Object> configuration = new Hashtable<String, Object>();
        Enumeration<String> enumeration = this.m_configuration.keys();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            configuration.put(key, this.m_configuration.get(key));
        }
        this.m_configuration = newConfiguration;
        enumeration = configuration.keys();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            newValue = newConfiguration.get(key);
            Object oldValue = configuration.get(key);
            if (newValue == null) {
                this.fireUpdate(key, null);
                continue;
            }
            if (newValue.equals(oldValue)) continue;
            this.fireUpdate(key, newValue);
        }
        enumeration = newConfiguration.keys();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            if (configuration.get(key) != null) continue;
            newValue = newConfiguration.get(key);
            this.fireUpdate(key, newValue);
        }
    }

    private void fireUpdate(String key, Object newValue) {
        for (ContextListener listener : this.m_listeners) {
            listener.update(this, key, newValue);
        }
    }

    @Override
    public Object getProperty(String property) {
        return this.m_configuration.get(property);
    }

    @Override
    public Dictionary getContext() {
        return this.m_configuration;
    }

    @Override
    public void registerContextListener(ContextListener listener, String[] properties) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void unregisterContextListener(ContextListener listener) {
        this.m_listeners.remove(listener);
    }
}

