/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.datacache.nonkeyed;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.iteration.datacache.nonkeyed.Segment;
import org.apache.flink.iteration.datacache.nonkeyed.SegmentWriter;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.table.runtime.util.MemorySegmentPool;

@Internal
class MemorySegmentWriter<T>
implements SegmentWriter<T> {
    private final TypeSerializer<T> serializer;
    private final Path path;
    private final MemorySegmentPool segmentPool;
    private final ManagedMemoryOutputStream outputStream;
    private final DataOutputView outputView;
    private int count;

    MemorySegmentWriter(TypeSerializer<T> serializer, Path path, MemorySegmentPool segmentPool, long expectedSize) throws MemoryAllocationException {
        this.serializer = serializer;
        this.path = path;
        this.segmentPool = segmentPool;
        this.outputStream = new ManagedMemoryOutputStream(segmentPool, expectedSize);
        this.outputView = new DataOutputViewStreamWrapper((OutputStream)this.outputStream);
        this.count = 0;
    }

    @Override
    public boolean addRecord(T record) throws IOException {
        if (this.outputStream.getPos() >= 0x40000000L) {
            return false;
        }
        try {
            this.serializer.serialize(record, this.outputView);
            ++this.count;
            return true;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof MemoryAllocationException) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public Optional<Segment> finish() throws IOException {
        if (this.count > 0) {
            return Optional.of(new Segment(this.path, this.count, this.outputStream.getSegments()));
        }
        this.segmentPool.returnAll(this.outputStream.getSegments());
        return Optional.empty();
    }

    private static class ManagedMemoryOutputStream
    extends OutputStream {
        private final MemorySegmentPool segmentPool;
        private final int pageSize;
        private final List<MemorySegment> segments = new ArrayList<MemorySegment>();
        private int segmentIndex;
        private int segmentOffset;
        private long globalOffset;
        private long allocatedBytes;

        public ManagedMemoryOutputStream(MemorySegmentPool segmentPool, long expectedSize) throws MemoryAllocationException {
            this.segmentPool = segmentPool;
            this.pageSize = segmentPool.pageSize();
            this.ensureCapacity(Math.max(expectedSize, 1L));
        }

        public long getPos() {
            return this.globalOffset;
        }

        public List<MemorySegment> getSegments() {
            return this.segments;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(@Nullable byte[] b, int off, int len) throws IOException {
            try {
                this.ensureCapacity(this.globalOffset + (long)len);
            }
            catch (MemoryAllocationException e) {
                throw new RuntimeException(e);
            }
            while (len > 0) {
                int currentLen = Math.min(len, this.pageSize - this.segmentOffset);
                this.segments.get(this.segmentIndex).put(this.segmentOffset, b, off, currentLen);
                this.segmentOffset += currentLen;
                this.globalOffset += (long)currentLen;
                if (this.segmentOffset >= this.pageSize) {
                    ++this.segmentIndex;
                    this.segmentOffset = 0;
                }
                off += currentLen;
                len -= currentLen;
            }
        }

        private void ensureCapacity(long capacity) throws MemoryAllocationException {
            if (this.allocatedBytes >= capacity) {
                return;
            }
            int required = (int)(capacity % (long)this.pageSize == 0L ? capacity / (long)this.pageSize : capacity / (long)this.pageSize + 1L) - this.segments.size();
            ArrayList<MemorySegment> allocatedSegments = new ArrayList<MemorySegment>();
            for (int i = 0; i < required; ++i) {
                MemorySegment memorySegment = this.segmentPool.nextSegment();
                if (memorySegment == null) {
                    this.segmentPool.returnAll(allocatedSegments);
                    throw new MemoryAllocationException();
                }
                allocatedSegments.add(memorySegment);
            }
            this.segments.addAll(allocatedSegments);
            this.allocatedBytes += (long)allocatedSegments.size() * (long)this.pageSize;
        }
    }
}

