/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator.common;

import java.util.Arrays;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.benchmark.datagenerator.common.InputTableGenerator;
import org.apache.flink.ml.benchmark.datagenerator.common.RowGenerator;
import org.apache.flink.ml.benchmark.datagenerator.param.HasArraySize;
import org.apache.flink.ml.benchmark.datagenerator.param.HasNumDistinctValues;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class RandomStringArrayGenerator
extends InputTableGenerator<RandomStringArrayGenerator>
implements HasArraySize<RandomStringArrayGenerator>,
HasNumDistinctValues<RandomStringArrayGenerator> {
    @Override
    protected RowGenerator[] getRowGenerators() {
        final String[][] colNames = this.getColNames();
        Preconditions.checkState((colNames.length == 1 ? 1 : 0) != 0);
        final int numOutputCols = colNames[0].length;
        final int numDistinctValues = this.getNumDistinctValues();
        final int arraySize = this.getArraySize();
        return new RowGenerator[]{new RowGenerator(this.getNumValues(), this.getSeed()){

            @Override
            public Row getRow() {
                Row r = new Row(numOutputCols);
                for (int i = 0; i < numOutputCols; ++i) {
                    String[] item = new String[arraySize];
                    for (int j = 0; j < arraySize; ++j) {
                        item[j] = Integer.toString(this.random.nextInt(numDistinctValues));
                    }
                    r.setField(i, (Object)item);
                }
                return r;
            }

            @Override
            protected RowTypeInfo getRowTypeInfo() {
                Object[] outputTypes = new TypeInformation[colNames[0].length];
                Arrays.fill(outputTypes, Types.OBJECT_ARRAY((TypeInformation)Types.STRING));
                return new RowTypeInfo((TypeInformation[])outputTypes, colNames[0]);
            }
        }};
    }
}

