/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.ml.api.AlgoOperator;
import org.apache.flink.ml.api.Estimator;
import org.apache.flink.ml.api.Stage;
import org.apache.flink.ml.builder.PipelineModel;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class Pipeline
implements Estimator<Pipeline, PipelineModel> {
    private static final long serialVersionUID = 6384850154817512318L;
    private final List<Stage<?>> stages;
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public Pipeline(List<Stage<?>> stages) {
        this.stages = (List)Preconditions.checkNotNull(stages);
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public PipelineModel fit(Table ... inputs) {
        int lastEstimatorIdx = -1;
        for (int i = 0; i < this.stages.size(); ++i) {
            if (!(this.stages.get(i) instanceof Estimator)) continue;
            lastEstimatorIdx = i;
        }
        ArrayList modelStages = new ArrayList(this.stages.size());
        Table[] lastInputs = inputs;
        for (int i = 0; i < this.stages.size(); ++i) {
            Stage<?> stage = this.stages.get(i);
            AlgoOperator<Object> modelStage = stage instanceof AlgoOperator ? (AlgoOperator)stage : ((Estimator)stage).fit(lastInputs);
            modelStages.add(modelStage);
            if (i >= lastEstimatorIdx) continue;
            lastInputs = modelStage.transform(lastInputs);
        }
        return new PipelineModel(modelStages);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.savePipeline(this, this.stages, path);
    }

    public static Pipeline load(StreamTableEnvironment tEnv, String path) throws IOException {
        return new Pipeline(ReadWriteUtils.loadPipeline(tEnv, path, Pipeline.class.getName()));
    }

    @VisibleForTesting
    List<Stage<?>> getStages() {
        return Collections.unmodifiableList(this.stages);
    }
}

