/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.typeinfo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;

public class PriorityQueueSerializer<T>
extends TypeSerializer<PriorityQueue<T>> {
    private final Comparator<? super T> comparator;
    private final TypeSerializer<T> elementSerializer;

    public PriorityQueueSerializer(Comparator<? super T> comparator, TypeSerializer<T> elementSerializer) {
        this.comparator = comparator;
        this.elementSerializer = elementSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<PriorityQueue<T>> duplicate() {
        return new PriorityQueueSerializer<T>(this.comparator, this.elementSerializer.duplicate());
    }

    public PriorityQueue<T> createInstance() {
        return new PriorityQueue<T>(this.comparator);
    }

    public PriorityQueue<T> copy(PriorityQueue<T> from) {
        return new PriorityQueue<T>(from);
    }

    public PriorityQueue<T> copy(PriorityQueue<T> from, PriorityQueue<T> reuse) {
        return new PriorityQueue<T>(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(PriorityQueue<T> queue, DataOutputView target) throws IOException {
        ArrayList<T> tmpList = new ArrayList<T>(queue);
        ListSerializer listSerializer = new ListSerializer(this.elementSerializer);
        listSerializer.serialize(tmpList, target);
    }

    public PriorityQueue<T> deserialize(DataInputView source) throws IOException {
        ListSerializer listSerializer = new ListSerializer(this.elementSerializer);
        List tmpList = listSerializer.deserialize(source);
        PriorityQueue<T> queue = new PriorityQueue<T>(this.comparator);
        queue.addAll(tmpList);
        return queue;
    }

    public PriorityQueue<T> deserialize(PriorityQueue<T> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        ListSerializer listSerializer = new ListSerializer(this.elementSerializer);
        listSerializer.copy(source, target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PriorityQueueSerializer that = (PriorityQueueSerializer)((Object)o);
        return Objects.equals(this.elementSerializer, that.elementSerializer) && Objects.equals(this.comparator, that.comparator);
    }

    public int hashCode() {
        return Objects.hash(this.comparator != null ? this.comparator.hashCode() : 0, this.elementSerializer != null ? this.elementSerializer.hashCode() : 0);
    }

    public TypeSerializerSnapshot<PriorityQueue<T>> snapshotConfiguration() {
        return new PriorityQueueTypeSerializerSnapshot(this);
    }

    private static final class PriorityQueueTypeSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<PriorityQueue<T>, PriorityQueueSerializer<T>> {
        private static final int CURRENT_VERSION = 1;
        private Comparator<? super T> comparator;

        public PriorityQueueTypeSerializerSnapshot() {
            super(PriorityQueueSerializer.class);
        }

        public PriorityQueueTypeSerializerSnapshot(PriorityQueueSerializer<T> serializer) {
            super(serializer);
            this.comparator = ((PriorityQueueSerializer)serializer).comparator;
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(PriorityQueueSerializer<T> outerSerializer) {
            return new TypeSerializer[]{((PriorityQueueSerializer)outerSerializer).elementSerializer};
        }

        protected PriorityQueueSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            TypeSerializer<?> elementSerializer = nestedSerializers[0];
            return new PriorityQueueSerializer<T>(this.comparator, elementSerializer);
        }

        protected void writeOuterSnapshot(DataOutputView out) throws IOException {
            DataOutputViewStream stream = new DataOutputViewStream(out);
            InstantiationUtil.serializeObject((OutputStream)stream, this.comparator);
        }

        protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            DataInputViewStream stream = new DataInputViewStream(in);
            try {
                this.comparator = (Comparator)InstantiationUtil.deserializeObject((InputStream)stream, (ClassLoader)userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(PriorityQueueSerializer<T> newSerializer) {
            return this.comparator.getClass() == ((PriorityQueueSerializer)newSerializer).comparator.getClass() ? CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS : CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
        }
    }
}

