/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.typeinfo;

import java.util.Comparator;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.ml.common.typeinfo.PriorityQueueSerializer;

public class PriorityQueueTypeInfo<T>
extends TypeInformation<PriorityQueue<T>> {
    private final Comparator<? super T> comparator;
    private final TypeInformation<T> elementTypeInfo;

    public PriorityQueueTypeInfo(Comparator<? super T> comparator, TypeInformation<T> elementTypeInfo) {
        this.comparator = comparator;
        this.elementTypeInfo = elementTypeInfo;
    }

    public TypeInformation<T> getElementTypeInfo() {
        return this.elementTypeInfo;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<PriorityQueue<T>> getTypeClass() {
        return PriorityQueue.class;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<PriorityQueue<T>> createSerializer(ExecutionConfig config) {
        return new PriorityQueueSerializer<T>(this.comparator, this.elementTypeInfo.createSerializer(config));
    }

    public String toString() {
        return "PriorityQueue Type";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PriorityQueueTypeInfo that = (PriorityQueueTypeInfo)((Object)obj);
        return Objects.equals(this.comparator, that.comparator) && Objects.equals(this.elementTypeInfo, that.elementTypeInfo);
    }

    public int hashCode() {
        return Objects.hash(this.comparator != null ? this.comparator.hashCode() : 0, this.elementTypeInfo != null ? this.elementTypeInfo.hashCode() : 0);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof PriorityQueueTypeInfo;
    }
}

