/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.imputer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class ImputerModelData {
    public static final TypeInformation<ImputerModelData> TYPE_INFO = Types.POJO(ImputerModelData.class, Collections.singletonMap("surrogates", Types.MAP((TypeInformation)Types.STRING, (TypeInformation)Types.DOUBLE)));
    public Map<String, Double> surrogates;

    public ImputerModelData() {
    }

    public ImputerModelData(Map<String, Double> surrogates) {
        this.surrogates = surrogates;
    }

    public static DataStream<ImputerModelData> getModelDataStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> new ImputerModelData((Map)x.getField(0)), TYPE_INFO);
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<ImputerModelData> {
        public StreamFormat.Reader<ImputerModelData> createReader(Configuration configuration, final FSDataInputStream fsDataInputStream) {
            return new StreamFormat.Reader<ImputerModelData>(){

                public ImputerModelData read() throws IOException {
                    DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)fsDataInputStream);
                    try {
                        MapSerializer mapSerializer = new MapSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)DoubleSerializer.INSTANCE);
                        Map surrogates = mapSerializer.deserialize((DataInputView)source);
                        return new ImputerModelData(surrogates);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    fsDataInputStream.close();
                }
            };
        }

        public TypeInformation<ImputerModelData> getProducedType() {
            return TYPE_INFO;
        }
    }

    public static class ModelDataEncoder
    implements Encoder<ImputerModelData> {
        public void encode(ImputerModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper(outputStream);
            MapSerializer mapSerializer = new MapSerializer((TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)DoubleSerializer.INSTANCE);
            mapSerializer.serialize(modelData.surrogates, (DataOutputView)dataOutputView);
        }
    }
}

